/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityMantisShrimp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.Item;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class MantisShrimpAIBreakBlocks
extends Goal {
    private EntityMantisShrimp mantisShrimp;
    private int idleAtFlowerTime = 0;
    private int timeoutCounter = 0;
    private int searchCooldown = 0;
    private boolean isAboveDestinationBear;
    private BlockPos destinationBlock;
    private final BlockSorter targetSorter;

    public MantisShrimpAIBreakBlocks(EntityMantisShrimp mantisShrimp) {
        this.mantisShrimp = mantisShrimp;
        this.targetSorter = new BlockSorter((Entity)mantisShrimp);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void func_75249_e() {
        super.func_75249_e();
    }

    public boolean func_75250_a() {
        if (!(this.mantisShrimp.func_70631_g_() || this.mantisShrimp.func_70638_az() != null && this.mantisShrimp.func_70638_az().func_70089_S() || this.mantisShrimp.getCommand() != 3 || this.mantisShrimp.func_184614_ca().func_190926_b())) {
            if (this.searchCooldown <= 0) {
                this.resetTarget();
                this.searchCooldown = 100 + this.mantisShrimp.func_70681_au().nextInt(200);
                return this.destinationBlock != null;
            }
            --this.searchCooldown;
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.destinationBlock != null && this.timeoutCounter < 1200 && (this.mantisShrimp.func_70638_az() == null || !this.mantisShrimp.func_70638_az().func_70089_S()) && this.mantisShrimp.getCommand() == 3 && !this.mantisShrimp.func_184614_ca().func_190926_b();
    }

    public void func_75251_c() {
        this.searchCooldown = 50;
        this.timeoutCounter = 0;
        this.destinationBlock = null;
    }

    public double getTargetDistanceSq() {
        return 2.3;
    }

    public void func_75246_d() {
        BlockPos blockpos = this.destinationBlock;
        float yDist = (float)Math.abs((double)blockpos.func_177956_o() - this.mantisShrimp.func_226278_cu_() - (double)(this.mantisShrimp.func_213302_cg() / 2.0f));
        this.mantisShrimp.func_70661_as().func_75492_a((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5, 1.0);
        if (!this.isWithinXZDist(blockpos, this.mantisShrimp.func_213303_ch(), this.getTargetDistanceSq()) || yDist > 2.0f) {
            this.isAboveDestinationBear = false;
            ++this.timeoutCounter;
        } else {
            this.isAboveDestinationBear = true;
            --this.timeoutCounter;
        }
        if (this.timeoutCounter > 2400) {
            this.func_75251_c();
        }
        if (this.getIsAboveDestination()) {
            this.mantisShrimp.func_200602_a(EntityAnchorArgument.Type.EYES, new Vector3d((double)this.destinationBlock.func_177958_n() + 0.5, (double)this.destinationBlock.func_177956_o(), (double)this.destinationBlock.func_177952_p() + 0.5));
            if (this.idleAtFlowerTime >= 2) {
                this.idleAtFlowerTime = 0;
                this.breakBlock();
                this.func_75251_c();
            } else {
                this.mantisShrimp.punch();
                ++this.idleAtFlowerTime;
            }
        }
    }

    private void resetTarget() {
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        int radius = 16;
        for (BlockPos pos : BlockPos.func_218281_b((BlockPos)this.mantisShrimp.func_233580_cy_().func_177982_a(-radius, -radius, -radius), (BlockPos)this.mantisShrimp.func_233580_cy_().func_177982_a(radius, radius, radius)).map(BlockPos::func_185334_h).collect(Collectors.toList())) {
            if (this.mantisShrimp.field_70170_p.func_175623_d(pos) || !this.shouldMoveTo((IWorldReader)this.mantisShrimp.field_70170_p, pos) || this.mantisShrimp.func_70090_H() && !this.isBlockTouchingWater(pos)) continue;
            allBlocks.add(pos);
        }
        if (!allBlocks.isEmpty()) {
            allBlocks.sort(this.targetSorter);
            for (BlockPos pos : allBlocks) {
                if (!this.canSeeBlock(pos)) continue;
                this.destinationBlock = pos;
                return;
            }
        }
        this.destinationBlock = null;
    }

    private boolean isBlockTouchingWater(BlockPos pos) {
        for (Direction dir : Direction.values()) {
            if (!this.mantisShrimp.field_70170_p.func_204610_c(pos.func_177972_a(dir)).func_206884_a((ITag)FluidTags.field_206959_a)) continue;
            return true;
        }
        return false;
    }

    private boolean isWithinXZDist(BlockPos blockpos, Vector3d positionVec, double distance) {
        return blockpos.func_218140_a(positionVec.func_82615_a(), (double)blockpos.func_177956_o(), positionVec.func_82616_c(), true) < distance * distance;
    }

    protected boolean getIsAboveDestination() {
        return this.isAboveDestinationBear;
    }

    private void breakBlock() {
        if (this.shouldMoveTo((IWorldReader)this.mantisShrimp.field_70170_p, this.destinationBlock)) {
            BlockState state = this.mantisShrimp.field_70170_p.func_180495_p(this.destinationBlock);
            if (!this.mantisShrimp.field_70170_p.func_175623_d(this.destinationBlock) && ForgeHooks.canEntityDestroy((World)this.mantisShrimp.field_70170_p, (BlockPos)this.destinationBlock, (LivingEntity)this.mantisShrimp) && state.func_185887_b((IBlockReader)this.mantisShrimp.field_70170_p, this.destinationBlock) >= 0.0f) {
                this.mantisShrimp.field_70170_p.func_175655_b(this.destinationBlock, true);
            }
        }
    }

    private boolean canSeeBlock(BlockPos destinationBlock) {
        Vector3d Vector3d2 = new Vector3d(this.mantisShrimp.func_226277_ct_(), this.mantisShrimp.func_226280_cw_(), this.mantisShrimp.func_226281_cx_());
        Vector3d blockVec = Vector3d.func_237489_a_((Vector3i)destinationBlock);
        BlockRayTraceResult result = this.mantisShrimp.field_70170_p.func_217299_a(new RayTraceContext(Vector3d2, blockVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this.mantisShrimp));
        return result.func_216350_a().equals((Object)destinationBlock);
    }

    protected boolean shouldMoveTo(IWorldReader worldIn, BlockPos pos) {
        Item blockItem = worldIn.func_180495_p(pos).func_177230_c().func_199767_j();
        return this.mantisShrimp.func_184614_ca().func_77973_b() == blockItem;
    }

    public class BlockSorter
    implements Comparator<BlockPos> {
        private final Entity entity;

        public BlockSorter(Entity entity) {
            this.entity = entity;
        }

        @Override
        public int compare(BlockPos pos1, BlockPos pos2) {
            double distance1 = this.getDistance(pos1);
            double distance2 = this.getDistance(pos2);
            return Double.compare(distance1, distance2);
        }

        private double getDistance(BlockPos pos) {
            double deltaX = this.entity.func_226277_ct_() - ((double)pos.func_177958_n() + 0.5);
            double deltaY = this.entity.func_226278_cu_() + (double)this.entity.func_70047_e() - ((double)pos.func_177956_o() + 0.5);
            double deltaZ = this.entity.func_226281_cx_() - ((double)pos.func_177952_p() + 0.5);
            return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        }
    }
}

