/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.fluid;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;

public class FluidUtils {
    public static FluidStack copyFluidStackWithAmount(FluidStack stack, int amount) {
        return FluidUtils.copyFluidStackWithAmount(stack, amount, false);
    }

    public static FluidStack copyFluidStackWithAmount(FluidStack stack, int amount, boolean stripPressure) {
        if (stack == null) {
            return null;
        }
        FluidStack fs = new FluidStack(stack, amount);
        if (stripPressure && fs.hasTag() && fs.getOrCreateTag().func_74764_b("pressurized")) {
            CompoundNBT tag = fs.getOrCreateTag();
            tag.func_82580_o("pressurized");
            if (tag.isEmpty()) {
                fs.setTag(null);
            }
        }
        return fs;
    }

    public static Optional<FluidStack> getFluidContained(@Nonnull ItemStack container) {
        if (!container.func_190926_b()) {
            return FluidUtil.getFluidHandler((ItemStack)container).map(handler -> handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE));
        }
        return Optional.empty();
    }

    public static FluidActionResult tryEmptyContainer(@Nonnull ItemStack container, IFluidHandler fluidDestination, int maxAmount, IFluidHandler.FluidAction doDrain) {
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
        return containerCopy.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(handler -> {
            FluidStack simulatedMoved = FluidUtil.tryFluidTransfer((IFluidHandler)fluidDestination, (IFluidHandler)handler, (int)maxAmount, (boolean)false);
            if (simulatedMoved.isEmpty()) {
                return FluidActionResult.FAILURE;
            }
            handler.drain(simulatedMoved, IFluidHandler.FluidAction.EXECUTE);
            fluidDestination.fill(simulatedMoved, doDrain);
            return new FluidActionResult(handler.getContainer());
        }).orElse(FluidActionResult.FAILURE);
    }

    public static boolean interactWithFluidHandler(PlayerEntity player, Hand hand, final IFluidHandler handler) {
        MutableObject lastNonSimulated = new MutableObject();
        MutableBoolean isInsert = new MutableBoolean();
        WrapperFluidHandler simulationWrapper = new WrapperFluidHandler(handler, (Mutable)lastNonSimulated, isInsert){
            final /* synthetic */ Mutable val$lastNonSimulated;
            final /* synthetic */ MutableBoolean val$isInsert;
            {
                this.val$lastNonSimulated = mutable;
                this.val$isInsert = mutableBoolean;
                super(handler2);
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                int result = handler.fill(resource, IFluidHandler.FluidAction.SIMULATE);
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    this.val$lastNonSimulated.setValue((Object)new FluidStack(resource, result));
                    this.val$isInsert.setTrue();
                }
                return result;
            }

            @Nonnull
            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                FluidStack result = handler.drain(resource, IFluidHandler.FluidAction.SIMULATE);
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    this.val$isInsert.setFalse();
                    this.val$lastNonSimulated.setValue((Object)result.copy());
                }
                return result;
            }

            @Nonnull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                FluidStack result = handler.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE);
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    this.val$isInsert.setFalse();
                    this.val$lastNonSimulated.setValue((Object)result.copy());
                }
                return result;
            }
        };
        boolean success = FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)simulationWrapper);
        if (success) {
            if (isInsert.booleanValue()) {
                handler.fill((FluidStack)lastNonSimulated.getValue(), IFluidHandler.FluidAction.EXECUTE);
            } else {
                handler.drain((FluidStack)lastNonSimulated.getValue(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        return success;
    }

    public static abstract class WrapperFluidHandler
    implements IFluidHandler {
        private final IFluidHandler handler;

        protected WrapperFluidHandler(IFluidHandler handler) {
            this.handler = handler;
        }

        public int getTanks() {
            return this.handler.getTanks();
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.handler.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.handler.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.handler.isFluidValid(tank, stack);
        }
    }
}

