/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.multilayer;

import blusunrize.immersiveengineering.client.models.multilayer.BakedMultiLayerModel;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public class MultiLayerModel
implements IModelGeometry<MultiLayerModel> {
    private final Map<String, IModelGeometry<?>> subModels;

    public MultiLayerModel(Map<String, IModelGeometry<?>> subModels) {
        this.subModels = subModels;
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        ArrayList<RenderMaterial> ret = new ArrayList<RenderMaterial>();
        for (IModelGeometry<?> geometry : this.subModels.values()) {
            ret.addAll(geometry.getTextures(owner, modelGetter, missingTextureErrors));
        }
        return ret;
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        HashMap<String, IBakedModel> baked = new HashMap<String, IBakedModel>();
        for (Map.Entry<String, IModelGeometry<?>> e : this.subModels.entrySet()) {
            baked.put(e.getKey(), e.getValue().bake(owner, bakery, spriteGetter, modelTransform, overrides, modelLocation));
        }
        return new BakedMultiLayerModel(baked);
    }
}

