/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.block;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.BaseCableBlock;
import dev.ftb.mods.ftbic.block.BurntCableBlock;
import dev.ftb.mods.ftbic.block.ElectricBlock;
import dev.ftb.mods.ftbic.block.entity.ElectricBlockEntity;
import dev.ftb.mods.ftbic.util.EnergyHandler;
import dev.ftb.mods.ftbic.util.EnergyTier;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.energy.CapabilityEnergy;
import org.jetbrains.annotations.Nullable;

public class CableBlock
extends BaseCableBlock {
    public final EnergyTier tier;

    public CableBlock(EnergyTier _tier, int border, SoundType soundType) {
        super(border, soundType);
        this.tier = _tier;
    }

    @Override
    @Deprecated
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld level, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            level.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)level));
        }
        if (facingState.func_177230_c() instanceof BurntCableBlock) {
            return state;
        }
        boolean c = this.canCableConnectFrom(facingState, (IBlockReader)level, facingPos, facing.func_176734_d());
        if (!level.func_201670_d() && facingState.func_177230_c() != this && c != (Boolean)state.func_177229_b((Property)CONNECTION[facing.ordinal()])) {
            ElectricBlockEntity.electricNetworkUpdated(level, facingPos);
        }
        return (BlockState)state.func_206870_a((Property)CONNECTION[facing.ordinal()], (Comparable)Boolean.valueOf(c));
    }

    private boolean canCableConnectFrom(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        if (state.func_177230_c() instanceof CableBlock) {
            return state.func_177230_c() == this;
        }
        if (state.func_177230_c() instanceof ElectricBlock) {
            return true;
        }
        if (!state.func_196958_f()) {
            TileEntity t = world.func_175625_s(pos);
            return t instanceof EnergyHandler || FTBICConfig.ZAP_TO_FE_CONVERSION_RATE > 0.0 && t != null && t.getCapability(CapabilityEnergy.ENERGY, face).isPresent();
        }
        return false;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = this.func_176223_P();
        for (Direction direction : Direction.values()) {
            BlockPos p = pos.func_177972_a(direction);
            BlockState s = world.func_180495_p(p);
            if (!this.canCableConnectFrom(s, (IBlockReader)world, p, direction.func_176734_d())) continue;
            state = (BlockState)state.func_206870_a((Property)CONNECTION[direction.ordinal()], (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(world.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a));
    }

    @Deprecated
    public void func_220082_b(BlockState state, World level, BlockPos pos, BlockState state1, boolean b) {
        super.func_220082_b(state, level, pos, state1, b);
        if (!level.func_201670_d() && !state.func_177230_c().func_235332_a_(state1.func_177230_c())) {
            ElectricBlockEntity.electricNetworkUpdated((IWorld)level, pos);
        }
    }

    @Deprecated
    public void func_196243_a(BlockState state, World level, BlockPos pos, BlockState state1, boolean b) {
        super.func_196243_a(state, level, pos, state1, b);
        if (!level.func_201670_d() && !state.func_177230_c().func_235332_a_(state1.func_177230_c())) {
            ElectricBlockEntity.electricNetworkUpdated((IWorld)level, pos);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader level, List<ITextComponent> list, ITooltipFlag flag) {
        list.add((ITextComponent)new TranslationTextComponent("ftbic.max_input", new Object[]{FTBICUtils.formatEnergy(this.tier.transferRate).func_240702_b_("/t").func_240699_a_(TextFormatting.GRAY)}).func_240699_a_(TextFormatting.DARK_GRAY));
    }
}

