/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.block;

import dev.ftb.mods.ftbic.block.ElectricBlockInstance;
import dev.ftb.mods.ftbic.block.SprayPaintable;
import dev.ftb.mods.ftbic.block.entity.ElectricBlockEntity;
import dev.ftb.mods.ftbic.item.FTBICItems;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import org.jetbrains.annotations.Nullable;

public class ElectricBlock
extends Block
implements SprayPaintable {
    public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");
    public final ElectricBlockInstance electricBlockInstance;

    public ElectricBlock(ElectricBlockInstance m) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(3.5f).func_200947_a(SoundType.field_185852_e).harvestTool(ToolType.PICKAXE).func_235861_h_());
        this.electricBlockInstance = m;
        BlockState state = (BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)SprayPaintable.DARK, (Comparable)Boolean.valueOf(false));
        if (m.facingProperty != null) {
            state = (BlockState)state.func_206870_a((Property)this.electricBlockInstance.facingProperty, (Comparable)Direction.SOUTH);
        }
        if (this.electricBlockInstance.canBeActive) {
            state = (BlockState)state.func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
        }
        this.func_180632_j(state);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader level) {
        return this.electricBlockInstance.blockEntity.get().func_200968_a();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{SprayPaintable.DARK});
        if (ElectricBlockInstance.current.facingProperty != null) {
            builder.func_206894_a(new Property[]{ElectricBlockInstance.current.facingProperty});
        }
        if (ElectricBlockInstance.current.canBeActive) {
            builder.func_206894_a(new Property[]{ACTIVE});
        }
    }

    @Deprecated
    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return this.electricBlockInstance.facingProperty == null ? state : (BlockState)state.func_206870_a((Property)this.electricBlockInstance.facingProperty, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)this.electricBlockInstance.facingProperty)));
    }

    @Deprecated
    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return this.electricBlockInstance.facingProperty == null ? state : state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)this.electricBlockInstance.facingProperty)));
    }

    public BlockState func_196258_a(BlockItemUseContext arg) {
        if (this.electricBlockInstance.facingProperty == null) {
            return this.func_176223_P();
        }
        if (this.electricBlockInstance.facingProperty == BlockStateProperties.field_208157_J) {
            return (BlockState)this.func_176223_P().func_206870_a((Property)this.electricBlockInstance.facingProperty, (Comparable)arg.func_195992_f().func_176734_d());
        }
        return (BlockState)this.func_176223_P().func_206870_a((Property)this.electricBlockInstance.facingProperty, (Comparable)arg.func_196010_d().func_176734_d());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World level, BlockPos pos, Random r) {
        TileEntity entity;
        boolean active;
        boolean bl = active = this.electricBlockInstance.canBeActive && (Boolean)state.func_177229_b((Property)ACTIVE) != false;
        if ((active || this.electricBlockInstance.canBurn) && (entity = level.func_175625_s(pos)) instanceof ElectricBlockEntity) {
            ElectricBlockEntity electricBlockEntity = (ElectricBlockEntity)entity;
            double x = pos.func_177958_n();
            double y = pos.func_177956_o();
            double z = pos.func_177952_p();
            if (electricBlockEntity.isBurnt()) {
                if (r.nextInt(10) == 0) {
                    level.func_184134_a(x + 0.5, y + 0.5, z + 0.5, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + r.nextFloat(), r.nextFloat() * 0.7f + 0.3f, false);
                }
                for (int i = 0; i < 5; ++i) {
                    level.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + (double)r.nextFloat(), y + 1.0, z + (double)r.nextFloat(), 0.0, 0.0, 0.0);
                    level.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x, y + 0.05 + (double)r.nextFloat(), z + (double)r.nextFloat(), 0.0, 0.0, 0.0);
                    level.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 1.0, y + 0.05 + (double)r.nextFloat(), z + (double)r.nextFloat(), 0.0, 0.0, 0.0);
                    level.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + (double)r.nextFloat(), y + 0.05 + (double)r.nextFloat(), z, 0.0, 0.0, 0.0);
                    level.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + (double)r.nextFloat(), y + 0.05 + (double)r.nextFloat(), z + 1.0, 0.0, 0.0, 0.0);
                    if (r.nextInt(5) == 0) {
                        level.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x, y + 0.05 + (double)r.nextFloat(), z + (double)r.nextFloat(), 0.0, 0.0, 0.0);
                    }
                    if (r.nextInt(5) == 0) {
                        level.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + 1.0, y + 0.05 + (double)r.nextFloat(), z + (double)r.nextFloat(), 0.0, 0.0, 0.0);
                    }
                    if (r.nextInt(5) == 0) {
                        level.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + (double)r.nextFloat(), y + 0.05 + (double)r.nextFloat(), z, 0.0, 0.0, 0.0);
                    }
                    if (r.nextInt(5) != 0) continue;
                    level.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + (double)r.nextFloat(), y + 0.05 + (double)r.nextFloat(), z + 1.0, 0.0, 0.0, 0.0);
                }
                level.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + (double)r.nextFloat(), y + 1.1, z + (double)r.nextFloat(), 0.0, 0.0, 0.0);
                level.func_195594_a((IParticleData)ParticleTypes.field_197594_E, x + 0.5, y + 1.0, z + 0.5, 0.0, 0.0, 0.0);
            } else if (active) {
                electricBlockEntity.spawnActiveParticles(level, x, y, z, state, r);
            }
        }
    }

    @Deprecated
    public void func_220082_b(BlockState state, World level, BlockPos pos, BlockState state1, boolean b) {
        super.func_220082_b(state, level, pos, state1, b);
        if (!level.func_201670_d() && !state.func_177230_c().func_235332_a_(state1.func_177230_c())) {
            ElectricBlockEntity.electricNetworkUpdated((IWorld)level, pos);
        }
    }

    public void func_180633_a(World level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.func_180633_a(level, pos, state, entity, stack);
        TileEntity blockEntity = level.func_175625_s(pos);
        if (blockEntity instanceof ElectricBlockEntity) {
            ((ElectricBlockEntity)blockEntity).onPlacedBy(entity, stack);
        }
    }

    @Deprecated
    public void func_196243_a(BlockState state, World level, BlockPos pos, BlockState state1, boolean b) {
        if (!level.func_201670_d() && !state.func_177230_c().func_235332_a_(state1.func_177230_c())) {
            ElectricBlockEntity.electricNetworkUpdated((IWorld)level, pos);
            TileEntity entity = level.func_175625_s(pos);
            if (entity instanceof ElectricBlockEntity) {
                ((ElectricBlockEntity)entity).onBroken(level, pos);
            }
        }
        super.func_196243_a(state, level, pos, state1, b);
    }

    @Deprecated
    public void func_220069_a(BlockState state, World level, BlockPos pos, Block block, BlockPos pos1, boolean b) {
        TileEntity entity;
        super.func_220069_a(state, level, pos, block, pos1, b);
        if (!level.func_201670_d() && (entity = level.func_175625_s(pos)) instanceof ElectricBlockEntity) {
            ((ElectricBlockEntity)entity).neighborChanged(pos1, block);
        }
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity entity = level.func_175625_s(pos);
        if (entity instanceof ElectricBlockEntity) {
            ElectricBlockEntity electricBlockEntity = (ElectricBlockEntity)entity;
            if (electricBlockEntity.isBurnt()) {
                if (player.func_184586_b(hand).func_77973_b() == FTBICItems.FUSE.item.get()) {
                    electricBlockEntity.setBurnt(false);
                    level.func_184133_a(player, pos, SoundEvents.field_187839_fV, SoundCategory.BLOCKS, 0.3f, 0.6f);
                    if (!level.func_201670_d() && !player.func_184812_l_()) {
                        player.func_184586_b(hand).func_190918_g(1);
                    }
                    return ActionResultType.func_233537_a_((boolean)level.func_201670_d());
                }
                if (!level.func_201670_d()) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("ftbic.fuse_info"), Util.field_240973_b_);
                }
                return ActionResultType.SUCCESS;
            }
            return electricBlockEntity.rightClick(player, hand, hit);
        }
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader level, List<ITextComponent> list, ITooltipFlag flag) {
        if (this.electricBlockInstance.wip) {
            list.add((ITextComponent)new StringTextComponent("WIP!").func_240699_a_(TextFormatting.RED));
        }
        if (this.electricBlockInstance.maxEnergyOutput > 0.0) {
            list.add((ITextComponent)new TranslationTextComponent("ftbic.energy_output", new Object[]{FTBICUtils.formatEnergy(this.electricBlockInstance.maxEnergyOutput).func_240702_b_("/t").func_240699_a_(TextFormatting.GRAY)}).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        if (this.electricBlockInstance.energyUsage > 0.0) {
            if (this.electricBlockInstance.energyUsageIsPerTick) {
                list.add((ITextComponent)new TranslationTextComponent("ftbic.energy_usage", new Object[]{FTBICUtils.formatEnergy(this.electricBlockInstance.energyUsage).func_240702_b_("/t").func_240699_a_(TextFormatting.GRAY)}).func_240699_a_(TextFormatting.DARK_GRAY));
            } else {
                list.add((ITextComponent)new TranslationTextComponent("ftbic.energy_usage", new Object[]{FTBICUtils.formatEnergy(this.electricBlockInstance.energyUsage).func_240699_a_(TextFormatting.GRAY)}).func_240699_a_(TextFormatting.DARK_GRAY));
            }
        }
        if (this.electricBlockInstance.maxEnergyInput > 0.0) {
            list.add((ITextComponent)new TranslationTextComponent("ftbic.max_input", new Object[]{FTBICUtils.formatEnergy(this.electricBlockInstance.maxEnergyInput).func_240702_b_("/t").func_240699_a_(TextFormatting.GRAY)}).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        if (this.electricBlockInstance.energyCapacity > 0.0 && Screen.func_231173_s_()) {
            list.add((ITextComponent)new TranslationTextComponent("ftbic.energy_capacity", new Object[]{FTBICUtils.formatEnergy(this.electricBlockInstance.energyCapacity).func_240699_a_(TextFormatting.GRAY)}).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("BlockEntityTag", 10)) {
            CompoundNBT tag = stack.func_77978_p().func_74775_l("BlockEntityTag").func_74737_b();
            tag.func_82580_o("x");
            tag.func_82580_o("y");
            tag.func_82580_o("z");
            tag.func_82580_o("id");
            tag.func_82580_o("Inventory");
            tag.func_82580_o("Upgrades");
            tag.func_82580_o("Battery");
            tag.func_82580_o("ChargeBattery");
            tag.func_82580_o("PlacerId");
            tag.func_82580_o("PlacerName");
            for (String key : tag.func_150296_c()) {
                list.add((ITextComponent)new StringTextComponent("- " + key + ": " + tag.func_74781_a(key)).func_240699_a_(TextFormatting.DARK_GRAY));
            }
        }
    }

    public void func_176199_a(World level, BlockPos pos, Entity entity) {
        TileEntity blockEntity;
        if (entity instanceof ServerPlayerEntity && (blockEntity = level.func_175625_s(pos)) instanceof ElectricBlockEntity) {
            ((ElectricBlockEntity)blockEntity).stepOn((ServerPlayerEntity)entity);
        }
    }
}

