/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.block;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.ElectricBlockInstance;
import dev.ftb.mods.ftbic.block.entity.generator.BasicGeneratorBlockEntity;
import dev.ftb.mods.ftbic.block.entity.generator.EVSolarPanelBlockEntity;
import dev.ftb.mods.ftbic.block.entity.generator.GeothermalGeneratorBlockEntity;
import dev.ftb.mods.ftbic.block.entity.generator.HVSolarPanelBlockEntity;
import dev.ftb.mods.ftbic.block.entity.generator.LVSolarPanelBlockEntity;
import dev.ftb.mods.ftbic.block.entity.generator.MVSolarPanelBlockEntity;
import dev.ftb.mods.ftbic.block.entity.generator.NuclearReactorBlockEntity;
import dev.ftb.mods.ftbic.block.entity.generator.WindMillBlockEntity;
import dev.ftb.mods.ftbic.block.entity.machine.AdvancedCentrifugeBlockEntity;
import dev.ftb.mods.ftbic.block.entity.machine.AdvancedCompressorBlockEntity;
import dev.ftb.mods.ftbic.block.entity.machine.AdvancedMaceratorBlockEntity;
import dev.ftb.mods.ftbic.block.entity.machine.AdvancedPoweredFurnaceBlockEntity;
import dev.ftb.mods.ftbic.block.entity.machine.AntimatterConstructorBlockEntity;
import dev.ftb.mods.ftbic.block.entity.machine.CanningMachineBlockEntity;
import dev.ftb.mods.ftbic.block.entity.machine.CentrifugeBlockEntity;
import dev.ftb.mods.ftbic.block.entity.machine.ChargePadBlockEntity;
import dev.ftb.mods.ftbic.block.entity.machine.CompressorBlockEntity;
import dev.ftb.mods.ftbic.block.entity.machine.ExtruderBlockEntity;
import dev.ftb.mods.ftbic.block.entity.machine.MaceratorBlockEntity;
import dev.ftb.mods.ftbic.block.entity.machine.PoweredCraftingTableBlockEntity;
import dev.ftb.mods.ftbic.block.entity.machine.PoweredFurnaceBlockEntity;
import dev.ftb.mods.ftbic.block.entity.machine.PumpBlockEntity;
import dev.ftb.mods.ftbic.block.entity.machine.QuarryBlockEntity;
import dev.ftb.mods.ftbic.block.entity.machine.ReprocessorBlockEntity;
import dev.ftb.mods.ftbic.block.entity.machine.RollerBlockEntity;
import dev.ftb.mods.ftbic.block.entity.machine.TeleporterBlockEntity;
import dev.ftb.mods.ftbic.block.entity.storage.EVBatteryBoxBlockEntity;
import dev.ftb.mods.ftbic.block.entity.storage.EVTransformerBlockEntity;
import dev.ftb.mods.ftbic.block.entity.storage.HVBatteryBoxBlockEntity;
import dev.ftb.mods.ftbic.block.entity.storage.HVTransformerBlockEntity;
import dev.ftb.mods.ftbic.block.entity.storage.LVBatteryBoxBlockEntity;
import dev.ftb.mods.ftbic.block.entity.storage.LVTransformerBlockEntity;
import dev.ftb.mods.ftbic.block.entity.storage.MVBatteryBoxBlockEntity;
import dev.ftb.mods.ftbic.block.entity.storage.MVTransformerBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.tileentity.TileEntity;

public interface FTBICElectricBlocks {
    public static final List<ElectricBlockInstance> ALL = new ArrayList<ElectricBlockInstance>();
    public static final ElectricBlockInstance BASIC_GENERATOR = FTBICElectricBlocks.register("basic_generator", BasicGeneratorBlockEntity::new).energyCapacity(FTBICConfig.BASIC_GENERATOR_CAPACITY).maxEnergyOutput(FTBICConfig.BASIC_GENERATOR_OUTPUT).io(1, 0);
    public static final ElectricBlockInstance GEOTHERMAL_GENERATOR = FTBICElectricBlocks.register("geothermal_generator", GeothermalGeneratorBlockEntity::new).energyCapacity(FTBICConfig.GEOTHERMAL_GENERATOR_CAPACITY).maxEnergyOutput(FTBICConfig.GEOTHERMAL_GENERATOR_OUTPUT).io(1, 1);
    public static final ElectricBlockInstance WIND_MILL = FTBICElectricBlocks.register("wind_mill", WindMillBlockEntity::new).cantBeActive().energyCapacity(FTBICConfig.WIND_MILL_CAPACITY).maxEnergyOutput(FTBICConfig.WIND_MILL_MAX_OUTPUT);
    public static final ElectricBlockInstance LV_SOLAR_PANEL = FTBICElectricBlocks.register("lv_solar_panel", LVSolarPanelBlockEntity::new).name("LV Solar Panel").noRotation().cantBeActive().energyCapacity(FTBICConfig.LV_SOLAR_PANEL_OUTPUT * 60.0).maxEnergyOutput(FTBICConfig.LV_SOLAR_PANEL_OUTPUT);
    public static final ElectricBlockInstance MV_SOLAR_PANEL = FTBICElectricBlocks.register("mv_solar_panel", MVSolarPanelBlockEntity::new).name("MV Solar Panel").noRotation().cantBeActive().energyCapacity(FTBICConfig.MV_SOLAR_PANEL_OUTPUT * 60.0).maxEnergyOutput(FTBICConfig.MV_SOLAR_PANEL_OUTPUT);
    public static final ElectricBlockInstance HV_SOLAR_PANEL = FTBICElectricBlocks.register("hv_solar_panel", HVSolarPanelBlockEntity::new).advanced().name("HV Solar Panel").noRotation().cantBeActive().energyCapacity(FTBICConfig.HV_SOLAR_PANEL_OUTPUT * 60.0).maxEnergyOutput(FTBICConfig.HV_SOLAR_PANEL_OUTPUT);
    public static final ElectricBlockInstance EV_SOLAR_PANEL = FTBICElectricBlocks.register("ev_solar_panel", EVSolarPanelBlockEntity::new).advanced().name("EV Solar Panel").noRotation().cantBeActive().energyCapacity(FTBICConfig.EV_SOLAR_PANEL_OUTPUT * 60.0).maxEnergyOutput(FTBICConfig.EV_SOLAR_PANEL_OUTPUT);
    public static final ElectricBlockInstance NUCLEAR_REACTOR = FTBICElectricBlocks.register("nuclear_reactor", NuclearReactorBlockEntity::new).advanced().energyCapacity(FTBICConfig.NUCLEAR_REACTOR_CAPACITY).io(54, 0);
    public static final ElectricBlockInstance POWERED_FURNACE = FTBICElectricBlocks.register("powered_furnace", PoweredFurnaceBlockEntity::new).canBurn().energyCapacity(FTBICConfig.POWERED_FURNACE_CAPACITY).maxEnergyInput(FTBICConfig.LV_TRANSFER_RATE).energyUsage(FTBICConfig.POWERED_FURNACE_USE).io(1, 1);
    public static final ElectricBlockInstance MACERATOR = FTBICElectricBlocks.register("macerator", MaceratorBlockEntity::new).canBurn().energyCapacity(FTBICConfig.MACERATOR_CAPACITY).maxEnergyInput(FTBICConfig.LV_TRANSFER_RATE).energyUsage(FTBICConfig.MACERATOR_USE).io(1, 2);
    public static final ElectricBlockInstance CENTRIFUGE = FTBICElectricBlocks.register("centrifuge", CentrifugeBlockEntity::new).canBurn().energyCapacity(FTBICConfig.CENTRIFUGE_CAPACITY).maxEnergyInput(FTBICConfig.LV_TRANSFER_RATE).energyUsage(FTBICConfig.CENTRIFUGE_USE).io(1, 2);
    public static final ElectricBlockInstance COMPRESSOR = FTBICElectricBlocks.register("compressor", CompressorBlockEntity::new).canBurn().energyCapacity(FTBICConfig.COMPRESSOR_CAPACITY).maxEnergyInput(FTBICConfig.LV_TRANSFER_RATE).energyUsage(FTBICConfig.COMPRESSOR_USE).io(1, 1);
    public static final ElectricBlockInstance REPROCESSOR = FTBICElectricBlocks.register("reprocessor", ReprocessorBlockEntity::new).advanced().canBurn().energyCapacity(FTBICConfig.REPROCESSOR_CAPACITY).maxEnergyInput(FTBICConfig.MV_TRANSFER_RATE).energyUsage(FTBICConfig.REPROCESSOR_USE).io(1, 1);
    public static final ElectricBlockInstance CANNING_MACHINE = FTBICElectricBlocks.register("canning_machine", CanningMachineBlockEntity::new).canBurn().energyCapacity(FTBICConfig.CANNING_MACHINE_CAPACITY).maxEnergyInput(FTBICConfig.LV_TRANSFER_RATE).energyUsage(FTBICConfig.CANNING_MACHINE_USE).io(2, 1);
    public static final ElectricBlockInstance ROLLER = FTBICElectricBlocks.register("roller", RollerBlockEntity::new).canBurn().energyCapacity(FTBICConfig.ROLLER_CAPACITY).maxEnergyInput(FTBICConfig.LV_TRANSFER_RATE).energyUsage(FTBICConfig.ROLLER_USE).io(1, 1);
    public static final ElectricBlockInstance EXTRUDER = FTBICElectricBlocks.register("extruder", ExtruderBlockEntity::new).canBurn().energyCapacity(FTBICConfig.EXTRUDER_CAPACITY).maxEnergyInput(FTBICConfig.LV_TRANSFER_RATE).energyUsage(FTBICConfig.EXTRUDER_USE).io(1, 1);
    public static final ElectricBlockInstance ANTIMATTER_CONSTRUCTOR = FTBICElectricBlocks.register("antimatter_constructor", AntimatterConstructorBlockEntity::new).advanced().energyCapacity(FTBICConfig.ANTIMATTER_CONSTRUCTOR_CAPACITY).maxEnergyInput(FTBICConfig.IV_TRANSFER_RATE).energyUsage(1.0).io(1, 1);
    public static final ElectricBlockInstance ADVANCED_POWERED_FURNACE = FTBICElectricBlocks.register("advanced_powered_furnace", AdvancedPoweredFurnaceBlockEntity::new).wip().advanced().canBurn().energyCapacity(FTBICConfig.ADVANCED_POWERED_FURNACE_CAPACITY).maxEnergyInput(FTBICConfig.MV_TRANSFER_RATE).energyUsage(FTBICConfig.ADVANCED_POWERED_FURNACE_USE).io(1, 1);
    public static final ElectricBlockInstance ADVANCED_MACERATOR = FTBICElectricBlocks.register("advanced_macerator", AdvancedMaceratorBlockEntity::new).wip().advanced().canBurn().energyCapacity(FTBICConfig.ADVANCED_MACERATOR_CAPACITY).maxEnergyInput(FTBICConfig.MV_TRANSFER_RATE).energyUsage(FTBICConfig.ADVANCED_MACERATOR_USE).io(1, 2);
    public static final ElectricBlockInstance ADVANCED_CENTRIFUGE = FTBICElectricBlocks.register("advanced_centrifuge", AdvancedCentrifugeBlockEntity::new).wip().advanced().canBurn().energyCapacity(FTBICConfig.ADVANCED_CENTRIFUGE_CAPACITY).maxEnergyInput(FTBICConfig.MV_TRANSFER_RATE).energyUsage(FTBICConfig.ADVANCED_CENTRIFUGE_USE).io(1, 2);
    public static final ElectricBlockInstance ADVANCED_COMPRESSOR = FTBICElectricBlocks.register("advanced_compressor", AdvancedCompressorBlockEntity::new).wip().advanced().canBurn().energyCapacity(FTBICConfig.ADVANCED_COMPRESSOR_CAPACITY).maxEnergyInput(FTBICConfig.MV_TRANSFER_RATE).energyUsage(FTBICConfig.ADVANCED_COMPRESSOR_USE).io(1, 1);
    public static final ElectricBlockInstance TELEPORTER = FTBICElectricBlocks.register("teleporter", TeleporterBlockEntity::new).wip().advanced().energyCapacity(FTBICConfig.TELEPORTER_CAPACITY).maxEnergyInput(FTBICConfig.IV_TRANSFER_RATE).energyUsage(FTBICConfig.TELEPORTER_MAX_USE).energyUsageIsntPerTick();
    public static final ElectricBlockInstance CHARGE_PAD = FTBICElectricBlocks.register("charge_pad", ChargePadBlockEntity::new).advanced().noRotation().energyCapacity(FTBICConfig.CHARGE_PAD_CAPACITY).maxEnergyInput(FTBICConfig.IV_TRANSFER_RATE);
    public static final ElectricBlockInstance POWERED_CRAFTING_TABLE = FTBICElectricBlocks.register("powered_crafting_table", PoweredCraftingTableBlockEntity::new).wip().noRotation().cantBeActive().canBurn().energyCapacity(FTBICConfig.POWERED_CRAFTING_TABLE_CAPACITY).maxEnergyInput(FTBICConfig.LV_TRANSFER_RATE).energyUsage(FTBICConfig.POWERED_CRAFTING_TABLE_USE).io(9, 1);
    public static final ElectricBlockInstance QUARRY = FTBICElectricBlocks.register("quarry", QuarryBlockEntity::new).advanced().energyCapacity(FTBICConfig.QUARRY_CAPACITY).maxEnergyInput(FTBICConfig.HV_TRANSFER_RATE).energyUsage(FTBICConfig.QUARRY_USE).io(0, 18);
    public static final ElectricBlockInstance PUMP = FTBICElectricBlocks.register("pump", PumpBlockEntity::new).advanced().energyCapacity(FTBICConfig.PUMP_CAPACITY).maxEnergyInput(FTBICConfig.HV_TRANSFER_RATE).energyUsage(FTBICConfig.PUMP_USE).io(1, 1);
    public static final ElectricBlockInstance LV_BATTERY_BOX = FTBICElectricBlocks.register("lv_battery_box", LVBatteryBoxBlockEntity::new).name("LV Battery Box").rotate3D().cantBeActive().canBurn().energyCapacity(FTBICConfig.LV_BATTERY_BOX_CAPACITY).maxEnergyInput(FTBICConfig.LV_TRANSFER_RATE).maxEnergyOutput(FTBICConfig.LV_TRANSFER_RATE);
    public static final ElectricBlockInstance MV_BATTERY_BOX = FTBICElectricBlocks.register("mv_battery_box", MVBatteryBoxBlockEntity::new).name("MV Battery Box").rotate3D().cantBeActive().canBurn().energyCapacity(FTBICConfig.MV_BATTERY_BOX_CAPACITY).maxEnergyInput(FTBICConfig.MV_TRANSFER_RATE).maxEnergyOutput(FTBICConfig.MV_TRANSFER_RATE);
    public static final ElectricBlockInstance HV_BATTERY_BOX = FTBICElectricBlocks.register("hv_battery_box", HVBatteryBoxBlockEntity::new).advanced().name("HV Battery Box").rotate3D().cantBeActive().canBurn().energyCapacity(FTBICConfig.HV_BATTERY_BOX_CAPACITY).maxEnergyInput(FTBICConfig.HV_TRANSFER_RATE).maxEnergyOutput(FTBICConfig.HV_TRANSFER_RATE);
    public static final ElectricBlockInstance EV_BATTERY_BOX = FTBICElectricBlocks.register("ev_battery_box", EVBatteryBoxBlockEntity::new).advanced().name("EV Battery Box").rotate3D().cantBeActive().canBurn().energyCapacity(FTBICConfig.EV_BATTERY_BOX_CAPACITY).maxEnergyInput(FTBICConfig.EV_TRANSFER_RATE).maxEnergyOutput(FTBICConfig.EV_TRANSFER_RATE);
    public static final ElectricBlockInstance LV_TRANSFORMER = FTBICElectricBlocks.register("lv_transformer", LVTransformerBlockEntity::new).name("LV Transformer").rotate3D().cantBeActive().canBurn().energyCapacity(FTBICConfig.MV_TRANSFER_RATE).maxEnergyInput(FTBICConfig.MV_TRANSFER_RATE).maxEnergyOutput(FTBICConfig.LV_TRANSFER_RATE);
    public static final ElectricBlockInstance MV_TRANSFORMER = FTBICElectricBlocks.register("mv_transformer", MVTransformerBlockEntity::new).name("MV Transformer").rotate3D().cantBeActive().canBurn().energyCapacity(FTBICConfig.HV_TRANSFER_RATE).maxEnergyInput(FTBICConfig.HV_TRANSFER_RATE).maxEnergyOutput(FTBICConfig.MV_TRANSFER_RATE);
    public static final ElectricBlockInstance HV_TRANSFORMER = FTBICElectricBlocks.register("hv_transformer", HVTransformerBlockEntity::new).advanced().name("HV Transformer").rotate3D().cantBeActive().canBurn().energyCapacity(FTBICConfig.EV_TRANSFER_RATE).maxEnergyInput(FTBICConfig.EV_TRANSFER_RATE).maxEnergyOutput(FTBICConfig.HV_TRANSFER_RATE);
    public static final ElectricBlockInstance EV_TRANSFORMER = FTBICElectricBlocks.register("ev_transformer", EVTransformerBlockEntity::new).advanced().name("EV Transformer").rotate3D().cantBeActive().canBurn().energyCapacity(FTBICConfig.IV_TRANSFER_RATE).maxEnergyInput(FTBICConfig.IV_TRANSFER_RATE).maxEnergyOutput(FTBICConfig.EV_TRANSFER_RATE);

    public static ElectricBlockInstance register(String id, Supplier<TileEntity> supplier) {
        ElectricBlockInstance instance = new ElectricBlockInstance(id, supplier);
        ALL.add(instance);
        return instance;
    }

    public static void init() {
    }
}

