/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.block.entity.generator;

import dev.ftb.mods.ftbic.block.FTBICElectricBlocks;
import dev.ftb.mods.ftbic.block.entity.generator.GeneratorBlockEntity;
import dev.ftb.mods.ftbic.block.entity.generator.GeothermalGeneratorTank;
import dev.ftb.mods.ftbic.screen.GeothermalGeneratorMenu;
import dev.ftb.mods.ftbic.screen.sync.SyncedData;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeothermalGeneratorBlockEntity
extends GeneratorBlockEntity {
    public int fluidAmount = 0;
    private LazyOptional<GeothermalGeneratorTank> tankOptional;

    public GeothermalGeneratorBlockEntity() {
        super(FTBICElectricBlocks.GEOTHERMAL_GENERATOR);
    }

    @Override
    public void writeData(CompoundNBT tag) {
        super.writeData(tag);
        tag.func_74768_a("FluidAmount", this.fluidAmount);
    }

    @Override
    public void readData(CompoundNBT tag) {
        super.readData(tag);
        this.fluidAmount = tag.func_74762_e("FluidAmount");
    }

    public LazyOptional<?> getTankOptional() {
        if (this.tankOptional == null) {
            this.tankOptional = LazyOptional.of(() -> new GeothermalGeneratorTank(this));
        }
        return this.tankOptional;
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.tankOptional != null) {
            this.tankOptional.invalidate();
            this.tankOptional = null;
        }
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this.getTankOptional().cast() : super.getCapability(cap, side);
    }

    @Override
    public void handleGeneration() {
        if (this.energy < this.energyCapacity && this.fluidAmount > 0) {
            this.energy += Math.min(this.energyCapacity - this.energy, this.maxEnergyOutput);
            --this.fluidAmount;
            this.active = true;
        }
    }

    @Override
    public ActionResultType rightClick(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)((IFluidHandler)this.getTankOptional().orElse(null)))) {
            return ActionResultType.SUCCESS;
        }
        if (!this.field_145850_b.func_201670_d()) {
            this.openMenu((ServerPlayerEntity)player, (id, inventory) -> new GeothermalGeneratorMenu(id, inventory, this));
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public void addSyncData(SyncedData data) {
        super.addSyncData(data);
        data.addShort(SyncedData.BAR, () -> this.fluidAmount);
    }
}

