/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.block.entity.generator;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.FTBICBlocks;
import dev.ftb.mods.ftbic.block.FTBICElectricBlocks;
import dev.ftb.mods.ftbic.block.NuclearReactorChamberBlock;
import dev.ftb.mods.ftbic.block.entity.generator.GeneratorBlockEntity;
import dev.ftb.mods.ftbic.item.reactor.NuclearReactor;
import dev.ftb.mods.ftbic.item.reactor.ReactorItem;
import dev.ftb.mods.ftbic.screen.NuclearReactorMenu;
import dev.ftb.mods.ftbic.screen.sync.SyncedData;
import dev.ftb.mods.ftbic.screen.sync.SyncedDataKey;
import dev.ftb.mods.ftbic.sound.FTBICSounds;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import dev.ftb.mods.ftbic.util.NuclearExplosion;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class NuclearReactorBlockEntity
extends GeneratorBlockEntity {
    public static final int[] OFFSET_X = new int[]{0, 0, -1, 1};
    public static final int[] OFFSET_Y = new int[]{-1, 1, 0, 0};
    public static final SyncedDataKey<Double> ENERGY_OUTPUT = new SyncedDataKey<Double>("energy_output", 0.0);
    public static final SyncedDataKey<Integer> HEAT = new SyncedDataKey<Integer>("heat", 0);
    public static final SyncedDataKey<Integer> MAX_HEAT = new SyncedDataKey<Integer>("max_heat", 0);
    public int timeUntilNextCycle;
    public final NuclearReactor reactor = new NuclearReactor(this.inputItems);
    public int debugSpeed = 0;
    public Byte2ObjectOpenHashMap<Item> plan;

    public NuclearReactorBlockEntity() {
        super(FTBICElectricBlocks.NUCLEAR_REACTOR);
    }

    @Override
    public void initProperties() {
        super.initProperties();
        this.maxEnergyOutputTransfer = FTBICConfig.IV_TRANSFER_RATE;
    }

    @Override
    public void writeData(CompoundNBT tag) {
        super.writeData(tag);
        tag.func_74768_a("TimeUntilNextCycle", this.timeUntilNextCycle);
        tag.func_74757_a("Paused", this.reactor.paused);
        tag.func_74780_a("EnergyOutput", this.reactor.energyOutput);
        tag.func_74768_a("Heat", this.reactor.heat);
        if (this.debugSpeed > 0) {
            tag.func_74768_a("DebugSpeed", this.debugSpeed);
        }
        if (this.plan != null && !this.plan.isEmpty()) {
            HashMap<Item, ByteArrayList> pmap = new HashMap<Item, ByteArrayList>();
            for (Byte2ObjectMap.Entry entry : this.plan.byte2ObjectEntrySet()) {
                pmap.computeIfAbsent((Item)entry.getValue(), k -> new ByteArrayList()).add(entry.getByteKey());
            }
            CompoundNBT ptag = new CompoundNBT();
            for (Map.Entry entry : pmap.entrySet()) {
                ptag.func_74773_a(((Item)entry.getKey()).getRegistryName().toString(), ((ByteArrayList)entry.getValue()).toByteArray());
            }
            tag.func_218657_a("Plan", (INBT)ptag);
        }
    }

    @Override
    public void readData(CompoundNBT tag) {
        super.readData(tag);
        this.timeUntilNextCycle = tag.func_74762_e("TimeUntilNextCycle");
        this.reactor.paused = tag.func_74767_n("Paused");
        this.reactor.energyOutput = tag.func_74769_h("EnergyOutput");
        this.reactor.heat = tag.func_74762_e("Heat");
        this.debugSpeed = tag.func_74762_e("DebugSpeed");
        CompoundNBT ptag = tag.func_74775_l("Plan");
        if (!ptag.isEmpty()) {
            this.plan = new Byte2ObjectOpenHashMap();
            for (String s : ptag.func_150296_c()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s));
                if (!(item instanceof ReactorItem)) continue;
                for (byte b : ptag.func_74770_j(s)) {
                    this.plan.put(b, (Object)item);
                }
            }
            if (this.plan.isEmpty()) {
                this.plan = null;
            }
        } else {
            this.plan = null;
        }
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return stack.func_77973_b() instanceof ReactorItem && (this.plan == null || this.plan.get((byte)slot) == stack.func_77973_b());
    }

    @Override
    public boolean savePlacer() {
        return true;
    }

    @Override
    public void addSyncData(SyncedData data) {
        super.addSyncData(data);
        data.addBoolean(SyncedData.PAUSED, () -> this.reactor.paused);
        data.addDouble(ENERGY_OUTPUT, () -> this.reactor.energyOutput);
        data.addInt(HEAT, () -> this.reactor.heat);
        data.addInt(MAX_HEAT, () -> this.reactor.maxHeat);
    }

    @Override
    public ActionResultType rightClick(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!this.field_145850_b.func_201670_d()) {
            this.openMenu((ServerPlayerEntity)player, (id, inventory) -> new NuclearReactorMenu(id, inventory, this));
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public void handleGeneration() {
        --this.timeUntilNextCycle;
        if (this.timeUntilNextCycle <= 0) {
            this.timeUntilNextCycle = 20;
            if (this.debugSpeed <= 0) {
                this.handleReactor();
            }
        }
        if (this.debugSpeed > 0) {
            for (int i = 0; i < this.debugSpeed; ++i) {
                this.handleReactor();
            }
        }
        if (this.reactor.energyOutput > 0.0) {
            this.active = true;
            this.energy += Math.min(this.reactor.energyOutput, this.energyCapacity - this.energy);
        }
        if (this.field_145850_b == null || this.field_145850_b.func_201670_d() || this.reactor.heat <= 0 || this.reactor.maxHeat <= 0) {
            return;
        }
        float h = (float)this.reactor.heat / (float)this.reactor.maxHeat;
        if (h >= 1.0f) {
            if (this.debugSpeed > 0) {
                this.field_145850_b.func_73046_m().func_184103_al().func_232641_a_((ITextComponent)new StringTextComponent(String.format("Debug Nuclear Reactor at %d, %d, %d exploded:", this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p())), ChatType.SYSTEM, Util.field_240973_b_);
                this.field_145850_b.func_73046_m().func_184103_al().func_232641_a_((ITextComponent)new StringTextComponent(String.format("- Radius: %,d", MathHelper.func_76143_f((double)this.reactor.explosionRadius))), ChatType.SYSTEM, Util.field_240973_b_);
                this.field_145850_b.func_73046_m().func_184103_al().func_232641_a_((ITextComponent)new StringTextComponent(String.format("- Heat: %s / %s \ud83d\udd25", FTBICUtils.formatEnergyValue(this.reactor.heat), FTBICUtils.formatEnergyValue(this.reactor.maxHeat))), ChatType.SYSTEM, Util.field_240973_b_);
                this.field_145850_b.func_73046_m().func_184103_al().func_232641_a_((ITextComponent)new StringTextComponent(String.format("- Energy: %s/t", FTBICUtils.formatEnergyValue(this.reactor.energyOutput))), ChatType.SYSTEM, Util.field_240973_b_);
                this.reactor.paused = true;
                this.reactor.heat = this.reactor.maxHeat - 1;
                this.func_70296_d();
            } else {
                Arrays.fill(this.inputItems, ItemStack.field_190927_a);
                this.func_70296_d();
                this.field_145850_b.func_180501_a(this.field_174879_c, FTBICBlocks.ACTIVE_NUKE.get().func_176223_P(), 3);
                for (Direction direction : FTBICUtils.DIRECTIONS) {
                    if (!(this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(direction)).func_177230_c() instanceof NuclearReactorChamberBlock)) continue;
                    this.field_145850_b.func_180501_a(this.field_174879_c.func_177972_a(direction), FTBICBlocks.ACTIVE_NUKE.get().func_176223_P(), 3);
                }
                NuclearExplosion.builder((ServerWorld)this.field_145850_b, this.field_174879_c, this.reactor.explosionRadius, this.placerId, this.placerName).preExplosion(() -> {
                    this.field_145850_b.func_73046_m().func_184103_al().func_232641_a_((ITextComponent)new TranslationTextComponent("block.ftbic.nuclear_reactor.broadcast", new Object[]{this.placerName}), ChatType.SYSTEM, Util.field_240973_b_);
                    ServerPlayerEntity player = this.field_145850_b.func_73046_m().func_184103_al().func_177451_a(this.placerId);
                    if (player != null) {
                        player.func_145747_a((ITextComponent)new StringTextComponent(String.format("%s : [%d, %d, %d]", this.field_145850_b.func_234923_W_().func_240901_a_().toString(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p())).func_240699_a_(TextFormatting.GRAY), Util.field_240973_b_);
                    }
                    this.field_145850_b.func_217377_a(this.field_174879_c, false);
                }).create();
            }
        } else if (h >= 0.75f && this.field_145850_b.func_82737_E() % 25L == 0L && this.reactor.energyOutput > 0.0) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, FTBICSounds.RADIATION.get(), SoundCategory.BLOCKS, 0.5f, 1.0f);
        }
    }

    public void handleReactor() {
        if (this.field_145850_b == null || this.field_145850_b.func_201670_d()) {
            return;
        }
        double peo = this.reactor.energyOutput;
        int ph = this.reactor.heat;
        this.reactor.tick();
        if (peo != this.reactor.energyOutput || ph != this.reactor.heat) {
            this.func_70296_d();
        }
    }

    @Override
    public void onBroken(World level, BlockPos pos) {
        if (this.debugSpeed <= 0) {
            super.onBroken(level, pos);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void spawnActiveParticles(World level, double x, double y, double z, BlockState state, Random r) {
    }
}

