/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.block.entity.machine;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.FTBICElectricBlocks;
import dev.ftb.mods.ftbic.block.entity.ElectricBlockEntity;
import dev.ftb.mods.ftbic.item.FTBICItems;
import dev.ftb.mods.ftbic.recipe.RecipeCache;
import dev.ftb.mods.ftbic.screen.AntimatterConstructorMenu;
import dev.ftb.mods.ftbic.screen.sync.SyncedData;
import dev.ftb.mods.ftbic.screen.sync.SyncedDataKey;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockRayTraceResult;
import org.jetbrains.annotations.NotNull;

public class AntimatterConstructorBlockEntity
extends ElectricBlockEntity {
    public static final SyncedDataKey<Boolean> HAS_BOOST = new SyncedDataKey<Boolean>("has_boost", false);
    public double boost = 0.0;
    private boolean hasBoost = false;

    public AntimatterConstructorBlockEntity() {
        super(FTBICElectricBlocks.ANTIMATTER_CONSTRUCTOR);
    }

    @Override
    public void writeData(CompoundNBT tag) {
        super.writeData(tag);
        tag.func_74780_a("Boost", this.boost);
    }

    @Override
    public void readData(CompoundNBT tag) {
        super.readData(tag);
        this.boost = tag.func_74769_h("Boost");
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.energy >= this.energyCapacity) {
            if (this.outputItems[0].func_190926_b()) {
                this.outputItems[0] = new ItemStack((IItemProvider)FTBICItems.ANTIMATTER.item.get());
                this.energy -= this.energyCapacity;
                this.func_70296_d();
            } else if (this.outputItems[0].func_190916_E() < this.outputItems[0].func_77976_d()) {
                this.outputItems[0].func_190917_f(1);
                this.energy -= this.energyCapacity;
                this.func_70296_d();
            }
        } else if (this.boost <= 0.0) {
            this.boost = this.getBoost(this.inputItems[0]);
            if (this.boost > 0.0) {
                this.inputItems[0].func_190918_g(1);
                if (this.inputItems[0].func_190926_b()) {
                    this.inputItems[0] = ItemStack.field_190927_a;
                }
                this.func_70296_d();
            }
        }
        this.hasBoost = this.boost > 0.0;
    }

    @Override
    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return slot == 0 && this.getBoost(stack) > 0.0;
    }

    private double getBoost(ItemStack item) {
        RecipeCache recipeCache = this.getRecipeCache();
        return recipeCache == null ? 0.0 : recipeCache.getAntimatterBoost(this.field_145850_b, item);
    }

    @Override
    public double insertEnergy(double maxInsert, boolean simulate) {
        if (this.energy >= this.energyCapacity) {
            return 0.0;
        }
        if (!simulate) {
            double boosted = Math.min(this.boost, maxInsert);
            this.boost -= boosted;
            this.energy += boosted * FTBICConfig.ANTIMATTER_CONSTRUCTOR_BOOST + (maxInsert -= boosted);
        }
        return maxInsert;
    }

    @Override
    public ActionResultType rightClick(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!this.field_145850_b.func_201670_d()) {
            this.openMenu((ServerPlayerEntity)player, (id, inventory) -> new AntimatterConstructorMenu(id, inventory, this));
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public void addSyncData(SyncedData data) {
        super.addSyncData(data);
        data.addBoolean(HAS_BOOST, () -> this.hasBoost);
    }
}

