/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.block.entity.machine;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.ElectricBlockInstance;
import dev.ftb.mods.ftbic.block.entity.ElectricBlockEntity;
import dev.ftb.mods.ftbic.block.entity.machine.BatteryInventory;
import dev.ftb.mods.ftbic.block.entity.machine.UpgradeInventory;
import dev.ftb.mods.ftbic.item.FTBICItems;
import dev.ftb.mods.ftbic.util.EnergyItemHandler;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class BasicMachineBlockEntity
extends ElectricBlockEntity {
    public final UpgradeInventory upgradeInventory = new UpgradeInventory(this, 4, FTBICConfig.UPGRADE_LIMIT_PER_SLOT);
    public final BatteryInventory batteryInventory = new BatteryInventory(this, false);
    public double energyUse;
    public double progressSpeed;

    public BasicMachineBlockEntity(ElectricBlockInstance type) {
        super(type);
    }

    @Override
    public void writeData(CompoundNBT tag) {
        super.writeData(tag);
        tag.func_218657_a("Upgrades", (INBT)this.upgradeInventory.serializeNBT().func_150295_c("Items", 10));
        if (!this.batteryInventory.getStackInSlot(0).func_190926_b()) {
            tag.func_218657_a("Battery", (INBT)this.batteryInventory.getStackInSlot(0).serializeNBT());
        }
    }

    @Override
    public void readData(CompoundNBT tag) {
        super.readData(tag);
        CompoundNBT tag1 = new CompoundNBT();
        tag1.func_218657_a("Items", (INBT)tag.func_150295_c("Upgrades", 10));
        this.upgradeInventory.deserializeNBT(tag1);
        if (tag.func_74764_b("Battery")) {
            this.batteryInventory.loadItem(ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("Battery")));
        } else {
            this.batteryInventory.loadItem(ItemStack.field_190927_a);
        }
    }

    @Override
    public void func_73660_a() {
        double transfer;
        EnergyItemHandler item;
        double e;
        ItemStack battery;
        if (!this.isBurnt() && !this.field_145850_b.func_201670_d() && this.energy < this.energyCapacity && !(battery = this.batteryInventory.getStackInSlot(0)).func_190926_b() && battery.func_77973_b() instanceof EnergyItemHandler && (e = item.extractEnergy(battery, Math.min(this.energyCapacity - this.energy, transfer = (item = (EnergyItemHandler)battery.func_77973_b()).isCreativeEnergyItem() ? Double.POSITIVE_INFINITY : this.maxInputEnergy * FTBICConfig.ITEM_TRANSFER_EFFICIENCY), false)) > 0.0) {
            this.energy += e;
            if (battery.func_190926_b()) {
                this.batteryInventory.setStackInSlot(0, ItemStack.field_190927_a);
            }
            this.func_70296_d();
        }
        this.handleProcessing();
        this.handleChanges();
    }

    @Override
    public double getTotalPossibleEnergyCapacity() {
        return super.getTotalPossibleEnergyCapacity() + (double)(this.upgradeInventory.getSlots() * Math.min(FTBICConfig.UPGRADE_LIMIT_PER_SLOT, FTBICItems.ENERGY_STORAGE_UPGRADE.get().func_77639_j())) * FTBICConfig.STORAGE_UPGRADE;
    }

    public void handleProcessing() {
    }

    @Override
    public void onBroken(World level, BlockPos pos) {
        super.onBroken(level, pos);
        for (int i = 0; i < this.upgradeInventory.getSlots(); ++i) {
            Block.func_180635_a((World)level, (BlockPos)pos, (ItemStack)this.upgradeInventory.getStackInSlot(i));
        }
        Block.func_180635_a((World)level, (BlockPos)pos, (ItemStack)this.batteryInventory.getStackInSlot(0));
    }

    @Override
    public void initProperties() {
        super.initProperties();
        this.energyUse = this.electricBlockInstance.energyUsage;
        this.progressSpeed = 1.0;
        this.autoEject = false;
    }

    @Override
    public void upgradesChanged() {
        super.upgradesChanged();
        int overclockers = this.upgradeInventory.countUpgrades(FTBICItems.OVERCLOCKER_UPGRADE.get());
        for (int i = 0; i < overclockers; ++i) {
            this.energyUse *= FTBICConfig.OVERCLOCKER_ENERGY_USE;
            this.progressSpeed *= FTBICConfig.OVERCLOCKER_SPEED;
        }
        int transformers = this.upgradeInventory.countUpgrades(FTBICItems.TRANSFORMER_UPGRADE.get());
        while (transformers > 0) {
            --transformers;
            this.maxInputEnergy *= 4.0;
        }
        if (this.maxInputEnergy > FTBICConfig.IV_TRANSFER_RATE) {
            this.maxInputEnergy = FTBICConfig.IV_TRANSFER_RATE;
        }
        this.energyCapacity += (double)this.upgradeInventory.countUpgrades(FTBICItems.ENERGY_STORAGE_UPGRADE.get()) * FTBICConfig.STORAGE_UPGRADE;
        this.autoEject = this.upgradeInventory.countUpgrades(FTBICItems.EJECTOR_UPGRADE.get()) > 0;
    }
}

