/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.block.entity.machine;

import dev.ftb.mods.ftbic.FTBIC;
import dev.ftb.mods.ftbic.block.ElectricBlockInstance;
import dev.ftb.mods.ftbic.block.FTBICBlocks;
import dev.ftb.mods.ftbic.block.entity.machine.BasicMachineBlockEntity;
import dev.ftb.mods.ftbic.net.MoveLaserMessage;
import dev.ftb.mods.ftbic.screen.sync.SyncedData;
import dev.ftb.mods.ftbic.util.FTBChunksIntegration;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class DiggingBaseBlockEntity
extends BasicMachineBlockEntity {
    private static final int INVALID_Y = -10000;
    public boolean paused = false;
    public long tick = 0L;
    public float laserX = 0.5f;
    public int laserY = -10000;
    public float laserZ = 0.5f;
    public int offsetX = 1;
    public int offsetZ = -2;
    public int sizeX = 5;
    public int sizeZ = 5;
    public int skippedBlocks = 0;
    public float prevLaserX = 0.5f;
    public float prevLaserZ = 0.5f;
    public float moveLaserX = 0.5f;
    public int moveLaserY = 0;
    public float moveLaserZ = 0.5f;
    public long diggingMineTicks;
    public long diggingMoveTicks;

    public DiggingBaseBlockEntity(ElectricBlockInstance type) {
        super(type);
    }

    @Override
    public void writeData(CompoundNBT tag) {
        super.writeData(tag);
        tag.func_74776_a("LaserX", this.laserX);
        tag.func_74768_a("LaserY", this.laserY);
        tag.func_74776_a("LaserZ", this.laserZ);
        if (this.paused) {
            tag.func_74757_a("Paused", true);
        }
        tag.func_74772_a("Tick", this.tick);
        tag.func_74774_a("OffsetX", (byte)this.offsetX);
        tag.func_74774_a("OffsetZ", (byte)this.offsetZ);
        tag.func_74774_a("SizeX", (byte)this.sizeX);
        tag.func_74774_a("SizeZ", (byte)this.sizeZ);
        if (this.skippedBlocks > 0) {
            tag.func_74777_a("SkippedBlocks", (short)this.skippedBlocks);
        }
    }

    @Override
    public void readData(CompoundNBT tag) {
        super.readData(tag);
        this.laserX = tag.func_74760_g("LaserX");
        this.laserY = tag.func_74762_e("LaserY");
        this.laserZ = tag.func_74760_g("LaserZ");
        this.paused = tag.func_74767_n("Paused");
        this.tick = tag.func_74763_f("Tick");
        this.offsetX = tag.func_74771_c("OffsetX");
        this.offsetZ = tag.func_74771_c("OffsetZ");
        this.sizeX = MathHelper.func_76125_a((int)tag.func_74771_c("SizeX"), (int)1, (int)64);
        this.sizeZ = MathHelper.func_76125_a((int)tag.func_74771_c("SizeZ"), (int)1, (int)64);
        this.skippedBlocks = tag.func_74765_d("SkippedBlocks");
    }

    @Override
    public void writeNetData(CompoundNBT tag) {
        super.writeNetData(tag);
        tag.func_74776_a("LaserX", this.laserX);
        tag.func_74768_a("LaserY", this.laserY);
        tag.func_74776_a("LaserZ", this.laserZ);
        if (this.paused) {
            tag.func_74757_a("Paused", true);
        }
        tag.func_74772_a("Tick", this.tick);
        tag.func_74774_a("OffsetX", (byte)this.offsetX);
        tag.func_74774_a("OffsetZ", (byte)this.offsetZ);
        tag.func_74774_a("SizeX", (byte)this.sizeX);
        tag.func_74774_a("SizeZ", (byte)this.sizeZ);
        tag.func_74780_a("Speed", this.progressSpeed);
    }

    @Override
    public void readNetData(CompoundNBT tag) {
        super.readNetData(tag);
        this.moveLaserX = this.laserX = tag.func_74760_g("LaserX");
        this.prevLaserX = this.laserX;
        this.moveLaserY = this.laserY = tag.func_74762_e("LaserY");
        this.moveLaserZ = this.laserZ = tag.func_74760_g("LaserZ");
        this.prevLaserZ = this.laserZ;
        this.paused = tag.func_74767_n("Paused");
        this.tick = tag.func_74763_f("Tick");
        this.offsetX = tag.func_74771_c("OffsetX");
        this.offsetZ = tag.func_74771_c("OffsetZ");
        this.sizeX = tag.func_74771_c("SizeX");
        this.sizeZ = tag.func_74771_c("SizeZ");
    }

    @Override
    public void handleProcessing() {
        boolean bl = this.active = !this.paused;
        if (this.field_145850_b != null && this.field_145850_b.func_201670_d()) {
            this.prevLaserX = this.laserX;
            this.prevLaserZ = this.laserZ;
            this.laserX = this.moveLaserX;
            this.laserY = this.moveLaserY;
            this.laserZ = this.moveLaserZ;
            if (!this.paused) {
                double x = (float)this.field_174879_c.func_177958_n() + this.laserX;
                double minY = (double)this.laserY + 0.5;
                double maxY = (double)this.field_174879_c.func_177956_o() + 0.5;
                double z = (float)this.field_174879_c.func_177952_p() + this.laserZ;
                FTBIC.PROXY.playLaserSound(this.field_145850_b.func_82737_E(), x, minY, maxY, z);
            }
        }
        if (!this.paused && this.field_145850_b != null && !this.field_145850_b.func_201670_d()) {
            if (this.energy >= this.energyUse) {
                this.energy -= this.energyUse;
            } else {
                return;
            }
            int miningTicks = Math.max((int)((double)this.diggingMineTicks / this.progressSpeed), 1);
            int moveTicks = Math.max((int)((double)this.diggingMoveTicks / this.progressSpeed), 1);
            int totalTicks = miningTicks + moveTicks;
            int ltick = (int)(this.tick % (long)totalTicks);
            if (ltick <= moveTicks) {
                int row0;
                long s = (long)this.sizeX * (long)this.sizeZ * 2L;
                int lpos0 = (int)((this.tick / (long)totalTicks - 1L) % s);
                int lpos1 = (int)(this.tick / (long)totalTicks % s);
                if (lpos0 < 0) {
                    lpos0 = (int)((long)lpos0 + s);
                }
                if ((long)lpos0 >= s / 2L) {
                    lpos0 = (int)(s - (long)lpos0 - 1L);
                }
                if ((long)lpos1 >= s / 2L) {
                    lpos1 = (int)(s - (long)lpos1 - 1L);
                }
                int col0 = (row0 = lpos0 / this.sizeX) % 2 == 0 ? lpos0 % this.sizeX : this.sizeX - 1 - lpos0 % this.sizeX;
                int row1 = lpos1 / this.sizeX;
                int col1 = row1 % 2 == 0 ? lpos1 % this.sizeX : this.sizeX - 1 - lpos1 % this.sizeX;
                float lerp = (float)ltick / (float)moveTicks;
                this.laserX = (float)this.offsetX + MathHelper.func_219799_g((float)lerp, (float)col0, (float)col1) + 0.5f;
                this.laserZ = (float)this.offsetZ + MathHelper.func_219799_g((float)lerp, (float)row0, (float)row1) + 0.5f;
                this.laserY = this.getY(this.field_174879_c.func_177958_n() + MathHelper.func_76141_d((float)this.laserX), this.field_174879_c.func_177952_p() + MathHelper.func_76141_d((float)this.laserZ));
                this.sendLaserMove();
            }
            if (ltick == totalTicks - 1) {
                this.laserY = this.getY(this.field_174879_c.func_177958_n() + MathHelper.func_76141_d((float)this.laserX), this.field_174879_c.func_177952_p() + MathHelper.func_76141_d((float)this.laserZ));
                if (this.laserY == -10000) {
                    ++this.skippedBlocks;
                    if (this.skippedBlocks >= this.sizeX * this.sizeZ * 2) {
                        this.paused = true;
                        this.skippedBlocks = 0;
                        this.syncBlock();
                    }
                } else {
                    BlockPos miningPos = new BlockPos((double)((float)this.field_174879_c.func_177958_n() + this.laserX), (double)this.laserY, (double)((float)this.field_174879_c.func_177952_p() + this.laserZ));
                    BlockState state = this.field_145850_b.func_180495_p(miningPos);
                    this.skippedBlocks = 0;
                    if (!this.field_145850_b.func_201670_d()) {
                        this.field_145850_b.func_217381_Z().func_76320_a("ftbic_" + this.electricBlockInstance.id);
                        double lx = (float)this.field_174879_c.func_177958_n() + this.laserX;
                        double ly = (double)this.laserY + 0.5;
                        double lz = (float)this.field_174879_c.func_177952_p() + this.laserZ;
                        this.digBlock(state, miningPos, lx, ly, lz);
                        this.field_145850_b.func_217381_Z().func_76319_b();
                        if (this.paused) {
                            this.syncBlock();
                        }
                    }
                }
            }
            ++this.tick;
        }
    }

    public boolean isValidBlock(BlockState state, BlockPos pos) {
        return false;
    }

    public void digBlock(BlockState state, BlockPos miningPos, double lx, double ly, double lz) {
    }

    private int getY(int x, int z) {
        BlockPos.Mutable pos = new BlockPos.Mutable(x, 0, z);
        if (this.field_145850_b instanceof ServerWorld && FTBChunksIntegration.instance.isProtected((ServerWorld)this.field_145850_b, (BlockPos)pos, this.placerId)) {
            return -10000;
        }
        for (int y = this.field_174879_c.func_177956_o(); y >= 0; --y) {
            BlockState state;
            pos.func_185336_p(y);
            if (!this.field_145850_b.func_195588_v((BlockPos)pos) || (state = this.field_145850_b.func_180495_p((BlockPos)pos)).func_177230_c() == Blocks.field_150357_h || state.func_177230_c() == FTBICBlocks.EXFLUID.get() || state.func_196958_f() || !this.isValidBlock(state, (BlockPos)pos)) continue;
            return y;
        }
        return -10000;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 256.0;
    }

    @Override
    public boolean savePlacer() {
        return true;
    }

    @Override
    public boolean tickClientSide() {
        return true;
    }

    public void resize() {
        BlockState state;
        int i;
        Block landmark = FTBICBlocks.LANDMARK.get();
        Direction front = this.getFacing(Direction.NORTH);
        Direction back = front.func_176734_d();
        Direction left = front.func_176746_e();
        Direction right = front.func_176735_f();
        int offBack = 6;
        int offLeft = 3;
        int offRight = 3;
        for (i = 2; i <= 64; ++i) {
            state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(back, i));
            if (state.func_177230_c() != landmark) continue;
            offBack = i;
            break;
        }
        for (i = 1; i <= 64; ++i) {
            state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(left, i));
            if (state.func_177230_c() != landmark) continue;
            offLeft = i;
            break;
        }
        for (i = 1; i <= 64; ++i) {
            state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(right, i));
            if (state.func_177230_c() != landmark) continue;
            offRight = i;
            break;
        }
        --offBack;
        --offLeft;
        --offRight;
        if (back.func_176740_k() == Direction.Axis.X) {
            this.sizeX = offBack;
            this.sizeZ = offLeft + offRight + 1;
            this.offsetX = back.func_82601_c() == 1 ? 1 : -this.sizeX;
            this.offsetZ = -(back.func_82601_c() == 1 ? offLeft : offRight);
        } else if (back.func_176740_k() == Direction.Axis.Z) {
            this.sizeX = offLeft + offRight + 1;
            this.sizeZ = offBack;
            this.offsetX = -(back.func_82599_e() == 1 ? offRight : offLeft);
            this.offsetZ = back.func_82599_e() == 1 ? 1 : -this.sizeZ;
        }
        this.syncBlock();
    }

    @Override
    public void onPlacedBy(@Nullable LivingEntity entity, ItemStack stack) {
        super.onPlacedBy(entity, stack);
        Direction dir = this.getFacing(Direction.NORTH).func_176734_d();
        this.laserX = (float)dir.func_82601_c() + 0.5f;
        this.laserZ = (float)dir.func_82599_e() + 0.5f;
        TileEntity e = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (e instanceof DiggingBaseBlockEntity) {
            DiggingBaseBlockEntity q = (DiggingBaseBlockEntity)e;
            this.offsetX = q.offsetX;
            this.offsetZ = q.offsetZ;
            this.sizeX = q.sizeX;
            this.sizeZ = q.sizeZ;
            this.syncBlock();
        } else {
            this.resize();
        }
    }

    @Override
    public void addSyncData(SyncedData data) {
        super.addSyncData(data);
        data.addBoolean(SyncedData.PAUSED, () -> this.paused);
    }

    public void moveLaser(float x, int y, float z) {
        this.moveLaserX = x;
        this.moveLaserY = y;
        this.moveLaserZ = z;
    }

    private void sendLaserMove() {
        Chunk chunk;
        Chunk chunk2 = chunk = this.field_145850_b == null ? null : this.field_145850_b.func_175726_f(this.field_174879_c);
        if (chunk != null) {
            new MoveLaserMessage(this.field_174879_c, this.laserX, this.laserY, this.laserZ).sendToChunkListeners(chunk);
        }
    }

    public float[] getLaserColor() {
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    @Override
    public ITextComponent createDisplayName() {
        if (this.paused) {
            return new StringTextComponent("").func_230529_a_(super.createDisplayName()).func_240702_b_(" [Paused]");
        }
        return super.createDisplayName();
    }
}

