/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.datagen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import dev.ftb.mods.ftbic.block.BaseCableBlock;
import dev.ftb.mods.ftbic.block.CableBlock;
import dev.ftb.mods.ftbic.block.ElectricBlock;
import dev.ftb.mods.ftbic.block.ElectricBlockInstance;
import dev.ftb.mods.ftbic.block.FTBICBlocks;
import dev.ftb.mods.ftbic.block.FTBICElectricBlocks;
import dev.ftb.mods.ftbic.block.SprayPaintable;
import dev.ftb.mods.ftbic.datagen.CombinedTextureProvider;
import dev.ftb.mods.ftbic.datagen.FTBICArmorRecipes;
import dev.ftb.mods.ftbic.datagen.FTBICBatteryRecipes;
import dev.ftb.mods.ftbic.datagen.FTBICCableRecipes;
import dev.ftb.mods.ftbic.datagen.FTBICComponentRecipes;
import dev.ftb.mods.ftbic.datagen.FTBICEnergyStorageRecipes;
import dev.ftb.mods.ftbic.datagen.FTBICGeneratorFuelRecipes;
import dev.ftb.mods.ftbic.datagen.FTBICGeneratorRecipes;
import dev.ftb.mods.ftbic.datagen.FTBICMachineRecipes;
import dev.ftb.mods.ftbic.datagen.FTBICNuclearRecipes;
import dev.ftb.mods.ftbic.datagen.FTBICToolRecipes;
import dev.ftb.mods.ftbic.datagen.FTBICUpgradeRecipes;
import dev.ftb.mods.ftbic.datagen.FTBICVanillaRecipes;
import dev.ftb.mods.ftbic.item.FTBICItems;
import dev.ftb.mods.ftbic.item.MaterialItem;
import dev.ftb.mods.ftbic.util.BurntBlockCondition;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.ItemTagsProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.item.Item;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeLootTableProvider;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;

@Mod.EventBusSubscriber(modid="ftbic", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FTBICDataGenHandler {
    public static final String MODID = "ftbic";

    @SubscribeEvent
    public static void dataGenEvent(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper efh = event.getExistingFileHelper();
        if (event.includeClient()) {
            gen.func_200390_a((IDataProvider)new ICLang(gen, MODID, "en_us"));
            gen.func_200390_a((IDataProvider)new ICTextures(gen, MODID, event.getExistingFileHelper()));
            gen.func_200390_a((IDataProvider)new ICBlockModels(gen, MODID, event.getExistingFileHelper()));
            gen.func_200390_a((IDataProvider)new ICBlockStates(gen, MODID, event.getExistingFileHelper()));
            gen.func_200390_a((IDataProvider)new ICItemModels(gen, MODID, event.getExistingFileHelper()));
        }
        if (event.includeServer()) {
            ICBlockTags blockTags = new ICBlockTags(gen, MODID, efh);
            gen.func_200390_a((IDataProvider)blockTags);
            gen.func_200390_a((IDataProvider)new ICItemTags(gen, blockTags, MODID, efh));
            gen.func_200390_a((IDataProvider)new FTBICComponentRecipes(gen));
            gen.func_200390_a((IDataProvider)new FTBICUpgradeRecipes(gen));
            gen.func_200390_a((IDataProvider)new FTBICCableRecipes(gen));
            gen.func_200390_a((IDataProvider)new FTBICBatteryRecipes(gen));
            gen.func_200390_a((IDataProvider)new FTBICGeneratorRecipes(gen));
            gen.func_200390_a((IDataProvider)new FTBICMachineRecipes(gen));
            gen.func_200390_a((IDataProvider)new FTBICEnergyStorageRecipes(gen));
            gen.func_200390_a((IDataProvider)new FTBICToolRecipes(gen));
            gen.func_200390_a((IDataProvider)new FTBICArmorRecipes(gen));
            gen.func_200390_a((IDataProvider)new FTBICNuclearRecipes(gen));
            gen.func_200390_a((IDataProvider)new FTBICGeneratorFuelRecipes(gen));
            gen.func_200390_a((IDataProvider)new FTBICVanillaRecipes(gen));
            gen.func_200390_a((IDataProvider)new ICLootTableProvider(gen));
        }
    }

    private static class ICLang
    extends LanguageProvider {
        public ICLang(DataGenerator gen, String modid, String locale) {
            super(gen, modid, locale);
        }

        private void addBlock(Supplier<Block> block) {
            this.addBlock(block, Arrays.stream(block.get().getRegistryName().func_110623_a().split("_")).map(s -> Character.toUpperCase(s.charAt(0)) + s.substring(1)).collect(Collectors.joining(" ")));
        }

        private void addItem(Supplier<Item> item) {
            this.addItem(item, Arrays.stream(item.get().getRegistryName().func_110623_a().split("_")).map(s -> Character.toUpperCase(s.charAt(0)) + s.substring(1)).collect(Collectors.joining(" ")));
        }

        protected void addTranslations() {
            this.add("itemGroup.ftbic", "FTB Industrial Contraptions");
            this.addBlock(FTBICBlocks.RUBBER_SHEET);
            this.addBlock(FTBICBlocks.REINFORCED_STONE);
            this.addBlock(FTBICBlocks.REINFORCED_GLASS);
            this.addBlock(FTBICBlocks.MACHINE_BLOCK);
            this.addBlock(FTBICBlocks.ADVANCED_MACHINE_BLOCK);
            this.addBlock(FTBICBlocks.IRON_FURNACE);
            this.addBlock(FTBICBlocks.LV_CABLE, "LV Cable");
            this.addBlock(FTBICBlocks.MV_CABLE, "MV Cable");
            this.addBlock(FTBICBlocks.HV_CABLE, "HV Cable");
            this.addBlock(FTBICBlocks.EV_CABLE, "EV Cable");
            this.addBlock(FTBICBlocks.IV_CABLE, "IV Cable");
            this.addBlock(FTBICBlocks.BURNT_CABLE);
            this.addBlock(FTBICBlocks.LANDMARK);
            this.addBlock(FTBICBlocks.EXFLUID, "Ex-Fluid");
            this.addBlock(FTBICBlocks.NUCLEAR_REACTOR_CHAMBER);
            this.addBlock(FTBICBlocks.NUKE);
            this.addBlock(FTBICBlocks.ACTIVE_NUKE);
            this.addBlock(FTBICBlocks.TRACTOR_BEAM);
            for (ElectricBlockInstance machine : FTBICElectricBlocks.ALL) {
                this.addBlock(machine.block, machine.name);
            }
            for (MaterialItem item : FTBICItems.MATERIALS) {
                this.addItem(item.item, item.name);
            }
            this.addItem(FTBICItems.SINGLE_USE_BATTERY);
            this.addItem(FTBICItems.LV_BATTERY, "LV Battery");
            this.addItem(FTBICItems.MV_BATTERY, "MV Battery");
            this.addItem(FTBICItems.HV_BATTERY, "HV Battery");
            this.addItem(FTBICItems.EV_BATTERY, "EV Battery");
            this.addItem(FTBICItems.CREATIVE_BATTERY);
            this.addItem(FTBICItems.FLUID_CELL);
            this.addItem(FTBICItems.SMALL_COOLANT_CELL);
            this.addItem(FTBICItems.MEDIUM_COOLANT_CELL);
            this.addItem(FTBICItems.LARGE_COOLANT_CELL);
            this.addItem(FTBICItems.URANIUM_FUEL_ROD);
            this.addItem(FTBICItems.DUAL_URANIUM_FUEL_ROD);
            this.addItem(FTBICItems.QUAD_URANIUM_FUEL_ROD);
            this.addItem(FTBICItems.HEAT_VENT);
            this.addItem(FTBICItems.ADVANCED_HEAT_VENT);
            this.addItem(FTBICItems.OVERCLOCKED_HEAT_VENT);
            this.addItem(FTBICItems.REACTOR_HEAT_VENT);
            this.addItem(FTBICItems.COMPONENT_HEAT_VENT);
            this.addItem(FTBICItems.HEAT_EXCHANGER);
            this.addItem(FTBICItems.ADVANCED_HEAT_EXCHANGER);
            this.addItem(FTBICItems.REACTOR_HEAT_EXCHANGER);
            this.addItem(FTBICItems.COMPONENT_HEAT_EXCHANGER);
            this.addItem(FTBICItems.REACTOR_PLATING);
            this.addItem(FTBICItems.CONTAINMENT_REACTOR_PLATING);
            this.addItem(FTBICItems.HEAT_CAPACITY_REACTOR_PLATING, "Heat-Capacity Reactor Plating");
            this.addItem(FTBICItems.NEUTRON_REFLECTOR);
            this.addItem(FTBICItems.THICK_NEUTRON_REFLECTOR);
            this.addItem(FTBICItems.IRIDIUM_NEUTRON_REFLECTOR);
            this.addItem(FTBICItems.CANNED_FOOD);
            this.addItem(FTBICItems.PROTEIN_BAR, "Feed The Beast\u2122 Protein Bar");
            this.addItem(FTBICItems.DARK_SPRAY_PAINT_CAN, "Spray Paint Can (Dark)");
            this.addItem(FTBICItems.LIGHT_SPRAY_PAINT_CAN, "Spray Paint Can (Light)");
            this.addItem(FTBICItems.OVERCLOCKER_UPGRADE);
            this.addItem(FTBICItems.ENERGY_STORAGE_UPGRADE);
            this.addItem(FTBICItems.TRANSFORMER_UPGRADE);
            this.addItem(FTBICItems.EJECTOR_UPGRADE);
            this.addItem(FTBICItems.MECHANICAL_ELYTRA);
            this.addItem(FTBICItems.CARBON_HELMET);
            this.addItem(FTBICItems.CARBON_CHESTPLATE);
            this.addItem(FTBICItems.CARBON_LEGGINGS);
            this.addItem(FTBICItems.CARBON_BOOTS);
            this.addItem(FTBICItems.QUANTUM_HELMET);
            this.addItem(FTBICItems.QUANTUM_CHESTPLATE);
            this.addItem(FTBICItems.QUANTUM_LEGGINGS);
            this.addItem(FTBICItems.QUANTUM_BOOTS);
            this.addItem(FTBICItems.NUKE_ARROW);
            this.add("recipe.ftbic.macerating", "Macerating");
            this.add("recipe.ftbic.separating", "Separating");
            this.add("recipe.ftbic.compressing", "Compressing");
            this.add("recipe.ftbic.reprocessing", "Reprocessing");
            this.add("recipe.ftbic.canning", "Canning");
            this.add("recipe.ftbic.rolling", "Rolling");
            this.add("recipe.ftbic.extruding", "Extruding");
            this.add("recipe.ftbic.reconstructing", "Reconstructing");
            this.add("ftbic.energy_output", "Energy Output: %s");
            this.add("ftbic.energy_capacity", "Energy Capacity: %s");
            this.add("ftbic.energy_usage", "Energy Usage: %s");
            this.add("ftbic.max_input", "Max Input: %s");
            this.add("ftbic.fuse_info", "Right-click with a Fuse on this machine to repair it!");
            this.add("ftbic.any_item", "Any Item");
            this.add("ftbic.requires_chestplate", "Requires Chestplate to function");
            this.add("item.ftbic.spray_paint_can.tooltip", "Right-click on a machine to change its theme");
            this.add("block.ftbic.teleporter.perm_error", "Only owner of this teleporter can change it's settings!");
            this.add("block.ftbic.teleporter.load_error", "The destination chunk has to be loaded!");
            this.add("block.ftbic.nuke.broadcast", "%s has launched a Nuke!");
            this.add("block.ftbic.nuclear_reactor.broadcast", "%s forgot to cool their Nuclear Reactor!");
        }
    }

    private static class ICTextures
    extends CombinedTextureProvider {
        public static final int WOOD_UNIVERSAL = 0;
        public static final int BASIC_UNIVERSAL = 1;
        public static final int BASIC_TOP = 2;
        public static final int BASIC_BOTTOM = 3;
        public static final int BASIC_SIDE = 4;
        public static final int ADVANCED_UNIVERSAL = 5;
        public static final int ADVANCED_TOP = 6;
        public static final int ADVANCED_BOTTOM = 7;
        public static final int ADVANCED_SIDE = 8;
        public static final String[] TEMPLATES = new String[]{"wood_universal", "basic_universal", "basic_top", "basic_bottom", "basic_side", "advanced_universal", "advanced_top", "advanced_bottom", "advanced_side"};

        public ICTextures(DataGenerator g, String mod, ExistingFileHelper efh) {
            super(g, mod, efh);
        }

        private void makeThemedElectric(String path, int texture, String source) {
            CombinedTextureProvider.TextureData lightBase = this.load(this.modLoc("block/electric/light/" + TEMPLATES[texture]));
            CombinedTextureProvider.TextureData darkBase = this.load(this.modLoc("block/electric/dark/" + TEMPLATES[texture]));
            this.make(this.modLoc("block/electric/light/" + path), lightBase.combine(this.load(this.modLoc("block/electric/light/template/" + source))));
            this.make(this.modLoc("block/electric/dark/" + path), darkBase.combine(this.load(this.modLoc("block/electric/dark/template/" + source))));
        }

        private void makeThemedElectric(String path, int texture) {
            this.makeThemedElectric(path, texture, path);
        }

        private void makeThemedElectricOnOff(String path, int texture, String source) {
            this.makeThemedElectric(path + "_on", texture, source + "_on");
            this.makeThemedElectric(path + "_off", texture, source + "_off");
        }

        private void makeThemedElectricOnOff(String path, int texture) {
            this.makeThemedElectricOnOff(path, texture, path);
        }

        @Override
        public void registerTextures() {
            this.makeThemedElectricOnOff("basic_generator_front", 4);
            this.makeThemedElectricOnOff("geothermal_generator_front", 4);
            this.makeThemedElectric("wind_mill_front", 4);
            this.makeThemedElectric("lv_solar_panel_top", 2);
            this.makeThemedElectric("mv_solar_panel_top", 2);
            this.makeThemedElectric("hv_solar_panel_top", 6);
            this.makeThemedElectric("ev_solar_panel_top", 6);
            this.makeThemedElectricOnOff("nuclear_reactor_front", 8);
            this.makeThemedElectric("nuclear_reactor_top", 6);
            this.makeThemedElectricOnOff("powered_furnace_front", 4);
            this.makeThemedElectric("macerator_front", 4);
            this.makeThemedElectricOnOff("macerator_top", 2);
            this.makeThemedElectricOnOff("centrifuge_front", 4);
            this.makeThemedElectric("centrifuge_top", 2);
            this.makeThemedElectricOnOff("compressor_front", 4);
            this.makeThemedElectric("compressor_top", 2);
            this.makeThemedElectricOnOff("reprocessor_front", 4);
            this.makeThemedElectric("reprocessor_top", 2);
            this.makeThemedElectricOnOff("canning_machine_front", 4);
            this.makeThemedElectricOnOff("roller_front", 4);
            this.makeThemedElectricOnOff("extruder_front", 4);
            this.makeThemedElectricOnOff("antimatter_constructor_front", 8);
            this.makeThemedElectric("antimatter_constructor_side", 8);
            this.makeThemedElectricOnOff("advanced_powered_furnace_front", 8, "powered_furnace_front");
            this.makeThemedElectric("advanced_macerator_front", 8, "macerator_front");
            this.makeThemedElectricOnOff("advanced_macerator_top", 6, "macerator_top");
            this.makeThemedElectricOnOff("advanced_centrifuge_front", 8, "centrifuge_front");
            this.makeThemedElectric("advanced_centrifuge_top", 6, "centrifuge_top");
            this.makeThemedElectricOnOff("advanced_compressor_front", 8, "compressor_front");
            this.makeThemedElectric("advanced_compressor_top", 6, "compressor_top");
            this.makeThemedElectricOnOff("teleporter_top", 6, "teleporter_top");
            this.makeThemedElectricOnOff("charge_pad_top", 2, "charge_pad_top");
            this.makeThemedElectric("powered_crafting_table_top", 2, "powered_crafting_table_top");
            this.makeThemedElectricOnOff("quarry_front", 8);
            this.makeThemedElectricOnOff("pump_front", 8);
            this.makeThemedElectric("lv_battery_box_in", 0);
            this.makeThemedElectric("lv_battery_box_out", 0);
            this.makeThemedElectric("lv_transformer_in", 0);
            this.makeThemedElectric("lv_transformer_out", 0);
            this.makeThemedElectric("mv_battery_box_in", 1);
            this.makeThemedElectric("mv_battery_box_out", 1);
            this.makeThemedElectric("mv_transformer_in", 1);
            this.makeThemedElectric("mv_transformer_out", 1);
            this.makeThemedElectric("hv_battery_box_in", 5);
            this.makeThemedElectric("hv_battery_box_out", 5);
            this.makeThemedElectric("hv_transformer_in", 5);
            this.makeThemedElectric("hv_transformer_out", 5);
            this.makeThemedElectric("ev_battery_box_in", 5);
            this.makeThemedElectric("ev_battery_box_out", 5);
            this.makeThemedElectric("ev_transformer_in", 5);
            this.makeThemedElectric("ev_transformer_out", 5);
        }
    }

    private static class ICBlockModels
    extends BlockModelProvider {
        public static final String BASIC_TOP = "basic_top";
        public static final String BASIC_BOTTOM = "basic_bottom";
        public static final String BASIC_SIDE = "basic_side";
        public static final String ADVANCED_TOP = "advanced_top";
        public static final String ADVANCED_BOTTOM = "advanced_bottom";
        public static final String ADVANCED_SIDE = "advanced_side";

        public ICBlockModels(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
            super(generator, modid, existingFileHelper);
        }

        private void electric(String id, String front, String side, String top, String bottom) {
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/electric/light/" + id, this.modLoc("block/orientable_2d"))).texture("side", this.modLoc("block/electric/light/" + side))).texture("front", this.modLoc("block/electric/light/" + front))).texture("top", this.modLoc("block/electric/light/" + top))).texture("bottom", this.modLoc("block/electric/light/" + bottom));
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/electric/dark/" + id, this.modLoc("block/orientable_2d"))).texture("side", this.modLoc("block/electric/dark/" + side))).texture("front", this.modLoc("block/electric/dark/" + front))).texture("top", this.modLoc("block/electric/dark/" + top))).texture("bottom", this.modLoc("block/electric/dark/" + bottom));
        }

        private void electric3d(String id, String front, String side) {
            ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/electric/light/" + id, this.modLoc("block/orientable_3d"))).texture("side", this.modLoc("block/electric/light/" + side))).texture("front", this.modLoc("block/electric/light/" + front));
            ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/electric/dark/" + id, this.modLoc("block/orientable_3d"))).texture("side", this.modLoc("block/electric/dark/" + side))).texture("front", this.modLoc("block/electric/dark/" + front));
        }

        protected void registerModels() {
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/rubber_sheet", "block/block")).texture("texture", this.modLoc("block/rubber_sheet"))).texture("particle", this.modLoc("block/rubber_sheet"))).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 3.0f, 16.0f).face(Direction.DOWN).texture("#texture").cullface(Direction.DOWN).end().face(Direction.UP).texture("#texture").end().face(Direction.NORTH).texture("#texture").cullface(Direction.NORTH).end().face(Direction.SOUTH).texture("#texture").cullface(Direction.SOUTH).end().face(Direction.WEST).texture("#texture").cullface(Direction.WEST).end().face(Direction.EAST).texture("#texture").cullface(Direction.EAST).end().end();
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/machine_block", "block/cube_all")).texture("all", this.modLoc("block/electric/light/basic_side"))).texture("top", this.modLoc("block/electric/light/basic_top"))).texture("bottom", this.modLoc("block/electric/light/basic_bottom"));
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/advanced_machine_block", "block/cube_all")).texture("all", this.modLoc("block/electric/light/advanced_side"))).texture("top", this.modLoc("block/electric/light/advanced_top"))).texture("bottom", this.modLoc("block/electric/light/advanced_bottom"));
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/orientable_2d", "block/block")).texture("particle", "#side")).transforms().transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).rotation(0.0f, 135.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.4f, 0.4f, 0.4f).end().end()).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.DOWN).texture("#bottom").cullface(Direction.DOWN).end().face(Direction.UP).texture("#top").cullface(Direction.UP).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.NORTH).texture("#front").cullface(Direction.NORTH).end().face(Direction.SOUTH).texture("#side").cullface(Direction.SOUTH).end().face(Direction.WEST).texture("#side").cullface(Direction.WEST).end().face(Direction.EAST).texture("#side").cullface(Direction.EAST).end().end();
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/orientable_3d", "block/block")).texture("particle", "#side")).transforms().transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).rotation(0.0f, 135.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.4f, 0.4f, 0.4f).end().end()).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.DOWN).texture("#side").cullface(Direction.DOWN).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.UP).texture("#side").cullface(Direction.UP).end().face(Direction.NORTH).texture("#front").cullface(Direction.NORTH).end().face(Direction.SOUTH).texture("#side").cullface(Direction.SOUTH).end().face(Direction.WEST).texture("#side").cullface(Direction.WEST).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end().face(Direction.EAST).texture("#side").cullface(Direction.EAST).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).end().end();
            for (Supplier<Block> cable : FTBICBlocks.CABLES) {
                BaseCableBlock block = (BaseCableBlock)cable.get();
                String id = block.getRegistryName().func_110623_a();
                ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/" + id + "_base", "block/block")).texture("texture", this.modLoc("block/" + id))).texture("particle", this.modLoc("block/" + id))).element().from((float)block.border, (float)block.border, (float)block.border).to(16.0f - (float)block.border, 16.0f - (float)block.border, 16.0f - (float)block.border).face(Direction.DOWN).texture("#texture").end().face(Direction.UP).texture("#texture").end().face(Direction.NORTH).texture("#texture").end().face(Direction.SOUTH).texture("#texture").end().face(Direction.WEST).texture("#texture").end().face(Direction.EAST).texture("#texture").end().end();
                ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/" + id + "_connection", "block/block")).texture("texture", this.modLoc("block/" + id))).texture("particle", this.modLoc("block/" + id))).element().from((float)block.border, 0.0f, (float)block.border).to(16.0f - (float)block.border, (float)block.border, 16.0f - (float)block.border).face(Direction.DOWN).texture("#texture").cullface(Direction.DOWN).end().face(Direction.NORTH).texture("#texture").end().face(Direction.SOUTH).texture("#texture").end().face(Direction.WEST).texture("#texture").end().face(Direction.EAST).texture("#texture").end().end();
            }
            this.orientable("block/iron_furnace_off", this.modLoc("block/iron_furnace_side"), this.modLoc("block/iron_furnace_front_off"), this.modLoc("block/iron_furnace_top"));
            this.orientable("block/iron_furnace_on", this.modLoc("block/iron_furnace_side"), this.modLoc("block/iron_furnace_front_on"), this.modLoc("block/iron_furnace_top"));
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/landmark", "block/block")).texture("particle", this.modLoc("block/landmark_ns"))).texture("landmark_ns", this.modLoc("block/landmark_ns"))).texture("landmark_we", this.modLoc("block/landmark_we"))).ao(false)).element().from(7.0f, 0.0f, 7.0f).to(9.0f, 7.0f, 9.0f).shade(false).face(Direction.DOWN).texture("#landmark_ns").cullface(Direction.DOWN).end().face(Direction.NORTH).texture("#landmark_ns").end().face(Direction.SOUTH).texture("#landmark_ns").end().face(Direction.WEST).texture("#landmark_we").end().face(Direction.EAST).texture("#landmark_we").end().end()).element().from(6.97f, 6.97f, 6.97f).to(9.03f, 9.03f, 9.03f).shade(false).face(Direction.DOWN).uvs(7.0f, 7.0f, 9.0f, 9.0f).texture("#landmark_ns").end().face(Direction.UP).uvs(7.0f, 7.0f, 9.0f, 9.0f).texture("#landmark_ns").end().face(Direction.NORTH).uvs(7.0f, 7.0f, 9.0f, 9.0f).texture("#landmark_ns").end().face(Direction.SOUTH).uvs(7.0f, 7.0f, 9.0f, 9.0f).texture("#landmark_ns").end().face(Direction.WEST).uvs(7.0f, 7.0f, 9.0f, 9.0f).texture("#landmark_we").end().face(Direction.EAST).uvs(7.0f, 7.0f, 9.0f, 9.0f).texture("#landmark_we").end().end();
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/nuclear_reactor_chamber", "block/cube_bottom_top")).texture("top", this.modLoc("block/electric/light/nuclear_reactor_top"))).texture("bottom", this.modLoc("block/electric/light/advanced_bottom"))).texture("side", this.modLoc("block/electric/light/advanced_side"));
            ((BlockModelBuilder)this.withExistingParent("block/nuke", "block/tnt")).texture("side", this.modLoc("block/nuke_side"));
            ((BlockModelBuilder)this.withExistingParent("block/active_nuke", "block/tnt")).texture("side", this.modLoc("block/nuke_side_active"));
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/tractor_beam", "block/block")).texture("particle", this.modLoc("block/tractor_beam"))).texture("texture", this.modLoc("block/tractor_beam"))).ao(false)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 0.0f).shade(false).face(Direction.NORTH).cullface(Direction.NORTH).texture("#texture").end().face(Direction.SOUTH).cullface(Direction.NORTH).texture("#texture").end().end()).element().from(0.0f, 0.0f, 16.0f).to(16.0f, 16.0f, 16.0f).shade(false).face(Direction.NORTH).cullface(Direction.SOUTH).texture("#texture").end().face(Direction.SOUTH).cullface(Direction.SOUTH).texture("#texture").end().end()).element().from(0.0f, 0.0f, 0.0f).to(0.0f, 16.0f, 16.0f).shade(false).face(Direction.WEST).cullface(Direction.WEST).texture("#texture").end().face(Direction.EAST).cullface(Direction.WEST).texture("#texture").end().end()).element().from(16.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).shade(false).face(Direction.WEST).cullface(Direction.EAST).texture("#texture").end().face(Direction.EAST).cullface(Direction.EAST).texture("#texture").end().end();
            this.electric("basic_generator_off", "basic_generator_front_off", BASIC_SIDE, BASIC_TOP, BASIC_BOTTOM);
            this.electric("basic_generator_on", "basic_generator_front_on", BASIC_SIDE, BASIC_TOP, BASIC_BOTTOM);
            this.electric("geothermal_generator_off", "geothermal_generator_front_off", BASIC_SIDE, BASIC_TOP, BASIC_BOTTOM);
            this.electric("geothermal_generator_on", "geothermal_generator_front_on", BASIC_SIDE, BASIC_TOP, BASIC_BOTTOM);
            this.electric("wind_mill", "wind_mill_front", BASIC_SIDE, BASIC_TOP, BASIC_BOTTOM);
            this.electric("lv_solar_panel", BASIC_SIDE, BASIC_SIDE, "lv_solar_panel_top", BASIC_BOTTOM);
            this.electric("mv_solar_panel", BASIC_SIDE, BASIC_SIDE, "mv_solar_panel_top", BASIC_BOTTOM);
            this.electric("hv_solar_panel", ADVANCED_SIDE, ADVANCED_SIDE, "hv_solar_panel_top", ADVANCED_BOTTOM);
            this.electric("ev_solar_panel", ADVANCED_SIDE, ADVANCED_SIDE, "ev_solar_panel_top", ADVANCED_BOTTOM);
            this.electric("nuclear_reactor_off", "nuclear_reactor_front_off", ADVANCED_SIDE, "nuclear_reactor_top", ADVANCED_BOTTOM);
            this.electric("nuclear_reactor_on", "nuclear_reactor_front_on", ADVANCED_SIDE, "nuclear_reactor_top", ADVANCED_BOTTOM);
            this.electric("powered_furnace_off", "powered_furnace_front_off", BASIC_SIDE, BASIC_TOP, BASIC_BOTTOM);
            this.electric("powered_furnace_on", "powered_furnace_front_on", BASIC_SIDE, BASIC_TOP, BASIC_BOTTOM);
            this.electric("macerator_off", "macerator_front", BASIC_SIDE, "macerator_top_off", BASIC_BOTTOM);
            this.electric("macerator_on", "macerator_front", BASIC_SIDE, "macerator_top_on", BASIC_BOTTOM);
            this.electric("centrifuge_off", "centrifuge_front_off", BASIC_SIDE, "centrifuge_top", BASIC_BOTTOM);
            this.electric("centrifuge_on", "centrifuge_front_on", BASIC_SIDE, "centrifuge_top", BASIC_BOTTOM);
            this.electric("compressor_off", "compressor_front_off", BASIC_SIDE, "compressor_top", BASIC_BOTTOM);
            this.electric("compressor_on", "compressor_front_on", BASIC_SIDE, "compressor_top", BASIC_BOTTOM);
            this.electric("reprocessor_off", "reprocessor_front_off", BASIC_SIDE, "reprocessor_top", BASIC_BOTTOM);
            this.electric("reprocessor_on", "reprocessor_front_on", BASIC_SIDE, "reprocessor_top", BASIC_BOTTOM);
            this.electric("canning_machine_off", "canning_machine_front_off", BASIC_SIDE, BASIC_TOP, BASIC_BOTTOM);
            this.electric("canning_machine_on", "canning_machine_front_on", BASIC_SIDE, BASIC_TOP, BASIC_BOTTOM);
            this.electric("roller_off", "roller_front_off", BASIC_SIDE, BASIC_TOP, BASIC_BOTTOM);
            this.electric("roller_on", "roller_front_on", BASIC_SIDE, BASIC_TOP, BASIC_BOTTOM);
            this.electric("extruder_off", "extruder_front_off", BASIC_SIDE, BASIC_TOP, BASIC_BOTTOM);
            this.electric("extruder_on", "extruder_front_on", BASIC_SIDE, BASIC_TOP, BASIC_BOTTOM);
            this.electric("antimatter_constructor_off", "antimatter_constructor_front_off", "antimatter_constructor_side", ADVANCED_TOP, ADVANCED_BOTTOM);
            this.electric("antimatter_constructor_on", "antimatter_constructor_front_on", "antimatter_constructor_side", ADVANCED_TOP, ADVANCED_BOTTOM);
            this.electric("advanced_powered_furnace_off", "advanced_powered_furnace_front_off", ADVANCED_SIDE, ADVANCED_TOP, ADVANCED_BOTTOM);
            this.electric("advanced_powered_furnace_on", "advanced_powered_furnace_front_on", ADVANCED_SIDE, ADVANCED_TOP, ADVANCED_BOTTOM);
            this.electric("advanced_macerator_off", "advanced_macerator_front", ADVANCED_SIDE, "advanced_macerator_top_off", ADVANCED_BOTTOM);
            this.electric("advanced_macerator_on", "advanced_macerator_front", ADVANCED_SIDE, "advanced_macerator_top_on", ADVANCED_BOTTOM);
            this.electric("advanced_centrifuge_off", "advanced_centrifuge_front_off", ADVANCED_SIDE, "advanced_centrifuge_top", ADVANCED_BOTTOM);
            this.electric("advanced_centrifuge_on", "advanced_centrifuge_front_on", ADVANCED_SIDE, "advanced_centrifuge_top", ADVANCED_BOTTOM);
            this.electric("advanced_compressor_off", "advanced_compressor_front_off", ADVANCED_SIDE, "advanced_compressor_top", ADVANCED_BOTTOM);
            this.electric("advanced_compressor_on", "advanced_compressor_front_on", ADVANCED_SIDE, "advanced_compressor_top", ADVANCED_BOTTOM);
            this.electric("teleporter_off", ADVANCED_SIDE, ADVANCED_SIDE, "teleporter_top_off", ADVANCED_BOTTOM);
            this.electric("teleporter_on", ADVANCED_SIDE, ADVANCED_SIDE, "teleporter_top_on", ADVANCED_BOTTOM);
            this.electric("charge_pad_off", BASIC_SIDE, BASIC_SIDE, "charge_pad_top_off", BASIC_BOTTOM);
            this.electric("charge_pad_on", BASIC_SIDE, BASIC_SIDE, "charge_pad_top_on", BASIC_BOTTOM);
            this.electric("powered_crafting_table", BASIC_SIDE, BASIC_SIDE, "powered_crafting_table_top", BASIC_BOTTOM);
            this.electric("quarry_off", "quarry_front_off", ADVANCED_SIDE, ADVANCED_TOP, ADVANCED_BOTTOM);
            this.electric("quarry_on", "quarry_front_on", ADVANCED_SIDE, ADVANCED_TOP, ADVANCED_BOTTOM);
            this.electric("pump_off", "pump_front_off", ADVANCED_SIDE, ADVANCED_TOP, ADVANCED_BOTTOM);
            this.electric("pump_on", "pump_front_on", ADVANCED_SIDE, ADVANCED_TOP, ADVANCED_BOTTOM);
            this.electric3d("lv_battery_box", "lv_battery_box_out", "lv_battery_box_in");
            this.electric3d("lv_transformer", "lv_transformer_in", "lv_transformer_out");
            this.electric3d("mv_battery_box", "mv_battery_box_out", "mv_battery_box_in");
            this.electric3d("mv_transformer", "mv_transformer_in", "mv_transformer_out");
            this.electric3d("hv_battery_box", "hv_battery_box_out", "hv_battery_box_in");
            this.electric3d("hv_transformer", "hv_transformer_in", "hv_transformer_out");
            this.electric3d("ev_battery_box", "ev_battery_box_out", "ev_battery_box_in");
            this.electric3d("ev_transformer", "ev_transformer_in", "ev_transformer_out");
        }
    }

    private static class ICBlockStates
    extends BlockStateProvider {
        public ICBlockStates(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
            super(gen, modid, exFileHelper);
        }

        protected void registerStatesAndModels() {
            this.simpleBlock(FTBICBlocks.RUBBER_SHEET.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/rubber_sheet")));
            this.simpleBlock(FTBICBlocks.REINFORCED_STONE.get());
            this.simpleBlock(FTBICBlocks.REINFORCED_GLASS.get());
            this.simpleBlock(FTBICBlocks.MACHINE_BLOCK.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/machine_block")));
            this.simpleBlock(FTBICBlocks.ADVANCED_MACHINE_BLOCK.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/advanced_machine_block")));
            this.getVariantBuilder(FTBICBlocks.IRON_FURNACE.get()).forAllStatesExcept(state -> {
                boolean lit = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q);
                Direction facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
                return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(lit ? "block/iron_furnace_on" : "block/iron_furnace_off"))).rotationY(((facing.func_176736_b() & 3) * 90 + 180) % 360).build();
            }, new Property[0]);
            for (Supplier<Block> cable : FTBICBlocks.CABLES) {
                BaseCableBlock block = (BaseCableBlock)cable.get();
                String id = block.getRegistryName().func_110623_a();
                MultiPartBlockStateBuilder builder = this.getMultipartBuilder(cable.get());
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + id + "_base"))).addModel()).end();
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + id + "_connection"))).rotationX(0).rotationY(0).addModel()).condition((Property)CableBlock.CONNECTION[0], (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + id + "_connection"))).rotationX(180).rotationY(0).addModel()).condition((Property)CableBlock.CONNECTION[1], (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + id + "_connection"))).rotationX(90).rotationY(180).addModel()).condition((Property)CableBlock.CONNECTION[2], (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + id + "_connection"))).rotationX(90).rotationY(0).addModel()).condition((Property)CableBlock.CONNECTION[3], (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + id + "_connection"))).rotationX(90).rotationY(90).addModel()).condition((Property)CableBlock.CONNECTION[4], (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + id + "_connection"))).rotationX(90).rotationY(270).addModel()).condition((Property)CableBlock.CONNECTION[5], (Comparable[])new Boolean[]{true}).end();
            }
            this.simpleBlock(FTBICBlocks.LANDMARK.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/landmark")));
            this.simpleBlock(FTBICBlocks.EXFLUID.get(), new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(this.mcLoc("block/dead_horn_coral_block"))), new ConfiguredModel((ModelFile)this.models().getExistingFile(this.mcLoc("block/dead_fire_coral_block"))), new ConfiguredModel((ModelFile)this.models().getExistingFile(this.mcLoc("block/dead_bubble_coral_block"))), new ConfiguredModel((ModelFile)this.models().getExistingFile(this.mcLoc("block/dead_brain_coral_block"))), new ConfiguredModel((ModelFile)this.models().getExistingFile(this.mcLoc("block/dead_tube_coral_block")))});
            this.simpleBlock(FTBICBlocks.NUCLEAR_REACTOR_CHAMBER.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/nuclear_reactor_chamber")));
            this.simpleBlock(FTBICBlocks.NUKE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/nuke")));
            this.simpleBlock(FTBICBlocks.ACTIVE_NUKE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/active_nuke")));
            this.directionalBlock(FTBICBlocks.TRACTOR_BEAM.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/tractor_beam")));
            for (ElectricBlockInstance machine : FTBICElectricBlocks.ALL) {
                if (machine.noModel) continue;
                this.getVariantBuilder(machine.block.get()).forAllStatesExcept(state -> {
                    boolean on = machine.canBeActive && (Boolean)state.func_177229_b((Property)ElectricBlock.ACTIVE) != false;
                    boolean dark = (Boolean)state.func_177229_b((Property)SprayPaintable.DARK);
                    ModelFile.ExistingModelFile modelFile = this.models().getExistingFile(this.modLoc("block/electric/" + (dark ? "dark" : "light") + "/" + machine.id + (machine.canBeActive ? (on ? "_on" : "_off") : "")));
                    if (machine.facingProperty == null) {
                        return ConfiguredModel.builder().modelFile((ModelFile)modelFile).build();
                    }
                    if (machine.facingProperty == BlockStateProperties.field_208157_J) {
                        Direction facing = (Direction)state.func_177229_b((Property)machine.facingProperty);
                        return ConfiguredModel.builder().modelFile((ModelFile)modelFile).rotationY(((facing.func_176736_b() & 3) * 90 + 180) % 360).build();
                    }
                    Direction facing = (Direction)state.func_177229_b((Property)machine.facingProperty);
                    return ConfiguredModel.builder().modelFile((ModelFile)modelFile).rotationX(facing == Direction.DOWN ? 90 : (facing.func_176740_k().func_176722_c() ? 0 : 270)).rotationY(facing.func_176740_k().func_200128_b() ? 0 : ((facing.func_176736_b() & 3) * 90 + 180) % 360).build();
                }, new Property[0]);
            }
        }
    }

    private static class ICItemModels
    extends ItemModelProvider {
        public ICItemModels(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
            super(generator, modid, existingFileHelper);
        }

        private void basicItem(Supplier<? extends Item> item) {
            String id = item.get().getRegistryName().func_110623_a();
            this.singleTexture(id, this.mcLoc("item/generated"), "layer0", this.modLoc("item/" + id));
        }

        private void handheldItem(Supplier<? extends Item> item) {
            String id = item.get().getRegistryName().func_110623_a();
            this.singleTexture(id, this.mcLoc("item/handheld"), "layer0", this.modLoc("item/" + id));
        }

        private void basicBlockItem(Supplier<Block> block) {
            String id = block.get().getRegistryName().func_110623_a();
            this.withExistingParent(id, this.modLoc("block/" + id));
        }

        protected void registerModels() {
            this.basicBlockItem(FTBICBlocks.RUBBER_SHEET);
            this.basicBlockItem(FTBICBlocks.REINFORCED_STONE);
            this.basicBlockItem(FTBICBlocks.REINFORCED_GLASS);
            this.basicBlockItem(FTBICBlocks.MACHINE_BLOCK);
            this.basicBlockItem(FTBICBlocks.ADVANCED_MACHINE_BLOCK);
            this.withExistingParent(FTBICBlocks.IRON_FURNACE.get().getRegistryName().func_110623_a(), this.modLoc("block/iron_furnace_off"));
            for (Supplier<Block> cable : FTBICBlocks.CABLES) {
                String id = cable.get().getRegistryName().func_110623_a();
                int b0 = ((BaseCableBlock)cable.get()).border;
                int b1 = 16 - b0;
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("item/" + id, "block/block")).texture("particle", this.modLoc("block/" + id))).texture("cable", this.modLoc("block/" + id))).transforms().transform(ModelBuilder.Perspective.THIRDPERSON_RIGHT).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 1.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ModelBuilder.Perspective.THIRDPERSON_LEFT).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 1.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).rotation(0.0f, 45.0f, 0.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ModelBuilder.Perspective.FIRSTPERSON_LEFT).rotation(0.0f, 225.0f, 0.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ModelBuilder.Perspective.GROUND).translation(0.0f, 3.0f, 0.0f).scale(0.25f, 0.25f, 0.25f).end().transform(ModelBuilder.Perspective.GUI).rotation(45.0f, 45.0f, 90.0f).translation(1.75f, 1.0f, 0.0f).scale(0.625f, 0.625f, 0.625f).end().transform(ModelBuilder.Perspective.FIXED).translation(0.0f, -1.5f, 0.0f).scale(0.5f, 0.5f, 0.5f).end().end()).element().from((float)b0, 0.0f, (float)b0).to((float)b1, (float)b1, (float)b1).face(Direction.NORTH).texture("#cable").uvs((float)b0, (float)b0, (float)b1, 16.0f).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.EAST).texture("#cable").uvs((float)b0, (float)b0, (float)b1, 16.0f).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.SOUTH).texture("#cable").uvs((float)b0, (float)b0, (float)b1, 16.0f).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.WEST).texture("#cable").uvs((float)b0, (float)b0, (float)b1, 16.0f).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.UP).texture("#cable").uvs((float)b0, (float)b0, (float)b1, (float)b1).end().face(Direction.DOWN).texture("#cable").uvs((float)b0, (float)b0, (float)b1, (float)b1).end().end()).element().from((float)b0, (float)b1, (float)b0).to((float)b1, (float)(b1 * 2), (float)b1).face(Direction.NORTH).texture("#cable").uvs((float)b1, 16.0f, (float)b0, (float)b0).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.EAST).texture("#cable").uvs((float)b1, 16.0f, (float)b0, (float)b0).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.SOUTH).texture("#cable").uvs((float)b1, 16.0f, (float)b0, (float)b0).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.WEST).texture("#cable").uvs((float)b1, 16.0f, (float)b0, (float)b0).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.UP).texture("#cable").uvs((float)b1, (float)b1, (float)b0, (float)b0).end().face(Direction.DOWN).texture("#cable").uvs((float)b1, (float)b1, (float)b0, (float)b0).end().end();
            }
            this.singleTexture("landmark", this.mcLoc("item/generated"), "layer0", this.modLoc("block/landmark_ns"));
            this.withExistingParent(FTBICBlocks.EXFLUID.get().getRegistryName().func_110623_a(), this.mcLoc("block/dead_horn_coral_block"));
            this.basicBlockItem(FTBICBlocks.NUCLEAR_REACTOR_CHAMBER);
            this.basicBlockItem(FTBICBlocks.NUKE);
            this.basicBlockItem(FTBICBlocks.ACTIVE_NUKE);
            this.basicBlockItem(FTBICBlocks.TRACTOR_BEAM);
            for (ElectricBlockInstance machine : FTBICElectricBlocks.ALL) {
                if (machine.noModel) continue;
                this.withExistingParent(machine.id, this.modLoc("block/electric/light/" + machine.id + (machine.canBeActive ? "_off" : "")));
            }
            for (MaterialItem item : FTBICItems.MATERIALS) {
                this.basicItem(item.item);
            }
            this.basicItem(FTBICItems.SINGLE_USE_BATTERY);
            this.basicItem(FTBICItems.LV_BATTERY);
            this.basicItem(FTBICItems.MV_BATTERY);
            this.basicItem(FTBICItems.HV_BATTERY);
            this.basicItem(FTBICItems.EV_BATTERY);
            this.basicItem(FTBICItems.CREATIVE_BATTERY);
            this.basicItem(FTBICItems.SMALL_COOLANT_CELL);
            this.basicItem(FTBICItems.MEDIUM_COOLANT_CELL);
            this.basicItem(FTBICItems.LARGE_COOLANT_CELL);
            this.basicItem(FTBICItems.URANIUM_FUEL_ROD);
            this.basicItem(FTBICItems.DUAL_URANIUM_FUEL_ROD);
            this.basicItem(FTBICItems.QUAD_URANIUM_FUEL_ROD);
            this.basicItem(FTBICItems.HEAT_VENT);
            this.basicItem(FTBICItems.ADVANCED_HEAT_VENT);
            this.basicItem(FTBICItems.OVERCLOCKED_HEAT_VENT);
            this.basicItem(FTBICItems.REACTOR_HEAT_VENT);
            this.basicItem(FTBICItems.COMPONENT_HEAT_VENT);
            this.basicItem(FTBICItems.HEAT_EXCHANGER);
            this.basicItem(FTBICItems.ADVANCED_HEAT_EXCHANGER);
            this.basicItem(FTBICItems.REACTOR_HEAT_EXCHANGER);
            this.basicItem(FTBICItems.COMPONENT_HEAT_EXCHANGER);
            this.basicItem(FTBICItems.REACTOR_PLATING);
            this.basicItem(FTBICItems.CONTAINMENT_REACTOR_PLATING);
            this.basicItem(FTBICItems.HEAT_CAPACITY_REACTOR_PLATING);
            this.basicItem(FTBICItems.NEUTRON_REFLECTOR);
            this.basicItem(FTBICItems.THICK_NEUTRON_REFLECTOR);
            this.basicItem(FTBICItems.IRIDIUM_NEUTRON_REFLECTOR);
            this.basicItem(FTBICItems.CANNED_FOOD);
            this.basicItem(FTBICItems.PROTEIN_BAR);
            this.basicItem(FTBICItems.DARK_SPRAY_PAINT_CAN);
            this.basicItem(FTBICItems.LIGHT_SPRAY_PAINT_CAN);
            this.basicItem(FTBICItems.OVERCLOCKER_UPGRADE);
            this.basicItem(FTBICItems.ENERGY_STORAGE_UPGRADE);
            this.basicItem(FTBICItems.TRANSFORMER_UPGRADE);
            this.basicItem(FTBICItems.EJECTOR_UPGRADE);
            this.basicItem(FTBICItems.MECHANICAL_ELYTRA);
            this.basicItem(FTBICItems.CARBON_HELMET);
            this.basicItem(FTBICItems.CARBON_CHESTPLATE);
            this.basicItem(FTBICItems.CARBON_LEGGINGS);
            this.basicItem(FTBICItems.CARBON_BOOTS);
            this.basicItem(FTBICItems.QUANTUM_HELMET);
            this.basicItem(FTBICItems.QUANTUM_CHESTPLATE);
            this.basicItem(FTBICItems.QUANTUM_LEGGINGS);
            this.basicItem(FTBICItems.QUANTUM_BOOTS);
            this.basicItem(FTBICItems.NUKE_ARROW);
        }
    }

    private static class ICBlockTags
    extends BlockTagsProvider {
        public ICBlockTags(DataGenerator generatorIn, String modId, ExistingFileHelper existingFileHelper) {
            super(generatorIn, modId, existingFileHelper);
        }

        protected void func_200432_c() {
            this.func_240522_a_(FTBICUtils.REINFORCED).func_240534_a_((Object[])new Block[]{FTBICBlocks.REINFORCED_STONE.get(), FTBICBlocks.REINFORCED_GLASS.get(), Blocks.field_150357_h, Blocks.field_180401_cv, Blocks.field_150483_bI});
            this.func_240522_a_(BlockTags.field_219754_W).func_240534_a_((Object[])new Block[]{FTBICBlocks.REINFORCED_STONE.get(), FTBICBlocks.REINFORCED_GLASS.get()});
            this.func_240522_a_(BlockTags.field_219755_X).func_240534_a_((Object[])new Block[]{FTBICBlocks.REINFORCED_STONE.get(), FTBICBlocks.REINFORCED_GLASS.get()});
        }
    }

    private static class ICItemTags
    extends ItemTagsProvider {
        public ICItemTags(DataGenerator dataGenerator, BlockTagsProvider blockTagProvider, String modId, ExistingFileHelper existingFileHelper) {
            super(dataGenerator, blockTagProvider, modId, existingFileHelper);
        }

        protected void func_200432_c() {
            this.func_240522_a_(FTBICUtils.UNCANNABLE_FOOD).func_240534_a_((Object[])new Item[]{FTBICItems.CANNED_FOOD.get(), FTBICItems.PROTEIN_BAR.get()});
            this.func_240522_a_(ItemTags.field_219776_M).func_240532_a_((Object)FTBICItems.NUKE_ARROW.get());
        }
    }

    private static class ICLootTableProvider
    extends ForgeLootTableProvider {
        private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> lootTables = Lists.newArrayList((Object[])new Pair[]{Pair.of(ICBlockLootTableProvider::new, (Object)LootParameterSets.field_216267_h)});

        public ICLootTableProvider(DataGenerator dataGeneratorIn) {
            super(dataGeneratorIn);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
            return this.lootTables;
        }
    }

    public static class ICBlockLootTableProvider
    extends BlockLootTables {
        private final Map<ResourceLocation, LootTable.Builder> tables = Maps.newHashMap();

        protected void addTables() {
            this.func_218492_c(FTBICBlocks.RUBBER_SHEET.get());
            this.func_218492_c(FTBICBlocks.REINFORCED_STONE.get());
            this.func_218492_c(FTBICBlocks.REINFORCED_GLASS.get());
            this.func_218492_c(FTBICBlocks.MACHINE_BLOCK.get());
            this.func_218492_c(FTBICBlocks.ADVANCED_MACHINE_BLOCK.get());
            this.func_218492_c(FTBICBlocks.IRON_FURNACE.get());
            for (Supplier<Block> cable : FTBICBlocks.CABLES) {
                this.func_218492_c(cable.get());
            }
            this.func_218492_c(FTBICBlocks.LANDMARK.get());
            this.func_218492_c(FTBICBlocks.NUCLEAR_REACTOR_CHAMBER.get());
            this.func_218492_c(FTBICBlocks.NUKE.get());
            for (ElectricBlockInstance machine : FTBICElectricBlocks.ALL) {
                if (machine.canBurn) {
                    this.func_218507_a(machine.block.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_212840_b_(new BurntBlockCondition.Builder().func_216298_a()).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)machine.item.get())))).func_216040_a(LootPool.func_216096_a().func_212840_b_((ILootCondition.IBuilder)new BurntBlockCondition.Builder()).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(machine.advanced ? (IItemProvider)FTBICItems.ADVANCED_MACHINE_BLOCK.get() : (IItemProvider)FTBICItems.MACHINE_BLOCK.get())))));
                    continue;
                }
                this.func_218492_c(machine.block.get());
            }
        }

        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            this.addTables();
            for (ResourceLocation rs : new ArrayList<ResourceLocation>(this.tables.keySet())) {
                if (rs == LootTables.field_186419_a) continue;
                LootTable.Builder builder = this.tables.remove(rs);
                if (builder == null) {
                    throw new IllegalStateException(String.format("Missing loottable '%s'", rs));
                }
                consumer.accept(rs, builder);
            }
            if (!this.tables.isEmpty()) {
                throw new IllegalStateException("Created block loot tables for non-blocks: " + this.tables.keySet());
            }
        }

        protected void func_218507_a(Block blockIn, LootTable.Builder table) {
            this.tables.put(blockIn.func_220068_i(), table);
        }
    }
}

