/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.item;

import dev.ftb.mods.ftbic.FTBIC;
import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.item.FluidCellHandler;
import java.util.List;
import java.util.Objects;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.DrinkHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class FluidCellItem
extends Item {
    private static final String TAG_FLUID = "Fluid";

    public FluidCellItem() {
        super(new Item.Properties().func_200917_a(16).func_200916_a(FTBIC.TAB));
    }

    public boolean hasContainerItem(ItemStack stack) {
        return FluidCellItem.getFluid(stack) != Fluids.field_204541_a;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        Fluid fluid = FluidCellItem.getFluid(stack);
        if (fluid != Fluids.field_204541_a) {
            return new ItemStack((IItemProvider)this);
        }
        return ItemStack.field_190927_a;
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        Fluid fluid;
        BlockState state;
        BlockRayTraceResult hit;
        ItemStack stack = player.func_184586_b(hand);
        ActionResult ret = ForgeEventFactory.onBucketUse((PlayerEntity)player, (World)level, (ItemStack)stack, (RayTraceResult)(hit = FluidCellItem.func_219968_a((World)level, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY)));
        if (ret != null) {
            return ret;
        }
        if (hit.func_216346_c() == RayTraceResult.Type.MISS) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        if (hit.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        if (FluidCellItem.getFluid(stack) != Fluids.field_204541_a) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        BlockPos pos = hit.func_216350_a();
        Direction direction = hit.func_216354_b();
        BlockPos pos1 = pos.func_177972_a(direction);
        if (level.func_175660_a(player, pos) && player.func_175151_a(pos1, direction, stack) && (state = level.func_180495_p(pos)).func_177230_c() instanceof IBucketPickupHandler && (fluid = ((IBucketPickupHandler)state.func_177230_c()).func_204508_a((IWorld)level, pos, state)) != Fluids.field_204541_a) {
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            SoundEvent soundevent = fluid.getAttributes().getFillSound();
            if (soundevent == null) {
                soundevent = fluid.func_207185_a((ITag)FluidTags.field_206960_b) ? SoundEvents.field_187633_N : SoundEvents.field_187630_M;
            }
            player.func_184185_a(soundevent, 1.0f, 1.0f);
            ItemStack itemstack1 = DrinkHelper.func_242398_a((ItemStack)stack, (PlayerEntity)player, (ItemStack)FluidCellItem.setFluid(new ItemStack((IItemProvider)this), fluid));
            if (!level.func_201670_d()) {
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)player, new ItemStack((IItemProvider)fluid.func_204524_b()));
            }
            return ActionResult.func_233538_a_((Object)itemstack1, (boolean)level.func_201670_d());
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluidCellHandler(stack);
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            list.add((Object)new ItemStack((IItemProvider)this));
            for (Fluid fluid : ForgeRegistries.FLUIDS) {
                if (fluid == Fluids.field_204541_a || !fluid.func_207193_c(fluid.func_207188_f()) || !FTBICConfig.ADD_ALL_FLUID_CELLS && fluid.getRegistryName().func_110623_a().contains("molten")) continue;
                list.add((Object)FluidCellItem.setFluid(new ItemStack((IItemProvider)this), fluid));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World level, List<ITextComponent> list, ITooltipFlag flag) {
        Fluid fluid = FluidCellItem.getFluid(stack);
        if (fluid != Fluids.field_204541_a) {
            list.add((ITextComponent)new StringTextComponent("< " + FTBICConfig.FLUID_CELL_CAPACITY + " mB of ").func_230529_a_((ITextComponent)new TranslationTextComponent(fluid.getAttributes().getTranslationKey())).func_240702_b_(" >").func_240699_a_(TextFormatting.GRAY));
        }
    }

    public static ItemStack setFluid(ItemStack stack, Fluid fluid) {
        if (fluid == Fluids.field_204541_a) {
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt != null) {
                nbt.func_82580_o(TAG_FLUID);
                if (nbt.isEmpty()) {
                    stack.func_77982_d(null);
                }
            }
        } else {
            CompoundNBT nbt = stack.func_196082_o();
            nbt.func_74778_a(TAG_FLUID, Objects.requireNonNull(fluid.getRegistryName()).toString());
        }
        return stack;
    }

    public static Fluid getFluid(ItemStack stack) {
        Fluid fluid;
        ResourceLocation location;
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && (location = ResourceLocation.func_208304_a((String)nbt.func_74779_i(TAG_FLUID))) != null && ForgeRegistries.FLUIDS.containsKey(location) && (fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(location)) != null) {
            return fluid;
        }
        return Fluids.field_204541_a;
    }

    public static String getSubtype(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null) {
            return nbt.func_74779_i(TAG_FLUID);
        }
        return "";
    }
}

