/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.item.reactor;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.entity.generator.NuclearReactorBlockEntity;
import dev.ftb.mods.ftbic.item.reactor.BaseReactorItem;
import dev.ftb.mods.ftbic.item.reactor.NeutronReflectingReactorItem;
import dev.ftb.mods.ftbic.item.reactor.NuclearReactor;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.Nullable;

public class FuelRodItem
extends BaseReactorItem
implements NeutronReflectingReactorItem {
    public final int rods;
    public final int pulses;
    public final double energyMultiplier;
    public final double heatMultiplier;

    public FuelRodItem(int durability, int r, double e, double h) {
        super(durability);
        this.rods = r;
        this.pulses = this.rods == 1 ? 1 : (this.rods == 2 ? 2 : 3);
        this.energyMultiplier = e;
        this.heatMultiplier = h;
    }

    @Override
    public void reactorInfo(ItemStack stack, List<ITextComponent> list, boolean shift, boolean advanced, @Nullable NuclearReactor reactor, int x, int y) {
        list.add((ITextComponent)new StringTextComponent(String.format("Lifespan: %,d s", stack.func_77958_k() - stack.func_77952_i())).func_240699_a_(TextFormatting.GRAY));
        int p = this.pulses;
        if (reactor != null) {
            for (int i = 0; i < 4; ++i) {
                if (!(reactor.getAt(x + NuclearReactorBlockEntity.OFFSET_X[i], y + NuclearReactorBlockEntity.OFFSET_Y[i]).func_77973_b() instanceof NeutronReflectingReactorItem)) continue;
                ++p;
            }
        }
        list.add((ITextComponent)new StringTextComponent("Energy Output: ").func_230529_a_((ITextComponent)FTBICUtils.formatEnergy((double)p * this.energyMultiplier)).func_240702_b_("/t").func_240699_a_(TextFormatting.GRAY));
        list.add((ITextComponent)new StringTextComponent("Heat Produced: ").func_230529_a_((ITextComponent)FTBICUtils.formatHeat((int)(this.heatMultiplier * (double)p * (double)(p + 1)))).func_240702_b_("/s").func_240699_a_(TextFormatting.GRAY));
    }

    @Override
    public int getRods(ItemStack stack) {
        return this.rods;
    }

    @Override
    public boolean keepSimulationRunning(ItemStack stack) {
        return true;
    }

    @Override
    public void reactorTickPre(NuclearReactor reactor, ItemStack stack, int x, int y) {
        if (reactor.paused) {
            return;
        }
        reactor.explosionRadius += (double)this.getRods(stack) * FTBICConfig.NUCLEAR_REACTOR_EXPLOSION_MULTIPLIER;
    }

    @Override
    public void reactorTickPost(NuclearReactor reactor, ItemStack stack, int x, int y) {
        if (reactor.paused) {
            return;
        }
        int p = this.pulses;
        ItemStack[] around = new ItemStack[4];
        for (int i = 0; i < 4; ++i) {
            around[i] = reactor.getAt(x + NuclearReactorBlockEntity.OFFSET_X[i], y + NuclearReactorBlockEntity.OFFSET_Y[i]);
            if (!(around[i].func_77973_b() instanceof NeutronReflectingReactorItem)) continue;
            ++p;
        }
        reactor.energyOutput += (double)p * this.energyMultiplier;
        reactor.distributeHeat(around, (int)(this.heatMultiplier * (double)p * (double)(p + 1)));
        this.damageReactorItem(stack, 1);
    }
}

