/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.ElectricBlockInstance;
import dev.ftb.mods.ftbic.recipe.MachineRecipe;
import dev.ftb.mods.ftbic.recipe.MachineRecipeSerializer;
import dev.ftb.mods.ftbic.screen.MachineScreen;
import dev.ftb.mods.ftbic.util.IngredientWithCount;
import java.util.ArrayList;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class MachineRecipeCategory
implements IRecipeCategory<MachineRecipe> {
    public final MachineRecipeSerializer serializer;
    public final String titleKey;
    public final ElectricBlockInstance electricBlockInstance;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable arrowOff;
    private final IDrawable arrowOn;
    private final IDrawable powerOff;
    private final IDrawable powerOn;
    private final IDrawable slot;
    private final IDrawable largeSlot;

    public MachineRecipeCategory(Supplier<MachineRecipeSerializer> s, IGuiHelper guiHelper, ElectricBlockInstance item) {
        this.serializer = s.get();
        this.titleKey = "recipe.ftbic." + this.serializer.getRegistryName().func_110623_a();
        this.electricBlockInstance = item;
        this.background = guiHelper.createBlankDrawable(this.serializer.guiWidth, this.serializer.guiHeight);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)item.item.get()));
        this.arrowOff = guiHelper.drawableBuilder(MachineScreen.BASE_TEXTURE, 87, 167, 24, 17).setTextureSize(256, 256).build();
        this.arrowOn = guiHelper.drawableBuilder(MachineScreen.BASE_TEXTURE, 87, 185, 24, 17).setTextureSize(256, 256).buildAnimated(MathHelper.func_76143_f((double)FTBICConfig.MACHINE_RECIPE_BASE_TICKS), IDrawableAnimated.StartDirection.LEFT, false);
        this.powerOff = guiHelper.drawableBuilder(MachineScreen.BASE_TEXTURE, 1, 240, 14, 14).setTextureSize(256, 256).build();
        this.powerOn = guiHelper.drawableBuilder(MachineScreen.BASE_TEXTURE, 16, 240, 14, 14).setTextureSize(256, 256).buildAnimated(84, IDrawableAnimated.StartDirection.TOP, true);
        this.slot = guiHelper.drawableBuilder(MachineScreen.BASE_TEXTURE, 1, 167, 18, 18).setTextureSize(256, 256).build();
        this.largeSlot = (this.serializer.outputSlots > 1 ? guiHelper.drawableBuilder(MachineScreen.BASE_TEXTURE, 1, 213, 47, 26) : guiHelper.drawableBuilder(MachineScreen.BASE_TEXTURE, 1, 186, 26, 26)).setTextureSize(256, 256).build();
    }

    public ResourceLocation getUid() {
        return this.serializer.getRegistryName();
    }

    public Class<? extends MachineRecipe> getRecipeClass() {
        return MachineRecipe.class;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)this.titleKey, (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(MachineRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.arrowOff.draw(matrixStack, this.serializer.progressX, this.serializer.progressY);
        this.arrowOn.draw(matrixStack, this.serializer.progressX, this.serializer.progressY);
        this.powerOff.draw(matrixStack, this.serializer.energyX, this.serializer.energyY);
        this.powerOn.draw(matrixStack, this.serializer.energyX, this.serializer.energyY);
        for (int i = 0; i < this.serializer.inputSlots; ++i) {
            this.slot.draw(matrixStack, i * 18, 0);
        }
        this.slot.draw(matrixStack, this.serializer.batteryX, this.serializer.batteryY);
        this.largeSlot.draw(matrixStack, this.serializer.outputX, this.serializer.outputY);
    }

    public void setIngredients(MachineRecipe recipe, IIngredients ingredients) {
        ArrayList inputItems = new ArrayList();
        for (IngredientWithCount i2 : recipe.inputItems) {
            ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
            for (ItemStack is : i2.ingredient.func_193365_a()) {
                ItemStack is1 = is.func_77946_l();
                is1.func_190920_e(i2.count);
                stackList.add(is1);
            }
            inputItems.add(stackList);
        }
        ingredients.setInputLists(VanillaTypes.ITEM, inputItems);
        ingredients.setInputs(VanillaTypes.FLUID, recipe.inputFluids);
        ingredients.setOutputs(VanillaTypes.ITEM, recipe.outputItems.stream().map(i -> i.stack).collect(Collectors.toList()));
        ingredients.setOutputs(VanillaTypes.FLUID, recipe.outputFluids);
    }

    public void setRecipe(IRecipeLayout layout, MachineRecipe recipe, IIngredients ingredients) {
        int i;
        IGuiItemStackGroup itemStacks = layout.getItemStacks();
        IGuiFluidStackGroup fluidStacks = layout.getFluidStacks();
        for (i = 0; i < recipe.inputFluids.size(); ++i) {
            fluidStacks.init(i, true, 1 + i * 18, 1);
        }
        for (i = 0; i < recipe.inputItems.size(); ++i) {
            itemStacks.init(i, true, (i + recipe.inputFluids.size()) * 18, 0);
        }
        for (i = 0; i < recipe.outputFluids.size(); ++i) {
            fluidStacks.init(i + recipe.inputFluids.size(), false, this.serializer.outputX + 5 + i * 25, this.serializer.outputY + 5);
        }
        for (i = 0; i < recipe.outputItems.size(); ++i) {
            itemStacks.init(i + recipe.inputItems.size(), false, this.serializer.outputX + 4 + (i + recipe.outputFluids.size()) * 25, this.serializer.outputY + 4);
        }
        itemStacks.set(ingredients);
        fluidStacks.set(ingredients);
        itemStacks.addTooltipCallback((idx, input, stack, tooltip) -> {
            double chance;
            if (!input && (chance = recipe.outputItems.get((int)(idx - recipe.inputItems.size())).chance) < 1.0) {
                String s = String.valueOf(chance * 100.0);
                tooltip.add(new StringTextComponent("Chance: ").func_230529_a_((ITextComponent)new StringTextComponent((s.endsWith(".0") ? s.substring(0, s.length() - 2) : s) + "%").func_240699_a_(TextFormatting.YELLOW)).func_240699_a_(TextFormatting.GRAY));
            }
        });
    }
}

