/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.recipe;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.item.FTBICItems;
import dev.ftb.mods.ftbic.recipe.FTBICRecipes;
import dev.ftb.mods.ftbic.recipe.MachineRecipe;
import dev.ftb.mods.ftbic.recipe.MachineRecipeResults;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import dev.ftb.mods.ftbic.util.IngredientWithCount;
import dev.ftb.mods.ftbic.util.ItemKeyPair;
import dev.ftb.mods.ftbic.util.MachineProcessingResult;
import dev.ftb.mods.ftbic.util.StackWithChance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class CanningMachineRecipeResults
extends MachineRecipeResults {
    private List<MachineRecipe> allRecipes;
    private Set<Item> validLeftItems;
    private Set<Item> validRightItems;

    @Override
    public int getRequiredItems() {
        return 2;
    }

    @Override
    public Object createKey(ItemStack[] inputs) {
        return new ItemKeyPair(inputs[0], inputs[1]);
    }

    @Override
    public List<MachineRecipe> getAllRecipes(World level) {
        if (this.allRecipes == null) {
            this.allRecipes = new ArrayList<MachineRecipe>(level.func_199532_z().func_241447_a_(FTBICRecipes.CANNING.get().recipeType));
            if (FTBICConfig.ADD_CANNED_FOOD_RECIPES) {
                Ingredient canIngredient = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)FTBICItems.EMPTY_CAN.item.get()});
                for (Item item : ForgeRegistries.ITEMS) {
                    int cans;
                    Food f = item.func_219967_s();
                    if (f == null || f.func_221466_a() <= 1 || !f.func_221464_f().isEmpty() || FTBICUtils.UNCANNABLE_FOOD.func_230235_a_((Object)item) || (cans = (f.func_221466_a() + (f.func_221467_c() ? 8 : 3)) / 4) <= 0) continue;
                    ResourceLocation id = item.getRegistryName();
                    MachineRecipe recipe = new MachineRecipe(FTBICRecipes.CANNING.get(), new ResourceLocation("ftbic", "canning/generated/canned_food/" + id.func_110624_b() + "/" + id.func_110623_a()));
                    recipe.inputItems.add(new IngredientWithCount(canIngredient, cans));
                    recipe.inputItems.add(new IngredientWithCount(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}), 1));
                    recipe.outputItems.add(new StackWithChance(new ItemStack((IItemProvider)FTBICItems.CANNED_FOOD.get(), cans), 1.0));
                    this.allRecipes.add(recipe);
                }
            }
        }
        return this.allRecipes;
    }

    @Override
    public MachineProcessingResult createResult(World level, ItemStack[] inputs) {
        for (MachineRecipe recipe : this.getAllRecipes(level)) {
            if (recipe.inputItems.size() != 2 || recipe.outputItems.size() < 1) continue;
            IngredientWithCount cA = recipe.inputItems.get(0);
            IngredientWithCount cB = recipe.inputItems.get(1);
            if (!cA.ingredient.test(inputs[0]) || !cB.ingredient.test(inputs[1])) continue;
            MachineProcessingResult result = new MachineProcessingResult(recipe);
            result.consume[0] = cA.count;
            result.consume[1] = cB.count;
            return result;
        }
        return MachineProcessingResult.NONE;
    }

    @Override
    public boolean canInsert(World level, int slot, ItemStack item) {
        if (slot == 0) {
            if (this.validLeftItems == null) {
                this.validLeftItems = new HashSet<Item>();
                for (MachineRecipe recipe : this.getAllRecipes(level)) {
                    if (recipe.inputItems.size() != 2 || recipe.outputItems.size() < 1) continue;
                    Arrays.stream(recipe.inputItems.get((int)0).ingredient.func_193365_a()).map(ItemStack::func_77973_b).forEach(this.validLeftItems::add);
                }
            }
            return this.validLeftItems.contains(item.func_77973_b());
        }
        if (slot == 1) {
            if (this.validRightItems == null) {
                this.validRightItems = new HashSet<Item>();
                for (MachineRecipe recipe : this.getAllRecipes(level)) {
                    if (recipe.inputItems.size() != 2 || recipe.outputItems.size() < 1) continue;
                    Arrays.stream(recipe.inputItems.get((int)1).ingredient.func_193365_a()).map(ItemStack::func_77973_b).forEach(this.validRightItems::add);
                }
            }
            return this.validRightItems.contains(item.func_77973_b());
        }
        return false;
    }
}

