/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.recipe;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.recipe.FTBICRecipes;
import dev.ftb.mods.ftbic.recipe.MachineRecipe;
import dev.ftb.mods.ftbic.recipe.MachineRecipeSerializer;
import dev.ftb.mods.ftbic.recipe.SimpleMachineRecipeResults;
import dev.ftb.mods.ftbic.util.CraftingMaterial;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import dev.ftb.mods.ftbic.util.IngredientWithCount;
import dev.ftb.mods.ftbic.util.StackWithChance;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class MaceratingRecipeResults
extends SimpleMachineRecipeResults {
    public MaceratingRecipeResults() {
        super(FTBICRecipes.MACERATING);
    }

    @Override
    protected void addAdditionalRecipes(World level, List<MachineRecipe> list) {
        for (CraftingMaterial m : FTBICConfig.MATERIALS.values()) {
            MachineRecipe recipe;
            ResourceLocation id;
            Item dust = FTBICConfig.getItemFromTag(m.dust);
            boolean gemFromOre = false;
            if (FTBICConfig.ADD_GEM_FROM_ORE_RECIPES && !m.gem.func_230236_b_().isEmpty() && !m.ore.func_230236_b_().isEmpty()) {
                ResourceLocation id2;
                Item gem = FTBICConfig.getItemFromTag(m.gem);
                ResourceLocation resourceLocation = id2 = gem == Items.field_190931_a ? null : gem.getRegistryName();
                if (id2 != null && !FTBICUtils.NO_AUTO_RECIPE.func_230235_a_((Object)gem)) {
                    MachineRecipe recipe2 = new MachineRecipe((MachineRecipeSerializer)((Object)this.recipeSerializer.get()), new ResourceLocation("ftbic", "macerating/generated/gem_from_ore/" + id2.func_110624_b() + "/" + id2.func_110623_a()));
                    recipe2.inputItems.add(new IngredientWithCount(Ingredient.func_199805_a(m.ore), 1));
                    recipe2.outputItems.add(new StackWithChance(new ItemStack((IItemProvider)gem, 2), 1.0));
                    list.add(recipe2);
                    gemFromOre = true;
                }
            }
            if (!gemFromOre && FTBICConfig.ADD_DUST_FROM_ORE_RECIPES && dust != Items.field_190931_a && !m.ore.func_230236_b_().isEmpty() && (id = dust.getRegistryName()) != null && !FTBICUtils.NO_AUTO_RECIPE.func_230235_a_((Object)dust)) {
                recipe = new MachineRecipe((MachineRecipeSerializer)((Object)this.recipeSerializer.get()), new ResourceLocation("ftbic", "macerating/generated/dust_from_ore/" + id.func_110624_b() + "/" + id.func_110623_a()));
                recipe.inputItems.add(new IngredientWithCount(Ingredient.func_199805_a(m.ore), 1));
                recipe.outputItems.add(new StackWithChance(new ItemStack((IItemProvider)dust, 2), 1.0));
                list.add(recipe);
            }
            if (!FTBICConfig.ADD_DUST_FROM_MATERIAL_RECIPES || dust == Items.field_190931_a || (id = dust.getRegistryName()) == null || FTBICUtils.NO_AUTO_RECIPE.func_230235_a_((Object)dust)) continue;
            if (!m.ingot.func_230236_b_().isEmpty()) {
                recipe = new MachineRecipe((MachineRecipeSerializer)((Object)this.recipeSerializer.get()), new ResourceLocation("ftbic", "macerating/generated/dust_from_metal/" + id.func_110624_b() + "/" + id.func_110623_a()));
                recipe.inputItems.add(new IngredientWithCount(Ingredient.func_199805_a(m.ingot), 1));
                recipe.outputItems.add(new StackWithChance(new ItemStack((IItemProvider)dust, 1), 1.0));
                list.add(recipe);
            }
            if (m.gem.func_230236_b_().isEmpty()) continue;
            recipe = new MachineRecipe((MachineRecipeSerializer)((Object)this.recipeSerializer.get()), new ResourceLocation("ftbic", "macerating/generated/dust_from_gem/" + id.func_110624_b() + "/" + id.func_110623_a()));
            recipe.inputItems.add(new IngredientWithCount(Ingredient.func_199805_a(m.gem), 1));
            recipe.outputItems.add(new StackWithChance(new ItemStack((IItemProvider)dust, 1), 1.0));
            list.add(recipe);
        }
    }
}

