/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.recipe;

import dev.ftb.mods.ftbic.recipe.AntimatterBoostRecipe;
import dev.ftb.mods.ftbic.recipe.BasicGeneratorFuelRecipe;
import dev.ftb.mods.ftbic.recipe.CanningMachineRecipeResults;
import dev.ftb.mods.ftbic.recipe.CompressingRecipeResults;
import dev.ftb.mods.ftbic.recipe.CookingRecipeResults;
import dev.ftb.mods.ftbic.recipe.ExtrudingRecipeResults;
import dev.ftb.mods.ftbic.recipe.FTBICRecipes;
import dev.ftb.mods.ftbic.recipe.MaceratingRecipeResults;
import dev.ftb.mods.ftbic.recipe.NoContainer;
import dev.ftb.mods.ftbic.recipe.ReprocessingRecipeResults;
import dev.ftb.mods.ftbic.recipe.RollingRecipeResults;
import dev.ftb.mods.ftbic.recipe.SeparatingRecipeResults;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class RecipeCache
implements IRecipe<NoContainer> {
    public static final ResourceLocation ID = new ResourceLocation("ftbic", "recipe_cache");
    private final Map<Item, Integer> basicGeneratorFuel = new HashMap<Item, Integer>();
    private final Map<Item, Double> antimatterBoost = new HashMap<Item, Double>();
    public final CookingRecipeResults smelting = new CookingRecipeResults(FTBICRecipes.SMELTING, "smelting", (IRecipeType<? extends AbstractCookingRecipe>)IRecipeType.field_222150_b);
    public final MaceratingRecipeResults macerating = new MaceratingRecipeResults();
    public final SeparatingRecipeResults separating = new SeparatingRecipeResults();
    public final CompressingRecipeResults compressing = new CompressingRecipeResults();
    public final RollingRecipeResults rolling = new RollingRecipeResults();
    public final ExtrudingRecipeResults extruding = new ExtrudingRecipeResults();
    public final ReprocessingRecipeResults reprocessing = new ReprocessingRecipeResults();
    public final CanningMachineRecipeResults canning = new CanningMachineRecipeResults();

    @Nullable
    public static RecipeCache get(World level) {
        IRecipe r = level.func_199532_z().func_215367_a(ID).orElse(null);
        return r instanceof RecipeCache ? (RecipeCache)r : null;
    }

    public boolean matches(NoContainer container, World level) {
        return false;
    }

    public ItemStack assemble(NoContainer container) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ResourceLocation func_199560_c() {
        return ID;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return FTBICRecipes.RECIPE_CACHE.get();
    }

    public IRecipeType<?> func_222127_g() {
        return FTBICRecipes.RECIPE_CACHE_TYPE;
    }

    public int getBasicGeneratorFuelTicks(World level, ItemStack item) {
        Integer fuel = this.basicGeneratorFuel.get(item.func_77973_b());
        if (fuel != null) {
            return fuel;
        }
        for (BasicGeneratorFuelRecipe recipe : level.func_199532_z().func_241447_a_(FTBICRecipes.BASIC_GENERATOR_FUEL_TYPE)) {
            if (!recipe.ingredient.test(item)) continue;
            this.basicGeneratorFuel.put(item.func_77973_b(), recipe.ticks);
            return recipe.ticks;
        }
        this.basicGeneratorFuel.put(item.func_77973_b(), 0);
        return 0;
    }

    public double getAntimatterBoost(World level, ItemStack item) {
        Double boost = this.antimatterBoost.get(item.func_77973_b());
        if (boost != null) {
            return boost;
        }
        for (AntimatterBoostRecipe recipe : level.func_199532_z().func_241447_a_(FTBICRecipes.ANTIMATTER_BOOST_TYPE)) {
            if (!recipe.ingredient.test(item)) continue;
            this.antimatterBoost.put(item.func_77973_b(), recipe.boost);
            return recipe.boost;
        }
        this.antimatterBoost.put(item.func_77973_b(), 0.0);
        return 0.0;
    }
}

