/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.recipe;

import dev.ftb.mods.ftbic.recipe.MachineRecipe;
import dev.ftb.mods.ftbic.recipe.MachineRecipeResults;
import dev.ftb.mods.ftbic.recipe.MachineRecipeSerializer;
import dev.ftb.mods.ftbic.util.IngredientWithCount;
import dev.ftb.mods.ftbic.util.MachineProcessingResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class SimpleMachineRecipeResults
extends MachineRecipeResults {
    public final Supplier<MachineRecipeSerializer> recipeSerializer;
    private List<MachineRecipe> allRecipes;
    private Set<Item> validItems;

    public SimpleMachineRecipeResults(Supplier<MachineRecipeSerializer> s) {
        this.recipeSerializer = s;
    }

    @Override
    public List<MachineRecipe> getAllRecipes(World level) {
        if (this.allRecipes == null) {
            this.allRecipes = new ArrayList<MachineRecipe>(level.func_199532_z().func_241447_a_(this.recipeSerializer.get().recipeType));
            this.addAdditionalRecipes(level, this.allRecipes);
            this.allRecipes.removeIf(r -> r.inputItems.size() != 1 || r.outputItems.size() < 1);
        }
        return this.allRecipes;
    }

    protected void addAdditionalRecipes(World level, List<MachineRecipe> list) {
    }

    @Override
    public MachineProcessingResult createResult(World level, ItemStack[] inputs) {
        for (MachineRecipe recipe : this.getAllRecipes(level)) {
            if (recipe.inputItems.size() != 1 || recipe.outputItems.size() < 1) continue;
            IngredientWithCount c = recipe.inputItems.get(0);
            if (!c.ingredient.test(inputs[0])) continue;
            MachineProcessingResult result = new MachineProcessingResult(recipe);
            result.consume[0] = c.count;
            return result;
        }
        return MachineProcessingResult.NONE;
    }

    @Override
    public boolean canInsert(World level, int slot, ItemStack item) {
        if (slot == 0) {
            if (this.validItems == null) {
                this.validItems = new HashSet<Item>();
                for (MachineRecipe recipe : this.getAllRecipes(level)) {
                    if (recipe.inputItems.size() != 1 || recipe.outputItems.size() < 1) continue;
                    Arrays.stream(recipe.inputItems.get((int)0).ingredient.func_193365_a()).map(ItemStack::func_77973_b).forEach(this.validItems::add);
                }
            }
            return this.validItems.contains(item.func_77973_b());
        }
        return false;
    }
}

