/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.entity.machine.MachineBlockEntity;
import dev.ftb.mods.ftbic.item.FTBICItems;
import dev.ftb.mods.ftbic.screen.ElectricBlockMenu;
import dev.ftb.mods.ftbic.screen.sync.SyncedData;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import java.util.Collections;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;

public class ElectricBlockScreen<T extends ElectricBlockMenu<?>>
extends ContainerScreen<T> {
    public static final ResourceLocation BASE_TEXTURE = new ResourceLocation("ftbic", "textures/gui/base.png");
    public int energyX = -1;
    public int energyY = -1;

    public ElectricBlockScreen(T m, PlayerInventory inv, ITextComponent c) {
        super(m, inv, c);
    }

    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float delta) {
        this.func_230446_a_(poseStack);
        super.func_230430_a_(poseStack, mouseX, mouseY, delta);
        this.renderExtra(poseStack, mouseX, mouseY, delta);
        this.func_230459_a_(poseStack, mouseX, mouseY);
    }

    protected void renderExtra(MatrixStack poseStack, int mouseX, int mouseY, float delta) {
    }

    public static boolean isIn(int mx, int my, int x, int y, int w, int h) {
        return mx >= x && mx < x + w && my >= y && my < y + h;
    }

    protected void func_230459_a_(MatrixStack poseStack, int mouseX, int mouseY) {
        super.func_230459_a_(poseStack, mouseX, mouseY);
        if (this.energyX != -1 && this.energyY != -1 && ElectricBlockScreen.isIn(mouseX, mouseY, this.field_147003_i + this.energyX, this.field_147009_r + this.energyY, 14, 14) && ((ElectricBlockMenu)this.field_147002_h).player.field_71071_by.func_70445_o().func_190926_b()) {
            double capacity = ((ElectricBlockMenu)this.field_147002_h).data.get(SyncedData.ENERGY_CAPACITY);
            if (((ElectricBlockMenu)this.field_147002_h).entity instanceof MachineBlockEntity) {
                capacity += (double)((MachineBlockEntity)((ElectricBlockMenu)this.field_147002_h).entity).upgradeInventory.countUpgrades(FTBICItems.ENERGY_STORAGE_UPGRADE.get()) * FTBICConfig.STORAGE_UPGRADE;
            }
            double energy = ((ElectricBlockMenu)this.field_147002_h).data.get(SyncedData.ENERGY);
            this.renderWrappedToolTip(poseStack, Collections.singletonList(new StringTextComponent("").func_230529_a_((ITextComponent)FTBICUtils.formatEnergy(energy).func_240699_a_(TextFormatting.GRAY)).func_240702_b_(" / ").func_230529_a_((ITextComponent)FTBICUtils.formatEnergy(capacity).func_240699_a_(TextFormatting.GRAY)).func_240699_a_(TextFormatting.DARK_GRAY)), mouseX, mouseY, this.field_230712_o_);
        }
    }

    public void drawArrow(MatrixStack poseStack, int x, int y, int progress) {
        if (progress < 24) {
            this.func_238474_b_(poseStack, x + progress, y, 87 + progress, 167, 24 - progress, 17);
        }
        if (progress > 0) {
            this.func_238474_b_(poseStack, x, y, 87, 185, progress, 17);
        }
    }

    public int getEnergyType() {
        return 0;
    }

    public void drawEnergy(MatrixStack poseStack, int x, int y, int energy) {
        switch (this.getEnergyType()) {
            case 1: {
                if (energy < 14) {
                    this.func_238474_b_(poseStack, x + energy, y, 91 + energy, 240, 14 - energy, 14);
                }
                if (energy <= 0) break;
                this.func_238474_b_(poseStack, x, y, 106, 240, energy, 14);
                break;
            }
            case 2: {
                if (energy < 14) {
                    this.func_238474_b_(poseStack, x + energy, y, 121 + energy, 240, 14 - energy, 14);
                }
                if (energy <= 0) break;
                this.func_238474_b_(poseStack, x, y, 136, 240, energy, 14);
                break;
            }
            default: {
                if (energy < 14) {
                    this.func_238474_b_(poseStack, x, y, 1, 240, 14, 14 - energy);
                }
                if (energy <= 0) break;
                this.func_238474_b_(poseStack, x, y + (14 - energy), 16, 240 + (14 - energy), 14, energy);
            }
        }
    }

    public void drawFuel(MatrixStack poseStack, int x, int y, int fuel) {
        if (fuel < 14) {
            this.func_238474_b_(poseStack, x, y, 31, 240, 14, 14 - fuel);
        }
        if (fuel > 0) {
            this.func_238474_b_(poseStack, x, y + (14 - fuel), 46, 240 + (14 - fuel), 14, fuel);
        }
    }

    public void drawSun(MatrixStack poseStack, int x, int y, int fuel) {
        if (fuel < 14) {
            this.func_238474_b_(poseStack, x, y, 61, 240, 14, 14 - fuel);
        }
        if (fuel > 0) {
            this.func_238474_b_(poseStack, x, y + (14 - fuel), 76, 240 + (14 - fuel), 14, fuel);
        }
    }

    public void drawSlot(MatrixStack poseStack, int x, int y) {
        this.func_238474_b_(poseStack, x, y, 1, 167, 18, 18);
    }

    public void drawLockedSlot(MatrixStack poseStack, int x, int y) {
        this.func_238474_b_(poseStack, x, y, 20, 167, 18, 18);
    }

    public void drawLargeSlot(MatrixStack poseStack, int x, int y) {
        this.func_238474_b_(poseStack, x, y, 1, 186, 26, 26);
    }

    public void drawCombinedSlot(MatrixStack poseStack, int x, int y) {
        this.func_238474_b_(poseStack, x, y, 1, 213, 47, 26);
    }

    public void drawTank(MatrixStack poseStack, int x, int y, FluidStack fluid, int capacity) {
        this.func_238474_b_(poseStack, x, y, 49, 167, 18, 54);
        this.field_230706_i_.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        double d = (double)fluid.getAmount() / (double)capacity;
        int h = MathHelper.func_76143_f((double)(d * 52.0));
        if (h > 0) {
            this.func_238468_a_(poseStack, x + 1, y + 1 + (52 - h), x + 17, y + 53, -18944, -2601915);
        }
        this.field_230706_i_.func_110434_K().func_110577_a(BASE_TEXTURE);
        this.func_238474_b_(poseStack, x, y, 68, 167, 18, 54);
    }

    public void drawFluidSlot(MatrixStack poseStack, int x, int y, FluidStack fluid) {
        this.drawSlot(poseStack, x, y);
        if (!fluid.isEmpty()) {
            this.field_230706_i_.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            TextureAtlasSprite sprite = (TextureAtlasSprite)this.field_230706_i_.func_228015_a_(AtlasTexture.field_110575_b).apply(fluid.getFluid().getAttributes().getStillTexture(fluid));
            int color = fluid.getFluid().getAttributes().getColor(fluid);
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color >> 0 & 0xFF;
            float u0 = sprite.func_94209_e();
            float v0 = sprite.func_94206_g();
            float u1 = sprite.func_94212_f();
            float v1 = sprite.func_94210_h();
            Matrix4f m = poseStack.func_227866_c_().func_227870_a_();
            BufferBuilder lv = Tessellator.func_178181_a().func_178180_c();
            lv.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
            lv.func_227888_a_(m, (float)x + 1.0f, (float)y + 1.0f, 0.0f).func_225586_a_(r, g, b, 255).func_225583_a_(u0, v0).func_181675_d();
            lv.func_227888_a_(m, (float)x + 1.0f, (float)y + 17.0f, 0.0f).func_225586_a_(r, g, b, 255).func_225583_a_(u0, v1).func_181675_d();
            lv.func_227888_a_(m, (float)x + 17.0f, (float)y + 17.0f, 0.0f).func_225586_a_(r, g, b, 255).func_225583_a_(u1, v1).func_181675_d();
            lv.func_227888_a_(m, (float)x + 17.0f, (float)y + 1.0f, 0.0f).func_225586_a_(r, g, b, 255).func_225583_a_(u1, v0).func_181675_d();
            lv.func_178977_d();
            RenderSystem.enableAlphaTest();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)lv);
            this.field_230706_i_.func_110434_K().func_110577_a(BASE_TEXTURE);
        }
    }

    public void drawProgressBar(MatrixStack poseStack, int x, int y, int progress) {
        if (progress < 26) {
            this.func_238474_b_(poseStack, x + progress, y, 87 + progress, 203, 26 - progress, 3);
        }
        if (progress > 0) {
            this.func_238474_b_(poseStack, x, y, 87, 207, progress, 3);
        }
    }

    public void drawArrowDown(MatrixStack poseStack, int x, int y) {
        this.func_238474_b_(poseStack, x, y, 112, 186, 14, 14);
    }

    public void drawButtonPause(MatrixStack poseStack, int x, int y) {
        this.func_238474_b_(poseStack, x, y, 112, 167, 18, 18);
    }

    public void drawButtonStart(MatrixStack poseStack, int x, int y) {
        this.func_238474_b_(poseStack, x, y, 131, 167, 18, 18);
    }

    public void drawButtonFrame(MatrixStack poseStack, int x, int y) {
        this.func_238474_b_(poseStack, x, y, 150, 167, 18, 18);
    }

    public void drawPauseButton(MatrixStack poseStack, int x, int y, int mouseX, int mouseY, boolean paused) {
        if (paused) {
            this.drawButtonStart(poseStack, x, y);
        } else {
            this.drawButtonPause(poseStack, x, y);
        }
        if (ElectricBlockScreen.isIn(mouseX, mouseY, x, y, 18, 18)) {
            this.drawButtonFrame(poseStack, x, y);
        }
    }

    public void drawSmallButtonPause(MatrixStack poseStack, int x, int y) {
        this.func_238474_b_(poseStack, x, y, 114, 201, 9, 10);
    }

    public void drawSmallButtonStart(MatrixStack poseStack, int x, int y) {
        this.func_238474_b_(poseStack, x, y, 124, 201, 9, 10);
    }

    public void drawSmallButtonFrame(MatrixStack poseStack, int x, int y) {
        this.func_238474_b_(poseStack, x, y, 134, 201, 9, 10);
    }

    public void drawSmallButtonQuestion(MatrixStack poseStack, int x, int y) {
        this.func_238474_b_(poseStack, x, y, 144, 201, 9, 10);
    }

    public void drawSmallPauseButton(MatrixStack poseStack, int x, int y, int mouseX, int mouseY, boolean paused) {
        if (paused) {
            this.drawSmallButtonStart(poseStack, x, y);
        } else {
            this.drawSmallButtonPause(poseStack, x, y);
        }
        if (ElectricBlockScreen.isIn(mouseX, mouseY, x, y, 9, 10)) {
            this.drawSmallButtonFrame(poseStack, x, y);
        }
    }

    public void drawSmallQuestionButton(MatrixStack poseStack, int x, int y, int mouseX, int mouseY) {
        this.drawSmallButtonQuestion(poseStack, x, y);
        if (ElectricBlockScreen.isIn(mouseX, mouseY, x, y, 9, 10)) {
            this.drawSmallButtonFrame(poseStack, x, y);
        }
    }

    public void drawNuclearBar(MatrixStack poseStack, int x, int y, boolean active) {
        this.func_238474_b_(poseStack, x, y, 87, 218, 54, 10);
        if (active) {
            this.func_238474_b_(poseStack, x, y, 87, 229, 54, 10);
        }
    }

    public void drawHeatBar(MatrixStack poseStack, int x, int y, float heat) {
        this.func_238474_b_(poseStack, x, y, 142, 218, 54, 10);
        if (heat > 0.0f) {
            this.func_238474_b_(poseStack, x + 1, y, 143, 229, MathHelper.func_76123_f((float)(heat * 52.0f)), 10);
        }
    }

    public ResourceLocation getScreenTexture() {
        return BASE_TEXTURE;
    }

    protected void func_230450_a_(MatrixStack poseStack, float delta, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        this.field_230706_i_.func_110434_K().func_110577_a(this.getScreenTexture());
        int x = this.field_147003_i;
        int y = this.field_147009_r;
        this.func_238474_b_(poseStack, x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        this.field_230706_i_.func_110434_K().func_110577_a(BASE_TEXTURE);
        if (this.energyX != -1 && this.energyY != -1) {
            int e = MathHelper.func_76143_f((double)(((ElectricBlockMenu)this.field_147002_h).data.get(SyncedData.ENERGY) * 14.0 / ((ElectricBlockMenu)this.field_147002_h).data.get(SyncedData.ENERGY_CAPACITY)));
            this.drawEnergy(poseStack, this.field_147003_i + this.energyX, this.field_147009_r + this.energyY, e);
        }
    }
}

