/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.ftb.mods.ftbic.block.entity.generator.NuclearReactorBlockEntity;
import dev.ftb.mods.ftbic.item.reactor.NuclearReactor;
import dev.ftb.mods.ftbic.item.reactor.ReactorItem;
import dev.ftb.mods.ftbic.screen.ElectricBlockScreen;
import dev.ftb.mods.ftbic.screen.NuclearReactorInfoScreen;
import dev.ftb.mods.ftbic.screen.NuclearReactorMenu;
import dev.ftb.mods.ftbic.screen.sync.SyncedData;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CEnchantItemPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class NuclearReactorScreen
extends ElectricBlockScreen<NuclearReactorMenu> {
    public static final ResourceLocation NUCLEAR_REACTOR_TEXTURE = new ResourceLocation("ftbic", "textures/gui/nuclear_reactor.png");

    public NuclearReactorScreen(NuclearReactorMenu m, PlayerInventory inv, ITextComponent c) {
        super(m, inv, c);
        this.field_147000_g = 222;
        this.field_238745_s_ = this.field_147000_g - 94;
    }

    @Override
    public ResourceLocation getScreenTexture() {
        return NUCLEAR_REACTOR_TEXTURE;
    }

    @Override
    protected void func_230450_a_(MatrixStack poseStack, float delta, int mouseX, int mouseY) {
        super.func_230450_a_(poseStack, delta, mouseX, mouseY);
        this.drawNuclearBar(poseStack, this.field_147003_i + 115, this.field_147009_r + 5, ((NuclearReactorMenu)this.field_147002_h).data.get(SyncedData.PAUSED) == false && ((NuclearReactorMenu)this.field_147002_h).data.get(NuclearReactorBlockEntity.ENERGY_OUTPUT) > 0.0);
        this.drawHeatBar(poseStack, this.field_147003_i + 115, this.field_147009_r + 127, MathHelper.func_76131_a((float)((float)((NuclearReactorMenu)this.field_147002_h).data.get(NuclearReactorBlockEntity.HEAT).intValue() / (float)((NuclearReactorMenu)this.field_147002_h).data.get(NuclearReactorBlockEntity.MAX_HEAT).intValue()), (float)0.0f, (float)1.0f));
        this.drawSmallPauseButton(poseStack, this.field_147003_i + 105, this.field_147009_r + 5, mouseX, mouseY, ((NuclearReactorMenu)this.field_147002_h).data.get(SyncedData.PAUSED));
        this.drawSmallQuestionButton(poseStack, this.field_147003_i + 94, this.field_147009_r + 5, mouseX, mouseY);
    }

    protected void func_230451_b_(MatrixStack poseStack, int mouseX, int mouseY) {
        super.func_230451_b_(poseStack, mouseX, mouseY);
        NuclearReactorScreen.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)(((NuclearReactorMenu)this.field_147002_h).data.get(SyncedData.PAUSED) != false ? new StringTextComponent("Paused") : FTBICUtils.formatEnergy(((NuclearReactorMenu)this.field_147002_h).data.get(NuclearReactorBlockEntity.ENERGY_OUTPUT))), (int)142, (int)6, (int)0xFFFFFF);
        NuclearReactorScreen.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)FTBICUtils.formatHeat(((NuclearReactorMenu)this.field_147002_h).data.get(NuclearReactorBlockEntity.HEAT)), (int)142, (int)128, (int)0xFFFFFF);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (NuclearReactorScreen.isIn((int)mouseX, (int)mouseY, this.field_147003_i + 105, this.field_147009_r + 5, 9, 10)) {
            this.field_230706_i_.field_71439_g.field_71174_a.func_147297_a((IPacket)new CEnchantItemPacket(((NuclearReactorMenu)this.field_147002_h).field_75152_c, 0));
            return true;
        }
        if (NuclearReactorScreen.isIn((int)mouseX, (int)mouseY, this.field_147003_i + 94, this.field_147009_r + 5, 9, 10)) {
            double totalEnergyOutput;
            double maxEnergyOutput;
            int runTime;
            NuclearReactor reactor;
            ArrayList<ITextComponent> info;
            block8: {
                info = new ArrayList<ITextComponent>();
                reactor = new NuclearReactor(new ItemStack[((NuclearReactorBlockEntity)((NuclearReactorMenu)this.field_147002_h).entity).reactor.inputItems.length]);
                reactor.paused = false;
                reactor.simulation = true;
                reactor.heat = ((NuclearReactorMenu)this.field_147002_h).data.get(NuclearReactorBlockEntity.HEAT);
                for (int i = 0; i < 54; ++i) {
                    reactor.inputItems[i] = ((NuclearReactorBlockEntity)((NuclearReactorMenu)this.field_147002_h).entity).reactor.inputItems[i].func_77973_b() instanceof ReactorItem ? ((NuclearReactorBlockEntity)((NuclearReactorMenu)this.field_147002_h).entity).reactor.inputItems[i].func_77946_l() : ItemStack.field_190927_a;
                }
                runTime = 0;
                maxEnergyOutput = 0.0;
                totalEnergyOutput = 0.0;
                do {
                    boolean stop = reactor.tick();
                    ++runTime;
                    maxEnergyOutput = Math.max(maxEnergyOutput, reactor.energyOutput);
                    totalEnergyOutput += reactor.energyOutput;
                    if (stop) break block8;
                } while (runTime < 10000000);
                info.add((ITextComponent)new StringTextComponent("Simulation ran for too long!").func_240699_a_(TextFormatting.RED));
            }
            if (maxEnergyOutput <= 0.0) {
                info.add((ITextComponent)new StringTextComponent("Insert Fuel Rods to check run time!"));
            } else {
                info.add((ITextComponent)new StringTextComponent(String.format("This reactor will run for %,d s", runTime)));
                if (reactor.heat >= reactor.maxHeat) {
                    info.add((ITextComponent)new StringTextComponent("This reactor will explode with " + MathHelper.func_76143_f((double)reactor.explosionRadius) + " block radius").func_240699_a_(TextFormatting.RED));
                } else {
                    info.add((ITextComponent)new StringTextComponent("This reactor will not explode").func_240699_a_(TextFormatting.GREEN));
                }
                info.add((ITextComponent)new StringTextComponent("Max energy generated: ").func_230529_a_((ITextComponent)FTBICUtils.formatEnergy(maxEnergyOutput)).func_240702_b_("/t"));
                info.add((ITextComponent)new StringTextComponent("Total energy generated: ").func_230529_a_((ITextComponent)FTBICUtils.formatEnergy(totalEnergyOutput)));
            }
            this.field_230706_i_.func_147108_a((Screen)new NuclearReactorInfoScreen(this, info));
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }
}

