/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.util;

import net.minecraft.util.Direction;

public interface EnergyHandler {
    default public boolean isEnergyHandlerInvalid() {
        return false;
    }

    default public double getMaxInputEnergy() {
        return 0.0;
    }

    public double getEnergyCapacity();

    public double getEnergy();

    default public void setEnergy(double energy) {
        double prev = this.getEnergy();
        if (prev != energy) {
            this.setEnergyRaw(energy);
            this.energyChanged(prev);
        }
    }

    public void setEnergyRaw(double var1);

    default public double insertEnergy(double maxInsert, boolean simulate) {
        if (this.isBurnt()) {
            return 0.0;
        }
        double max = this.getMaxInputEnergy();
        if (max <= 0.0) {
            return 0.0;
        }
        if (maxInsert > max && this.canBurn()) {
            if (!simulate) {
                this.setBurnt(true);
            }
            return maxInsert;
        }
        double energy = this.getEnergy();
        double energyReceived = Math.min(this.getEnergyCapacity() - energy, Math.min(max, maxInsert));
        if (!simulate && energyReceived > 0.0) {
            this.setEnergyRaw(energy + energyReceived);
            this.energyChanged(energy);
        }
        return energyReceived;
    }

    default public void energyChanged(double prevEnergy) {
    }

    default public boolean canBurn() {
        return false;
    }

    default public void setBurnt(boolean burnt) {
    }

    default public boolean isBurnt() {
        return false;
    }

    default public boolean isValidEnergyInputSide(Direction direction) {
        return true;
    }
}

