/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.crafting.CraftingHelper;

public class StackWithChance {
    public static final StackWithChance EMPTY = new StackWithChance(ItemStack.field_190927_a, 0.0);
    public final ItemStack stack;
    public final double chance;

    public StackWithChance(ItemStack s, double c) {
        this.stack = s;
        this.chance = c;
    }

    public StackWithChance(JsonElement element) {
        JsonObject json = element.getAsJsonObject();
        this.stack = CraftingHelper.getItemStack((JsonObject)json, (boolean)true);
        this.chance = json.has("chance") ? json.get("chance").getAsDouble() : 1.0;
    }

    public StackWithChance(PacketBuffer buf) {
        this.stack = buf.func_150791_c();
        this.chance = buf.readDouble();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("item", this.stack.func_77973_b().getRegistryName().toString());
        if (this.stack.func_190916_E() > 1) {
            json.addProperty("count", (Number)this.stack.func_190916_E());
        }
        if (this.stack.func_77942_o()) {
            CompoundNBT tag = this.stack.func_77978_p().func_74737_b();
            tag.func_82580_o("Damage");
            if (!tag.isEmpty()) {
                json.addProperty("nbt", tag.toString());
            }
        }
        if (this.chance != 1.0) {
            json.addProperty("chance", (Number)this.chance);
        }
        return json;
    }

    public void write(PacketBuffer buf) {
        buf.func_150788_a(this.stack);
        buf.writeDouble(this.chance);
    }
}

