/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.VillagerRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import openblocks.Config;
import openblocks.IOpenBlocksProxy;
import openblocks.OpenBlocks;
import openblocks.client.ClientTickHandler;
import openblocks.client.GliderPlayerRenderHandler;
import openblocks.client.SleepingBagRenderHandler;
import openblocks.client.SoundEventsManager;
import openblocks.client.bindings.KeyInputHandler;
import openblocks.client.fx.FXLiquidSpray;
import openblocks.client.model.ModelCraneBackpack;
import openblocks.client.renderer.block.BlockCanvasRenderer;
import openblocks.client.renderer.block.BlockGuideRenderer;
import openblocks.client.renderer.block.BlockPaintCanRenderer;
import openblocks.client.renderer.block.BlockPathRenderer;
import openblocks.client.renderer.block.BlockRopeLadderRenderer;
import openblocks.client.renderer.block.BlockSkyRenderer;
import openblocks.client.renderer.block.BlockTankRenderer;
import openblocks.client.renderer.entity.EntityCartographerRenderer;
import openblocks.client.renderer.entity.EntityGoldenEyeRenderer;
import openblocks.client.renderer.entity.EntityHangGliderRenderer;
import openblocks.client.renderer.entity.EntityLuggageRenderer;
import openblocks.client.renderer.entity.EntityMagnetRenderer;
import openblocks.client.renderer.entity.EntityMiniMeRenderer;
import openblocks.client.renderer.entity.EntitySelectionHandler;
import openblocks.client.renderer.item.ItemRendererDevNull;
import openblocks.client.renderer.item.ItemRendererHangGlider;
import openblocks.client.renderer.item.ItemRendererLuggage;
import openblocks.client.renderer.item.ItemRendererPaintCan;
import openblocks.client.renderer.item.ItemRendererTank;
import openblocks.client.renderer.item.ItemRendererTrophy;
import openblocks.client.renderer.tileentity.TileEntityAutoAnvilRenderer;
import openblocks.client.renderer.tileentity.TileEntityAutoEnchantmentTableRenderer;
import openblocks.client.renderer.tileentity.TileEntityBearTrapRenderer;
import openblocks.client.renderer.tileentity.TileEntityBuilderGuideRenderer;
import openblocks.client.renderer.tileentity.TileEntityCannonRenderer;
import openblocks.client.renderer.tileentity.TileEntityDonationStationRenderer;
import openblocks.client.renderer.tileentity.TileEntityFanRenderer;
import openblocks.client.renderer.tileentity.TileEntityFlagRenderer;
import openblocks.client.renderer.tileentity.TileEntityGoldenEggRenderer;
import openblocks.client.renderer.tileentity.TileEntityGraveRenderer;
import openblocks.client.renderer.tileentity.TileEntityGuideRenderer;
import openblocks.client.renderer.tileentity.TileEntityImaginaryRenderer;
import openblocks.client.renderer.tileentity.TileEntityPaintMixerRenderer;
import openblocks.client.renderer.tileentity.TileEntityProjectorRenderer;
import openblocks.client.renderer.tileentity.TileEntitySkyRenderer;
import openblocks.client.renderer.tileentity.TileEntitySprinklerRenderer;
import openblocks.client.renderer.tileentity.TileEntityTankRenderer;
import openblocks.client.renderer.tileentity.TileEntityTargetRenderer;
import openblocks.client.renderer.tileentity.TileEntityTrophyRenderer;
import openblocks.client.renderer.tileentity.TileEntityVacuumHopperRenderer;
import openblocks.client.renderer.tileentity.TileEntityVillageHighlighterRenderer;
import openblocks.client.renderer.tileentity.TileEntityXPShowerRenderer;
import openblocks.common.entity.EntityCartographer;
import openblocks.common.entity.EntityGoldenEye;
import openblocks.common.entity.EntityHangGlider;
import openblocks.common.entity.EntityLuggage;
import openblocks.common.entity.EntityMagnet;
import openblocks.common.entity.EntityMiniMe;
import openblocks.common.tileentity.TileEntityAutoAnvil;
import openblocks.common.tileentity.TileEntityAutoEnchantmentTable;
import openblocks.common.tileentity.TileEntityBearTrap;
import openblocks.common.tileentity.TileEntityBuilderGuide;
import openblocks.common.tileentity.TileEntityCannon;
import openblocks.common.tileentity.TileEntityDonationStation;
import openblocks.common.tileentity.TileEntityFan;
import openblocks.common.tileentity.TileEntityFlag;
import openblocks.common.tileentity.TileEntityGoldenEgg;
import openblocks.common.tileentity.TileEntityGrave;
import openblocks.common.tileentity.TileEntityGuide;
import openblocks.common.tileentity.TileEntityImaginary;
import openblocks.common.tileentity.TileEntityPaintMixer;
import openblocks.common.tileentity.TileEntityProjector;
import openblocks.common.tileentity.TileEntitySky;
import openblocks.common.tileentity.TileEntitySprinkler;
import openblocks.common.tileentity.TileEntityTank;
import openblocks.common.tileentity.TileEntityTarget;
import openblocks.common.tileentity.TileEntityTrophy;
import openblocks.common.tileentity.TileEntityVacuumHopper;
import openblocks.common.tileentity.TileEntityVillageHighlighter;
import openblocks.common.tileentity.TileEntityXPShower;
import openblocks.enchantments.flimflams.LoreFlimFlam;
import openmods.entity.EntityBlock;
import openmods.entity.renderer.EntityBlockRenderer;
import openmods.renderer.BlockRenderingHandler;
import openmods.renderer.BlockRenderingValidator;
import openmods.renderer.IBlockRenderer;
import openmods.renderer.RotatedBlockRenderer;

public class ClientProxy
implements IOpenBlocksProxy {
    private static final ResourceLocation RADIO_VILLAGER_TEXTURE = new ResourceLocation("openblocks", "textures/models/king-ish.png");

    @SubscribeEvent
    public void textureHook(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 0) {
            Icons.xpJuiceFlowing = event.map.func_94245_a("openblocks:xpjuiceflowing");
            Icons.xpJuiceStill = event.map.func_94245_a("openblocks:xpjuicestill");
            OpenBlocks.Fluids.xpJuice.setIcons(Icons.xpJuiceStill, Icons.xpJuiceFlowing);
        }
    }

    public void preInit() {
        new KeyInputHandler().setup();
        if (Config.radioVillagerId > 0) {
            VillagerRegistry.instance().registerVillagerSkin(Config.radioVillagerId, RADIO_VILLAGER_TEXTURE);
        }
        if (Config.flimFlamEnchantmentId > 0) {
            MinecraftForge.EVENT_BUS.register((Object)new LoreFlimFlam.DisplayHandler());
        }
    }

    public void init() {
        FMLCommonHandler.instance().bus().register((Object)new ClientTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new EntityMiniMe.OwnerChangeHandler());
    }

    public void postInit() {
        SoundEventsManager.instance.init();
    }

    public void registerRenderInformation() {
        OpenBlocks.renderIdFull = RenderingRegistry.getNextAvailableRenderId();
        BlockRenderingHandler blockRenderingHandler = new BlockRenderingHandler(OpenBlocks.renderIdFull, true);
        blockRenderingHandler.addRenderer((Block)OpenBlocks.Blocks.path, (IBlockRenderer)new BlockPathRenderer());
        BlockCanvasRenderer canvasRenderer = new BlockCanvasRenderer();
        blockRenderingHandler.addRenderer((Block)OpenBlocks.Blocks.canvas, (IBlockRenderer)canvasRenderer);
        blockRenderingHandler.addRenderer((Block)OpenBlocks.Blocks.canvasGlass, (IBlockRenderer)canvasRenderer);
        blockRenderingHandler.addRenderer((Block)OpenBlocks.Blocks.paintCan, (IBlockRenderer)new BlockPaintCanRenderer());
        blockRenderingHandler.addRenderer((Block)OpenBlocks.Blocks.sky, (IBlockRenderer)new BlockSkyRenderer());
        blockRenderingHandler.addRenderer((Block)OpenBlocks.Blocks.tank, (IBlockRenderer)new BlockTankRenderer());
        IBlockRenderer guideBlockRenderer = RotatedBlockRenderer.wrap((IBlockRenderer)new BlockGuideRenderer());
        blockRenderingHandler.addRenderer((Block)OpenBlocks.Blocks.guide, guideBlockRenderer);
        blockRenderingHandler.addRenderer((Block)OpenBlocks.Blocks.builderGuide, guideBlockRenderer);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)blockRenderingHandler);
        OpenBlocks.renderIdFlat = RenderingRegistry.getNextAvailableRenderId();
        blockRenderingHandler = new BlockRenderingHandler(OpenBlocks.renderIdFlat, false);
        blockRenderingHandler.addRenderer((Block)OpenBlocks.Blocks.ropeLadder, (IBlockRenderer)new BlockRopeLadderRenderer());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)blockRenderingHandler);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityGuide.class, (TileEntitySpecialRenderer)new TileEntityGuideRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBuilderGuide.class, (TileEntitySpecialRenderer)new TileEntityBuilderGuideRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTarget.class, (TileEntitySpecialRenderer)new TileEntityTargetRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityGrave.class, (TileEntitySpecialRenderer)new TileEntityGraveRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityFlag.class, (TileEntitySpecialRenderer)new TileEntityFlagRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTank.class, (TileEntitySpecialRenderer)new TileEntityTankRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTrophy.class, (TileEntitySpecialRenderer)new TileEntityTrophyRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBearTrap.class, (TileEntitySpecialRenderer)new TileEntityBearTrapRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySprinkler.class, (TileEntitySpecialRenderer)new TileEntitySprinklerRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCannon.class, (TileEntitySpecialRenderer)new TileEntityCannonRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityVacuumHopper.class, (TileEntitySpecialRenderer)new TileEntityVacuumHopperRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityImaginary.class, (TileEntitySpecialRenderer)new TileEntityImaginaryRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityFan.class, (TileEntitySpecialRenderer)new TileEntityFanRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityVillageHighlighter.class, (TileEntitySpecialRenderer)new TileEntityVillageHighlighterRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityAutoAnvil.class, (TileEntitySpecialRenderer)new TileEntityAutoAnvilRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityAutoEnchantmentTable.class, (TileEntitySpecialRenderer)new TileEntityAutoEnchantmentTableRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDonationStation.class, (TileEntitySpecialRenderer)new TileEntityDonationStationRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPaintMixer.class, (TileEntitySpecialRenderer)new TileEntityPaintMixerRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityProjector.class, (TileEntitySpecialRenderer)new TileEntityProjectorRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySky.class, (TileEntitySpecialRenderer)new TileEntitySkyRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityXPShower.class, (TileEntitySpecialRenderer)new TileEntityXPShowerRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityGoldenEgg.class, (TileEntitySpecialRenderer)new TileEntityGoldenEggRenderer());
        if (OpenBlocks.Blocks.tank != null) {
            MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)OpenBlocks.Blocks.tank), (IItemRenderer)new ItemRendererTank());
        }
        if (OpenBlocks.Items.luggage != null) {
            MinecraftForgeClient.registerItemRenderer((Item)OpenBlocks.Items.luggage, (IItemRenderer)new ItemRendererLuggage());
            RenderingRegistry.registerEntityRenderingHandler(EntityLuggage.class, (Render)new EntityLuggageRenderer());
        }
        if (OpenBlocks.Blocks.paintCan != null) {
            MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)OpenBlocks.Blocks.paintCan), (IItemRenderer)new ItemRendererPaintCan());
        }
        if (OpenBlocks.Items.hangGlider != null) {
            RenderingRegistry.registerEntityRenderingHandler(EntityHangGlider.class, (Render)new EntityHangGliderRenderer());
            MinecraftForgeClient.registerItemRenderer((Item)OpenBlocks.Items.hangGlider, (IItemRenderer)new ItemRendererHangGlider());
            MinecraftForge.EVENT_BUS.register((Object)new GliderPlayerRenderHandler());
        }
        if (OpenBlocks.Items.sonicGlasses != null) {
            MinecraftForge.EVENT_BUS.register((Object)SoundEventsManager.instance);
        }
        if (OpenBlocks.Items.craneBackpack != null) {
            ModelCraneBackpack.instance.init();
            RenderingRegistry.registerEntityRenderingHandler(EntityMagnet.class, (Render)new EntityMagnetRenderer());
            RenderingRegistry.registerEntityRenderingHandler(EntityBlock.class, (Render)new EntityBlockRenderer());
        }
        if (OpenBlocks.Blocks.goldenEgg != null) {
            RenderingRegistry.registerEntityRenderingHandler(EntityMiniMe.class, (Render)new EntityMiniMeRenderer());
        }
        if (OpenBlocks.Items.devNull != null) {
            MinecraftForgeClient.registerItemRenderer((Item)OpenBlocks.Items.devNull, (IItemRenderer)new ItemRendererDevNull());
        }
        if (OpenBlocks.Items.sleepingBag != null) {
            MinecraftForge.EVENT_BUS.register((Object)new SleepingBagRenderHandler());
        }
        MinecraftForge.EVENT_BUS.register((Object)new EntitySelectionHandler());
        if (OpenBlocks.Items.cartographer != null) {
            RenderingRegistry.registerEntityRenderingHandler(EntityCartographer.class, (Render)new EntityCartographerRenderer());
            EntitySelectionHandler.registerRenderer(EntityCartographer.class, new EntityCartographerRenderer.Selection());
        }
        if (OpenBlocks.Blocks.trophy != null) {
            MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)OpenBlocks.Blocks.trophy), (IItemRenderer)new ItemRendererTrophy());
        }
        if (OpenBlocks.Items.goldenEye != null) {
            RenderingRegistry.registerEntityRenderingHandler(EntityGoldenEye.class, (Render)new EntityGoldenEyeRenderer());
        }
        new BlockRenderingValidator().verifyBlocks(OpenBlocks.Blocks.class);
    }

    private static void spawnParticle(EntityFX spray) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a(spray);
    }

    @Override
    public void spawnLiquidSpray(World worldObj, Fluid fluid, double x, double y, double z, float scale, float gravity, Vec3 velocity) {
        ClientProxy.spawnParticle(new FXLiquidSpray(worldObj, fluid, x, y, z, scale, gravity, velocity));
    }

    @Override
    public void spawnParticleSpray(World worldObj, IIcon icon, double x, double y, double z, float scale, float gravity, Vec3 velocity) {
        if (icon != null) {
            ClientProxy.spawnParticle(new FXLiquidSpray(worldObj, icon, x, y, z, scale, gravity, velocity));
        }
    }

    public static class Icons {
        public static IIcon xpJuiceStill;
        public static IIcon xpJuiceFlowing;
    }
}

