/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity.tank;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.FluidStack;
import openmods.utils.Diagonal;

public class TankRenderUtils {
    private static final float PHASE_PER_DISTANCE = 0.5f;
    private static final float WAVE_AMPLITUDE = 0.01f;
    private static final float WAVE_FREQUENCY = 0.1f;

    public static float clampLevel(float level) {
        if (level <= 0.1f) {
            return 0.1f;
        }
        if (level >= 0.9f) {
            return 1.0f;
        }
        return level;
    }

    public static float calculatePhase(int x, int y, int z, Diagonal diagonal) {
        float posX = (float)x + (float)diagonal.offsetX / 2.0f;
        float posY = (float)y + (float)diagonal.offsetY / 2.0f;
        float posZ = (float)z + (float)diagonal.offsetZ / 2.0f;
        return (posX + posY + posZ) * 0.5f;
    }

    public static float calculatePhase(int x, int y, int z) {
        return (float)(x + y + z) * 0.5f;
    }

    public static float calculateWaveAmplitude(float time, float phase) {
        return MathHelper.func_76126_a((float)(time * 0.1f + phase)) * 0.01f;
    }

    public static FluidStack safeCopy(FluidStack stack) {
        return stack != null ? stack : null;
    }

    public static TileEntity getTileEntitySafe(World world, int x, int y, int z) {
        if (world.func_72899_e(x, y, z)) {
            Chunk chunk = world.func_72938_d(x, z);
            return chunk.getTileEntityUnsafe(x & 0xF, y, z & 0xF);
        }
        return null;
    }
}

