/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.client.gui.GuiSprinkler;
import openblocks.common.container.ContainerSprinkler;
import openmods.api.IBreakAwareTile;
import openmods.api.IHasGui;
import openmods.api.INeighbourAwareTile;
import openmods.api.ISurfaceAttachment;
import openmods.fakeplayer.FakePlayerPool;
import openmods.fakeplayer.OpenModsFakePlayer;
import openmods.include.IncludeInterface;
import openmods.include.IncludeOverride;
import openmods.inventory.GenericInventory;
import openmods.inventory.IInventoryProvider;
import openmods.inventory.TileEntityInventory;
import openmods.inventory.legacy.ItemDistribution;
import openmods.liquids.GenericFluidHandler;
import openmods.sync.SyncableFlags;
import openmods.sync.SyncableTank;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.BlockUtils;

public class TileEntitySprinkler
extends SyncedTileEntity
implements IBreakAwareTile,
ISurfaceAttachment,
IInventoryProvider,
IHasGui,
INeighbourAwareTile {
    private static final ItemStack BONEMEAL = new ItemStack(Items.field_151100_aR, 1, 15);
    private static final Random RANDOM = new Random();
    private static final double[] SPRINKER_DELTA = new double[]{0.2, 0.25, 0.5};
    private static final int[] SPRINKER_MOD = new int[]{1, 5, 20};
    private boolean hasBonemeal = false;
    private boolean needsTankUpdate;
    private SyncableFlags flags;
    private SyncableTank tank;
    public int ticks;
    private final GenericInventory inventory = this.registerInventoryCallback((GenericInventory)new TileEntityInventory((TileEntity)this, "sprinkler", true, 9){

        public boolean func_94041_b(int i, ItemStack itemstack) {
            return itemstack != null && itemstack.func_77969_a(BONEMEAL);
        }
    });
    @IncludeInterface
    private final IFluidHandler tankWrapper = new GenericFluidHandler.Drain((IFluidTank)this.tank);
    private static final double SPRAY_SIDE_SCATTER = Math.toRadians(25.0);

    protected void createSyncedFields() {
        this.flags = SyncableFlags.create((int)Flags.values().length);
        this.tank = new SyncableTank(Config.sprinklerInternalTank, new Fluid[]{FluidRegistry.WATER, OpenBlocks.Fluids.xpJuice});
    }

    private static int selectFromRange(int range) {
        return RANDOM.nextInt(2 * range + 1) - range;
    }

    private void attemptFertilize() {
        int fertilizerChance;
        if (!(this.field_145850_b instanceof WorldServer)) {
            return;
        }
        int n = fertilizerChance = this.hasBonemeal ? Config.sprinklerBonemealFertizizeChance : Config.sprinklerFertilizeChance;
        if (RANDOM.nextDouble() < 1.0 / (double)fertilizerChance) {
            FakePlayerPool.instance.executeOnPlayer((WorldServer)this.field_145850_b, new FakePlayerPool.PlayerUser(){

                public void usePlayer(OpenModsFakePlayer fakePlayer) {
                    int x = TileEntitySprinkler.selectFromRange(Config.sprinklerEffectiveRange) + TileEntitySprinkler.this.field_145851_c;
                    int z = TileEntitySprinkler.selectFromRange(Config.sprinklerEffectiveRange) + TileEntitySprinkler.this.field_145849_e;
                    for (int i = -1; i <= 1; ++i) {
                        int y = TileEntitySprinkler.this.field_145848_d + i;
                        if (ItemDye.applyBonemeal((ItemStack)BONEMEAL.func_77946_l(), (World)TileEntitySprinkler.this.field_145850_b, (int)x, (int)y, (int)z, (EntityPlayer)fakePlayer)) break;
                    }
                }
            });
        }
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerSprinkler((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiSprinkler(new ContainerSprinkler((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    private void sprayParticles() {
        if (this.tank.getFluidAmount() > 0) {
            int particleSetting = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
            if (particleSetting > 2) {
                return;
            }
            int fillFactor = SPRINKER_MOD[particleSetting];
            if (this.ticks % fillFactor != 0) {
                return;
            }
            ForgeDirection blockYawRotation = this.getOrientation().north();
            double nozzleAngle = this.getSprayDirection();
            double sprayForwardVelocity = Math.sin(Math.toRadians(nozzleAngle * 25.0));
            double forwardVelocityX = sprayForwardVelocity * (double)blockYawRotation.offsetZ / -2.0;
            double forwardVelocityZ = sprayForwardVelocity * (double)blockYawRotation.offsetX / 2.0;
            double sprinklerDelta = SPRINKER_DELTA[particleSetting];
            for (double outletPosition = -0.5; outletPosition <= 0.5; outletPosition += sprinklerDelta) {
                double spraySideVelocity = Math.sin(SPRAY_SIDE_SCATTER * (RANDOM.nextDouble() - 0.5));
                double sideVelocityX = spraySideVelocity * (double)blockYawRotation.offsetX;
                double sideVelocityZ = spraySideVelocity * (double)blockYawRotation.offsetZ;
                Vec3 vec = Vec3.func_72443_a((double)(forwardVelocityX + sideVelocityX), (double)0.35, (double)(forwardVelocityZ + sideVelocityZ));
                OpenBlocks.proxy.spawnLiquidSpray(this.field_145850_b, this.tank.getFluid().getFluid(), (double)this.field_145851_c + 0.5 + outletPosition * 0.6 * (double)blockYawRotation.offsetX, (double)this.field_145848_d + 0.2, (double)this.field_145849_e + 0.5 + outletPosition * 0.6 * (double)blockYawRotation.offsetZ, 0.3f, 0.7f, vec);
            }
        }
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.tank.getFluidAmount() <= 0) {
                if (this.needsTankUpdate) {
                    this.tank.updateNeighbours(this.field_145850_b, this.getPosition());
                    this.needsTankUpdate = false;
                }
                this.tank.fillFromSide(this.field_145850_b, this.getPosition(), ForgeDirection.DOWN);
            }
            if (this.ticks % Config.sprinklerBonemealConsumeRate == 0) {
                this.hasBonemeal = ItemDistribution.consumeFirstInventoryItem((IInventory)this.inventory, (ItemStack)BONEMEAL);
            }
            if (this.ticks % Config.sprinklerWaterConsumeRate == 0) {
                this.setEnabled(this.tank.drain(1, true) != null);
                this.sync();
            }
        }
        ++this.ticks;
        if (this.isEnabled()) {
            if (this.field_145850_b.field_72995_K) {
                this.sprayParticles();
            } else {
                this.attemptFertilize();
            }
        }
    }

    private void setEnabled(boolean b) {
        this.flags.set((Enum)Flags.enabled, b);
    }

    private boolean isEnabled() {
        return this.flags.get((Enum)Flags.enabled);
    }

    public ForgeDirection getSurfaceDirection() {
        return ForgeDirection.DOWN;
    }

    public void onBlockBroken() {
        if (!this.field_145850_b.field_72995_K && !this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            BlockUtils.dropItemStackInWorld((World)this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (ItemStack)new ItemStack((Block)OpenBlocks.Blocks.sprinkler));
        }
    }

    public float getSprayDirection() {
        if (this.isEnabled()) {
            return MathHelper.func_76126_a((float)((float)this.ticks * 0.02f));
        }
        return 0.0f;
    }

    @IncludeOverride
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    @IncludeInterface
    public IInventory getInventory() {
        return this.inventory;
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.needsTankUpdate = true;
    }

    public void onNeighbourChanged(Block block) {
        this.needsTankUpdate = true;
    }

    public static enum Flags {
        enabled;

    }
}

