/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.spacecore.asm.block;

import com.spacechase0.minecraft.spacecore.asm.SpaceCoreLog;
import com.spacechase0.minecraft.spacecore.asm.obf.ObfuscatedMethod;
import com.spacechase0.minecraft.spacecore.asm.obf.ObfuscatedType;
import com.spacechase0.minecraft.spacecore.asm.obf.ObfuscationUtils;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class BlockDestructionTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null || !transformedName.equals("net.minecraft.server.management.ItemInWorldManager")) {
            return bytes;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode method : classNode.methods) {
            ObfuscatedMethod obfMethod = ObfuscatedMethod.fromObf(name, method.name, method.desc);
            String mappedHarvestFunc = ObfuscatedMethod.fromMcp((String)"net/minecraft/server/management/ItemInWorldManager", (String)"tryHarvestBlock", (String)"(III)Z").obfName;
            if (!obfMethod.mcpName.equals(mappedHarvestFunc) || !obfMethod.deobfDesc.equals("(III)Z")) continue;
            SpaceCoreLog.fine("Found ItemInWorldManager.tryHarvestBlock(...).");
            this.injectInterceptor(method, name);
            ClassWriter writer = new ClassWriter(3);
            classNode.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return bytes;
    }

    private void injectInterceptor(MethodNode method, String realName) {
        AbstractInsnNode at = null;
        boolean foundHarvestBlock = false;
        for (AbstractInsnNode insn : method.instructions) {
            if (insn.getOpcode() == 182) {
                MethodInsnNode node = (MethodInsnNode)insn;
                ObfuscatedMethod obfMethod = ObfuscatedMethod.fromObf(node.owner, node.name, node.desc);
                String methodName = ObfuscatedMethod.fromMcp((String)"net/minecraft/server/management/ItemInWorldManager", (String)"removeBlock", (String)"(III)Z").obfName;
                boolean found = true;
                found = found && ObfuscatedType.fromObf((String)node.owner).deobfName.equals("net/minecraft/block/Block");
                found = found && obfMethod.mcpName.equals(methodName);
                if (!(found = found && obfMethod.deobfDesc.equals("(Lnet/minecraft/world/World;Lnet/minecraft/entity/player/EntityPlayer;IIII)V"))) continue;
                SpaceCoreLog.fine("Found call to Block.harvestBlock");
                foundHarvestBlock = true;
                continue;
            }
            if (insn.getOpcode() != 21 || !foundHarvestBlock) continue;
            at = insn;
        }
        if (at != null) {
            SpaceCoreLog.fine("Found ILOAD instruction, injecting interceptor.");
            String iiwmClass = ObfuscationUtils.asmify(realName);
            InsnList instructions = new InsnList();
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
            instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
            instructions.add((AbstractInsnNode)new VarInsnNode(21, 3));
            instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/spacechase0/minecraft/spacecore/block/BlockDestroyedNotifier", "intercept", "(L" + iiwmClass + ";III)V"));
            method.instructions.insertBefore(at, instructions);
        }
    }
}

