/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.spacecore.asm.config;

import com.spacechase0.minecraft.spacecore.asm.SpaceCoreLog;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;

public class AutoConfigTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return bytes;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        if (classNode.visibleAnnotations == null) {
            return bytes;
        }
        for (AnnotationNode annot : classNode.visibleAnnotations) {
            if (!annot.desc.equals("Lcom/spacechase0/minecraft/spacecore/config/AutoConfig;")) continue;
            this.setGuiFactory(classNode);
            ClassWriter writer = new ClassWriter(3);
            classNode.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return bytes;
    }

    private void setGuiFactory(ClassNode classNode) {
        for (AnnotationNode annot : classNode.visibleAnnotations) {
            if (!annot.desc.equals("Lcpw/mods/fml/common/Mod;")) continue;
            String factory = classNode.name.replace('/', '.').substring(0, classNode.name.lastIndexOf(47)) + ".config.GuiFactory_ASM";
            annot.values.add("guiFactory");
            annot.values.add(factory);
            return;
        }
        SpaceCoreLog.warning("No @Mod for class with @AutoConfig");
    }
}

