/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.spacecore.asm.config;

import com.google.common.io.ByteStreams;
import com.spacechase0.minecraft.spacecore.asm.SpaceCoreLog;
import com.spacechase0.minecraft.spacecore.asm.mod.ModPackageIndex;
import com.spacechase0.minecraft.spacecore.asm.obf.ObfuscatedType;
import com.spacechase0.minecraft.spacecore.util.FileUtils;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class GuiFactoryTransformer
implements IClassTransformer {
    private byte[] baseConfigGui;
    private byte[] baseDummyEntry;
    private Map<String, byte[]> toDefine = new HashMap<String, byte[]>();

    public GuiFactoryTransformer() {
        try {
            this.baseConfigGui = ByteStreams.toByteArray((InputStream)this.getClass().getResourceAsStream("/com/spacechase0/minecraft/spacecore/config/BaseConfigGui.class"));
            this.baseDummyEntry = ByteStreams.toByteArray((InputStream)this.getClass().getResourceAsStream("/com/spacechase0/minecraft/spacecore/config/BaseConfigGui$DummyEntry.class"));
        }
        catch (Exception exception) {
            SpaceCoreLog.severe("Failed to load base config GUI bytes, things WILL crash horribly!");
            exception.printStackTrace();
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes != null) {
            return bytes;
        }
        if (name.startsWith("com.spacechase0.minecraft.")) {
            if (name.endsWith(".config.GuiFactory_ASM")) {
                return this.createFactory(name);
            }
            if (name.endsWith(".config.ConfigGui_ASM")) {
                return this.createConfigGui(name);
            }
        }
        return null;
    }

    private byte[] createFactory(String name) {
        ClassNode classNode = new ClassNode();
        classNode.access = 1;
        classNode.name = name.replace('.', '/');
        classNode.signature = "L" + classNode.name + ";";
        classNode.superName = "com/spacechase0/minecraft/spacecore/config/BaseGuiFactory";
        classNode.version = 50;
        MethodNode init = new MethodNode(1, "<init>", "()V", null, null);
        init.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        init.instructions.add((AbstractInsnNode)new MethodInsnNode(183, "com/spacechase0/minecraft/spacecore/config/BaseGuiFactory", "<init>", "()V"));
        init.instructions.add((AbstractInsnNode)new InsnNode(177));
        classNode.methods.add(init);
        MethodNode configGui = new MethodNode(1, "mainConfigGuiClass", "()Ljava/lang/Class;", "()Ljava/lang/Class<+L" + ObfuscatedType.fromDeobf((String)"net/minecraft/client/gui/GuiScreen").obfName + ";>;", null);
        String type = name.substring(0, name.lastIndexOf(46)) + ".ConfigGui_ASM";
        type = type.replace('.', '/');
        System.out.println("type is " + type);
        configGui.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)Type.getType((String)("L" + type + ";"))));
        configGui.instructions.add((AbstractInsnNode)new InsnNode(176));
        classNode.methods.add(configGui);
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] createConfigGui(String name) {
        ClassNode classNode = new ClassNode();
        ClassReader reader = new ClassReader(this.baseConfigGui);
        reader.accept((ClassVisitor)classNode, 0);
        classNode.name = classNode.name.replace("spacecore", name.substring(name.indexOf(".minecraft.") + 11, name.indexOf(".config")));
        classNode.name = classNode.name.replace("BaseConfigGui", "ConfigGui_ASM");
        classNode.signature = "L" + classNode.name + ";";
        String find = "com/spacechase0/minecraft/spacecore/config/BaseConfigGui";
        for (MethodNode method : classNode.methods) {
            for (AbstractInsnNode insn : method.instructions) {
                if (!(insn instanceof MethodInsnNode)) continue;
                MethodInsnNode minsn = (MethodInsnNode)insn;
                if (!minsn.owner.equals(find)) continue;
                minsn.owner = classNode.name;
            }
            String pkg = name.substring(0, name.lastIndexOf(46, name.lastIndexOf(46) - 1));
            String mod = ModPackageIndex.getModForPackage(pkg);
            pkg = pkg.replace('.', '/');
            String full = pkg + "/" + mod;
            if (method.name.equals("getMod")) {
                method.instructions.clear();
                method.instructions.add((AbstractInsnNode)new FieldInsnNode(178, full, "instance", "L" + full + ";"));
                method.instructions.add((AbstractInsnNode)new InsnNode(176));
                continue;
            }
            if (!method.name.equals("getConfigElements")) continue;
            String[] categories = null;
            try {
                String file = "/" + full + ".class";
                byte[] bytes = ByteStreams.toByteArray((InputStream)this.getClass().getResourceAsStream(file));
                ClassNode modClass = new ClassNode();
                ClassReader modReader = new ClassReader(bytes);
                modReader.accept((ClassVisitor)modClass, 0);
                for (AnnotationNode annotationNode : modClass.visibleAnnotations) {
                    if (!annotationNode.desc.equals("Lcom/spacechase0/minecraft/spacecore/util/AutoConfig;")) continue;
                    categories = (String[])annotationNode.values.get(1);
                    break;
                }
            }
            catch (Exception exception) {
                SpaceCoreLog.severe("Failed to get mod class bytes! Things are about to go wrong!");
                SpaceCoreLog.severe("Debug info: " + full);
                exception.printStackTrace();
            }
            InsnList addCategory = new InsnList();
            int sinceList = -1;
            for (int i = 0; i < method.instructions.size(); ++i) {
                InsnNode iinsn;
                AbstractInsnNode insn = method.instructions.get(i);
                if (insn instanceof MethodInsnNode) {
                    MethodInsnNode minsn = (MethodInsnNode)insn;
                    if (minsn.owner.equals("java/util/ArrayList") && minsn.name.equals("<init>")) {
                        sinceList = 0;
                        continue;
                    }
                } else if (insn instanceof InsnNode && (iinsn = (InsnNode)insn).getOpcode() == 176) {
                    addCategory.remove(addCategory.getLast());
                    break;
                }
                if (sinceList >= 0) {
                    ++sinceList;
                }
                if (sinceList <= 1) continue;
                addCategory.add(insn);
            }
            classNode.innerClasses.clear();
            for (void var17_24 : categories) {
                ClassNode innerClass = new ClassNode();
                ClassReader innerReader = new ClassReader(this.baseDummyEntry);
                innerReader.accept((ClassVisitor)innerClass, 0);
                ClassWriter writer = new ClassWriter(3);
                innerClass.accept((ClassVisitor)writer);
                this.toDefine.put(pkg.replace('/', '.') + ".config.ConfigGui_ASM$" + Character.toUpperCase(var17_24.charAt(0)) + var17_24.substring(1) + "Entry", writer.toByteArray());
            }
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        FileUtils.saveBytes(name.substring(name.lastIndexOf(46) + 1) + ".class", writer.toByteArray());
        return writer.toByteArray();
    }
}

