/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.spacecore.asm.mcp;

import com.spacechase0.minecraft.spacecore.asm.SpaceCoreLog;
import com.spacechase0.minecraft.spacecore.asm.obf.ObfuscationUtils;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class LoaderModInfoTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null || ObfuscationUtils.isRuntimeDeobfuscated() || !transformedName.equals("cpw.mods.fml.common.Loader")) {
            return bytes;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals("<init>")) continue;
            SpaceCoreLog.fine("Found Loader constructor, hacking mcmod.info generation.");
            this.injectInterceptor(method, name);
            ClassWriter writer = new ClassWriter(3);
            classNode.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return bytes;
    }

    private void injectInterceptor(MethodNode method, String realName) {
        AbstractInsnNode at = null;
        for (AbstractInsnNode insn : method.instructions) {
            if (insn.getOpcode() != 177) continue;
            at = insn;
        }
        if (at != null) {
            SpaceCoreLog.fine("Found return, injecting generation.");
            String stackClass = ObfuscationUtils.asmify(realName);
            InsnList instructions = new InsnList();
            instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/spacechase0/minecraft/spacecore/mcp/ModInfoGenerator", "generate", "()V"));
            method.instructions.insertBefore(at, instructions);
        }
    }
}

