/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.spacecore.asm.mod;

import com.spacechase0.minecraft.spacecore.asm.SpaceCoreLog;
import com.spacechase0.minecraft.spacecore.asm.mod.ModPackageIndex;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ModInitTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return bytes;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        if (classNode.superName.equals("com/spacechase0/minecraft/spacecore/BaseMod")) {
            this.checkInits(classNode);
            ModPackageIndex.setModForPackage(name.substring(0, name.lastIndexOf(46)), name.substring(name.lastIndexOf(46) + 1));
            ClassWriter writer = new ClassWriter(3);
            classNode.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return bytes;
    }

    private void checkInits(ClassNode classNode) {
        boolean hasPre = false;
        boolean hasInit = false;
        boolean hasPost = false;
        for (MethodNode method : classNode.methods) {
            if (method.desc.contains("FMLPreInitializationEvent")) {
                hasPre = true;
            }
            if (method.desc.contains("FMLInitializationEvent")) {
                hasInit = true;
            }
            if (!method.desc.contains("FMLPostInitializationEvent")) continue;
            hasPost = true;
        }
        if (!hasPre) {
            this.addEventMethod(classNode, "preInit", "cpw/mods/fml/common/event/FMLPreInitializationEvent");
        }
        if (!hasInit) {
            this.addEventMethod(classNode, "init", "cpw/mods/fml/common/event/FMLInitializationEvent");
        }
        if (!hasPost) {
            this.addEventMethod(classNode, "postInit", "cpw/mods/fml/common/event/FMLPostInitializationEvent");
        }
    }

    private void addEventMethod(ClassNode classNode, String name, String type) {
        SpaceCoreLog.info("Adding artificial " + name + " to " + classNode.name);
        String desc = "(L" + type + ";)V";
        MethodNode method = new MethodNode(1, name, desc, null, null);
        method.visitAnnotation("Lcpw/mods/fml/common/Mod$EventHandler;", true);
        method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        method.instructions.add((AbstractInsnNode)new MethodInsnNode(183, "com/spacechase0/minecraft/spacecore/BaseMod", name, desc));
        method.instructions.add((AbstractInsnNode)new InsnNode(177));
        classNode.methods.add(method);
    }
}

