/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.spacecore.asm.obf;

import com.spacechase0.minecraft.spacecore.asm.obf.ObfuscationUtils;

public class ObfuscatedField {
    public final String obfType;
    public final String obfName;
    public final String obfDesc;
    public final String srgName;
    public final String deobfType;
    public final String mcpName;
    public final String deobfDesc;

    protected ObfuscatedField(String theObfType, String theObfName, String theObfDesc, String theSrgName, String theDeobfType, String theDeobfName, String theDeobfDesc) {
        this.obfType = theObfType;
        this.obfName = theObfName;
        this.obfDesc = theObfDesc;
        this.srgName = theSrgName;
        this.deobfType = theDeobfType;
        this.mcpName = theDeobfName;
        this.deobfDesc = theDeobfDesc;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[ " + this.obfDesc + " " + this.obfType + "." + this.obfName + " -> " + this.deobfDesc + " " + this.deobfType + "." + this.mcpName + " (" + this.srgName + ") ]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObfuscatedField)) {
            return false;
        }
        ObfuscatedField f = (ObfuscatedField)obj;
        return f.deobfType.equals(this.deobfType) && f.mcpName.equals(this.mcpName) && f.deobfDesc.equals(this.deobfDesc);
    }

    public static ObfuscatedField fromObf(String type, String name) {
        ObfuscatedField obj = ObfuscationUtils.getFieldFromObf(type, name);
        return ObfuscationUtils.isRuntimeDeobfuscated() ? obj : new ObfuscatedField(type, name, obj.obfDesc, obj.mcpName, type, name, obj.deobfDesc);
    }

    public static ObfuscatedField fromSrg(String type, String name) {
        ObfuscatedField obj = ObfuscationUtils.getFieldFromSrg(type, name);
        return ObfuscationUtils.isRuntimeDeobfuscated() ? obj : new ObfuscatedField(type, name, obj.obfDesc, obj.mcpName, type, name, obj.deobfDesc);
    }

    public static ObfuscatedField fromMcp(String type, String name) {
        ObfuscatedField obj = ObfuscationUtils.getFieldFromMcp(type, name);
        return ObfuscationUtils.isRuntimeDeobfuscated() ? obj : new ObfuscatedField(type, name, obj.obfDesc, obj.mcpName, type, name, obj.deobfDesc);
    }
}

