/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.spacecore.asm.obf;

import com.spacechase0.minecraft.spacecore.asm.obf.ObfuscationUtils;

public class ObfuscatedMethod {
    public final String obfType;
    public final String obfName;
    public final String obfDesc;
    public final String srgName;
    public final String deobfType;
    public final String mcpName;
    public final String deobfDesc;

    protected ObfuscatedMethod(String theObfType, String theObfName, String theObfDesc, String theSrgName, String theDeobfType, String theDeobfName, String theDeobfDesc) {
        this.obfType = theObfType;
        this.obfName = theObfName;
        this.obfDesc = theObfDesc;
        this.srgName = theSrgName;
        this.deobfType = theDeobfType;
        this.mcpName = theDeobfName;
        this.deobfDesc = theDeobfDesc;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[ " + this.obfType + "." + this.obfName + this.obfDesc + " -> " + this.deobfType + "." + this.mcpName + this.deobfDesc + " (" + this.srgName + ") ]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObfuscatedMethod)) {
            return false;
        }
        ObfuscatedMethod m = (ObfuscatedMethod)obj;
        return m.deobfType.equals(this.deobfType) && m.mcpName.equals(this.mcpName) && m.deobfDesc.equals(this.deobfDesc);
    }

    public static ObfuscatedMethod fromObf(String type, String name, String desc) {
        ObfuscatedMethod obj = ObfuscationUtils.getMethodFromObf(type, name, desc);
        return ObfuscationUtils.isRuntimeDeobfuscated() ? obj : new ObfuscatedMethod(type, name, desc, obj.mcpName, type, name, desc);
    }

    public static ObfuscatedMethod fromSrg(String type, String name, String desc) {
        ObfuscatedMethod obj = ObfuscationUtils.getMethodFromSrg(type, name, desc);
        return ObfuscationUtils.isRuntimeDeobfuscated() ? obj : new ObfuscatedMethod(type, obj.mcpName, desc, obj.mcpName, type, obj.mcpName, desc);
    }

    public static ObfuscatedMethod fromMcp(String type, String name, String desc) {
        ObfuscatedMethod obj = ObfuscationUtils.getMethodFromMcp(type, name, desc);
        return ObfuscationUtils.isRuntimeDeobfuscated() ? obj : new ObfuscatedMethod(type, name, desc, obj.mcpName, type, name, desc);
    }
}

