/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.spacecore.asm.obf;

import com.spacechase0.minecraft.spacecore.asm.obf.ObfuscationUtils;

public class ObfuscatedType {
    public final String obfName;
    public final String deobfName;

    protected ObfuscatedType(String obf, String deobf) {
        this.obfName = obf;
        this.deobfName = deobf;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[ " + this.obfName + " -> " + this.deobfName + " ]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObfuscatedType)) {
            return false;
        }
        ObfuscatedType c = (ObfuscatedType)obj;
        return c.obfName.equals(this.obfName) && c.deobfName.equals(this.deobfName);
    }

    public static ObfuscatedType fromObf(String name) {
        ObfuscatedType obj = ObfuscationUtils.getTypeFromObf(name);
        return ObfuscationUtils.isRuntimeDeobfuscated() ? obj : new ObfuscatedType(name, name);
    }

    public static ObfuscatedType fromDeobf(String name) {
        ObfuscatedType obj = ObfuscationUtils.getTypeFromDeobf(name);
        return ObfuscationUtils.isRuntimeDeobfuscated() ? obj : new ObfuscatedType(name, name);
    }
}

