/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.spacecore.client.gui;

import com.spacechase0.minecraft.spacecore.client.sound.SoundUtil;
import com.spacechase0.minecraft.spacecore.util.ClientUtils;
import com.spacechase0.minecraft.spacecore.util.INotifiable;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import org.lwjgl.opengl.GL11;

public class ReorderGui
extends Gui {
    public int x;
    public int y;
    public int width;
    private List<String> data;
    private int mx;
    private int my;
    private INotifiable toNotify;

    public ReorderGui(int theX, int theY, int theWidth, List<String> theData) {
        this.x = theX;
        this.y = theY;
        this.width = theWidth;
        this.data = theData;
    }

    public void pleaseNotify(INotifiable obj) {
        this.toNotify = obj;
    }

    public void mouseClicked(int mouseX, int mouseY, int button) {
        this.mx = mouseX;
        this.my = mouseY;
        if (button != 0) {
            return;
        }
        for (int i = 0; i < this.data.size(); ++i) {
            int upX = this.x + this.width - 18;
            int downX = this.x + this.width - 9;
            int buttonY = this.y + i * 9;
            int swapA = -1;
            int swapB = -1;
            if (this.getButtonState(upX, buttonY, i == 0) == 2) {
                swapA = i;
                swapB = i - 1;
            } else if (this.getButtonState(downX, buttonY, i == this.data.size() - 1) == 2) {
                swapA = i;
                swapB = i + 1;
            }
            if (swapA == -1) continue;
            SoundUtil.playSound("gui.button.press");
            String tmpA = this.data.get(swapA);
            String tmpB = this.data.get(swapB);
            this.data.set(swapA, tmpB);
            this.data.set(swapB, tmpA);
            this.toNotify.notify((Object)this, swapA, swapB);
            break;
        }
    }

    public void draw(FontRenderer fontRenderer, int mouseX, int mouseY) {
        this.mx = mouseX;
        this.my = mouseY;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < this.data.size(); ++i) {
            ClientUtils.bindTexture("spacecore:textures/gui/reorder.png");
            this.drawButton(this.x + this.width - 18, this.y + i * 9, 0, i == 0);
            this.drawButton(this.x + this.width - 9, this.y + i * 9, 1, i == this.data.size() - 1);
            ClientUtils.drawString(this.data.get(i), this.x, this.y + i * 9, -1);
        }
    }

    private void drawButton(int x, int y, int type, boolean valid) {
        this.func_73729_b(x, y, type * 9, this.getButtonState(x, y, valid) * 9, 9, 9);
    }

    private int getButtonState(int x, int y, boolean cancel) {
        if (cancel) {
            return 0;
        }
        if (this.mx >= x && this.my >= y && this.mx < x + 9 && this.my < y + 9) {
            return 2;
        }
        return 1;
    }
}

