/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.spacecore.client.tick;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;

public class SplashHandler {
    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (!event.phase.equals((Object)TickEvent.Phase.END)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r instanceof GuiMainMenu) {
            GuiMainMenu mainMenu = (GuiMainMenu)mc.field_71462_r;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            int month = calendar.get(2) + 1;
            int day = calendar.get(5);
            calendar.setTime(this.getEasterOf(calendar.get(1)));
            int easterMonth = calendar.get(3);
            int easterDay = calendar.get(5);
            if (month == 12 && (day == 24 || day == 25)) {
                this.setSplashText(mainMenu, day == 24 ? "Merry Christmas!" : "Merry CHRISTmas!");
            } else if (month == 2 && day == 9) {
                this.setSplashText(mainMenu, "Meow!");
            } else if (month == easterMonth && day == easterDay) {
                this.setSplashText(mainMenu, "He has risen!");
            }
        }
    }

    private void setSplashText(GuiMainMenu mainMenu, String str) {
        try {
            Field[] fields;
            for (Field f : fields = GuiMainMenu.class.getDeclaredFields()) {
                f.setAccessible(true);
                Object obj = f.get(mainMenu);
                if (!(obj instanceof String)) continue;
                f.set(mainMenu, str);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Date getEasterOf(int year) {
        Object result = null;
        int a = year % 19;
        int b = year / 100;
        int c = year % 100;
        int d = b / 4;
        int e = b % 4;
        int f = (b + 8) / 25;
        int g = (b - f + 1) / 3;
        int h = (19 * a + b - d - g + 15) % 30;
        int i = c / 4;
        int k = c % 4;
        int l = (32 + 2 * e + 2 * i - h - k) % 7;
        int m = (a + 11 * h + 22 * l) / 451;
        int p = (h + l - 7 * m + 114) % 31;
        int month = (h + l - 7 * m + 114) / 31;
        int day = p + 1;
        GregorianCalendar gc = new GregorianCalendar(year, month - 1, day);
        return gc.getTime();
    }
}

