/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.spacecore.tileentity;

import com.spacechase0.minecraft.spacecore.block.CustomSmelterBlock;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;

public abstract class CustomSmelterTileEntity
extends TileEntity
implements IInventory {
    private int burnTimeLeft;
    private int burnTimeTotal;
    private int progressAmount;
    protected int progressNeeded;

    public void func_145845_h() {
        int oldProgress = this.progressNeeded;
        this.updateProgressNeeded();
        if (oldProgress == 0 && this.progressNeeded > 0) {
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.progressNeeded > 0 && this.burnTimeLeft <= 0 && this.func_70301_a(this.getFuelSlot()) != null) {
            this.burnTimeTotal = this.burnTimeLeft = TileEntityFurnace.func_145952_a((ItemStack)this.func_70301_a(this.getFuelSlot()));
            this.func_70298_a(this.getFuelSlot(), 1);
            this.setBurnState(true);
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.burnTimeLeft > 0) {
            --this.burnTimeLeft;
            if (this.burnTimeLeft <= 0) {
                this.setBurnState(false);
            }
            if (this.progressNeeded > 0) {
                ++this.progressAmount;
            }
        } else {
            this.burnTimeTotal = 0;
        }
        if (this.progressNeeded > 0 && this.progressAmount >= this.progressNeeded) {
            this.recipeCompleted();
            this.progressAmount = 0;
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.burnTimeTotal = tag.func_74765_d("BurnTimeTotal");
        this.burnTimeLeft = tag.func_74765_d("BurnTimeLeft");
        this.progressAmount = tag.func_74765_d("ProgressAmount");
        this.updateProgressNeeded();
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74777_a("BurnTimeTotal", (short)this.burnTimeTotal);
        tag.func_74777_a("BurnTimeLeft", (short)this.burnTimeLeft);
        tag.func_74777_a("ProgressAmount", (short)this.progressAmount);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -1, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        if (this.field_145850_b.field_72995_K) {
            this.func_145839_a(pkt.func_148857_g());
        }
    }

    public int getBurnTimeTotal() {
        return this.burnTimeTotal;
    }

    public int getBurnTimeLeft() {
        return this.burnTimeLeft;
    }

    public int getProgressNeeded() {
        return this.progressNeeded;
    }

    public int getProgressAmount() {
        return this.progressAmount;
    }

    public void setBurnTimeLeft(int theBurnTimeLeft) {
        this.burnTimeLeft = theBurnTimeLeft;
    }

    public void setBurnTimeTotal(int theBurnTimeTotal) {
        this.burnTimeTotal = theBurnTimeTotal;
    }

    public void setProgressNeeded(int theProgressNeeded) {
        this.progressNeeded = theProgressNeeded;
    }

    public void setProgressAmount(int theProgressAmount) {
        this.progressAmount = theProgressAmount;
    }

    protected void setBurnState(boolean burning) {
        this.getBlock();
        CustomSmelterBlock.updateBlockState(burning, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    protected abstract CustomSmelterBlock getBlock();

    public abstract int getFuelSlot();

    protected abstract void updateProgressNeeded();

    protected abstract void recipeCompleted();
}

