/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.spacecore.util;

import com.spacechase0.minecraft.spacecore.BaseMod;
import com.spacechase0.minecraft.spacecore.asm.SpaceCoreLog;
import com.spacechase0.minecraft.spacecore.util.ModObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import net.minecraftforge.common.config.Configuration;

public abstract class AutoRegister {
    protected abstract boolean isValid(Class var1);

    protected abstract void registerSpecific(Field var1, ModObject var2, Object var3);

    public void register(BaseMod mod, Configuration config) {
        Field[] fields;
        boolean idCounter = false;
        Class<?> c = this.getClass();
        for (Field field : fields = c.getDeclaredFields()) {
            ModObject annot;
            if (!field.isAnnotationPresent(ModObject.class) || (annot = field.getAnnotation(ModObject.class)).skip()) continue;
            Class<?> objectClass = field.getType();
            if (!this.isValid(objectClass)) {
                SpaceCoreLog.severe("@ModObject annotation (" + annot + ") was given to invalid field (" + field + ").");
                continue;
            }
            Field params = null;
            try {
                params = c.getField(field.getName() + "Params");
            }
            catch (Exception exception) {
                // empty catch block
            }
            String name = annot.name();
            if (name.equals("")) {
                name = field.getName();
            }
            boolean enabled = true;
            if (annot.optional()) {
                enabled = config.getBoolean("enabled", name, true, "Enable " + name);
            }
            if (!enabled) continue;
            Object[] paramArray = new Object[]{};
            if (params != null) {
                try {
                    Object[] extraParamArray = (Object[])params.get(this);
                    if (extraParamArray != null) {
                        paramArray = extraParamArray;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            try {
                SpaceCoreLog.fine("Registering " + name + " object...");
                Constructor<?> constructor = objectClass.getDeclaredConstructor(this.getClasses(paramArray));
                Object result = constructor.newInstance(paramArray);
                field.set(this, result);
                this.registerSpecific(field, annot, result);
            }
            catch (Exception exception) {
                SpaceCoreLog.severe("Failed to create object " + name + ".");
                exception.printStackTrace();
            }
        }
    }

    protected Class[] getClasses(Object[] array) {
        Class[] classes = new Class[array.length];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = array[i].getClass();
            if (classes[i].equals(Integer.class)) {
                classes[i] = Integer.TYPE;
                continue;
            }
            if (classes[i].equals(Boolean.class)) {
                classes[i] = Boolean.TYPE;
                continue;
            }
            if (classes[i].equals(Byte.class)) {
                classes[i] = Byte.TYPE;
                continue;
            }
            if (classes[i].equals(Short.class)) {
                classes[i] = Short.TYPE;
                continue;
            }
            if (classes[i].equals(Long.class)) {
                classes[i] = Long.TYPE;
                continue;
            }
            if (classes[i].equals(Float.class)) {
                classes[i] = Float.TYPE;
                continue;
            }
            if (!classes[i].equals(Double.class)) continue;
            classes[i] = Double.TYPE;
        }
        return classes;
    }
}

