/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ARBVertexShader;
import org.lwjgl.util.vector.Matrix4f;

public class ShaderProgram {
    int programID = ARBShaderObjects.glCreateProgramObjectARB();

    public ShaderProgram() {
        if (this.programID == 0) {
            throw new RuntimeException("Unable to allocate shader program object.");
        }
    }

    public static void restore() {
        ARBShaderObjects.glUseProgramObjectARB((int)0);
    }

    public static String asString(InputStream stream) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        BufferedReader bin = new BufferedReader(new InputStreamReader(stream));
        while ((line = bin.readLine()) != null) {
            sb.append(line).append('\n');
        }
        stream.close();
        return sb.toString();
    }

    private static String getInfoLog(int shaderID) {
        return ARBShaderObjects.glGetInfoLogARB((int)shaderID, (int)ARBShaderObjects.glGetObjectParameteriARB((int)shaderID, (int)35716));
    }

    public void attach(int shaderType, String resource) {
        InputStream stream = ShaderProgram.class.getResourceAsStream(resource);
        if (stream == null) {
            throw new RuntimeException("Unable to locate resource: " + resource);
        }
        this.attach(shaderType, stream);
    }

    public void use() {
        ARBShaderObjects.glUseProgramObjectARB((int)this.programID);
    }

    public void link() {
        ARBShaderObjects.glLinkProgramARB((int)this.programID);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)this.programID, (int)35714) == 0) {
            throw new RuntimeException("Error linking program: " + ShaderProgram.getInfoLog(this.programID));
        }
        ARBShaderObjects.glValidateProgramARB((int)this.programID);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)this.programID, (int)35715) == 0) {
            throw new RuntimeException("Error validating program: " + ShaderProgram.getInfoLog(this.programID));
        }
        this.use();
        this.onLink();
        ShaderProgram.restore();
    }

    public void attach(int shaderType, InputStream stream) {
        if (stream == null) {
            throw new RuntimeException("Invalid shader inputstream");
        }
        int shaderID = 0;
        try {
            shaderID = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shaderID == 0) {
                throw new RuntimeException("Unable to allocate shader object.");
            }
            try {
                ARBShaderObjects.glShaderSourceARB((int)shaderID, (CharSequence)ShaderProgram.asString(stream));
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading inputstream.", e);
            }
            ARBShaderObjects.glCompileShaderARB((int)shaderID);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shaderID, (int)35713) == 0) {
                throw new RuntimeException("Error compiling shader: " + ShaderProgram.getInfoLog(shaderID));
            }
            ARBShaderObjects.glAttachObjectARB((int)this.programID, (int)shaderID);
        }
        catch (RuntimeException e) {
            ARBShaderObjects.glDeleteObjectARB((int)shaderID);
            throw e;
        }
    }

    public int getUniformLoc(String name) {
        return ARBShaderObjects.glGetUniformLocationARB((int)this.programID, (CharSequence)name);
    }

    public int getAttribLoc(String name) {
        return ARBVertexShader.glGetAttribLocationARB((int)this.programID, (CharSequence)name);
    }

    public void uniformTexture(String name, int textureIndex) {
        ARBShaderObjects.glUniform1iARB((int)this.getUniformLoc(name), (int)textureIndex);
    }

    public void onLink() {
    }

    public void glVertexAttributeMat4(int loc, Matrix4f matrix) {
        ARBVertexShader.glVertexAttrib4fARB((int)loc, (float)matrix.m00, (float)matrix.m01, (float)matrix.m02, (float)matrix.m03);
        ARBVertexShader.glVertexAttrib4fARB((int)(loc + 1), (float)matrix.m10, (float)matrix.m11, (float)matrix.m12, (float)matrix.m13);
        ARBVertexShader.glVertexAttrib4fARB((int)(loc + 2), (float)matrix.m20, (float)matrix.m21, (float)matrix.m22, (float)matrix.m23);
        ARBVertexShader.glVertexAttrib4fARB((int)(loc + 3), (float)matrix.m30, (float)matrix.m31, (float)matrix.m32, (float)matrix.m33);
    }
}

