/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.init;

import com.darkona.adventurebackpack.config.ConfigHandler;
import com.darkona.adventurebackpack.init.ModItems;
import com.darkona.adventurebackpack.reference.BackpackNames;
import cpw.mods.fml.common.registry.VillagerRegistry;
import java.util.Random;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.common.ChestGenHooks;

public class ModWorldGen {
    public static void init() {
        for (int i = 0; i < BackpackNames.backpackNames.length; ++i) {
            ItemStack backpack;
            if (BackpackNames.backpackNames[i].equals("IronGolem")) {
                backpack = BackpackNames.setBackpackColorNameFromDamage(new ItemStack((Item)ModItems.adventureBackpack), i);
                ChestGenHooks.addItem((String)"villageBlacksmith", (WeightedRandomChestContent)new WeightedRandomChestContent(backpack, 1, 1, 2));
                continue;
            }
            if (BackpackNames.backpackNames[i].equals("Bat")) {
                backpack = BackpackNames.setBackpackColorNameFromDamage(new ItemStack((Item)ModItems.adventureBackpack), i);
                ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(backpack, 1, 1, 2));
                ChestGenHooks.addItem((String)"mineshaftCorridor", (WeightedRandomChestContent)new WeightedRandomChestContent(backpack, 1, 1, 12));
                continue;
            }
            if (BackpackNames.backpackNames[i].equals("Pigman") && ConfigHandler.PIGMAN_ALLOWED) {
                backpack = BackpackNames.setBackpackColorNameFromDamage(new ItemStack((Item)ModItems.adventureBackpack), i);
                ChestGenHooks.addItem((String)"pyramidDesertyChest", (WeightedRandomChestContent)new WeightedRandomChestContent(backpack, 1, 1, 12));
                VillagerRegistry.instance().registerVillageTradeHandler(i, (VillagerRegistry.IVillageTradeHandler)new TradeHandler(backpack));
                continue;
            }
            if (BackpackNames.backpackNames[i].equals("Villager")) {
                backpack = BackpackNames.setBackpackColorNameFromDamage(new ItemStack((Item)ModItems.adventureBackpack), i);
                VillagerRegistry.instance().registerVillageTradeHandler(1, (VillagerRegistry.IVillageTradeHandler)new TradeHandler(backpack));
                VillagerRegistry.instance().registerVillageTradeHandler(2, (VillagerRegistry.IVillageTradeHandler)new TradeHandler(backpack));
                VillagerRegistry.instance().registerVillageTradeHandler(3, (VillagerRegistry.IVillageTradeHandler)new TradeHandler(backpack));
                continue;
            }
            if (!BackpackNames.backpackNames[i].equals("Standard") || !ConfigHandler.BONUS_CHEST_ALLOWED) continue;
            backpack = BackpackNames.setBackpackColorNameFromDamage(new ItemStack((Item)ModItems.adventureBackpack), i);
            ChestGenHooks.addItem((String)"bonusChest", (WeightedRandomChestContent)new WeightedRandomChestContent(backpack, 0, 1, 5));
        }
    }

    public static class TradeHandler
    implements VillagerRegistry.IVillageTradeHandler {
        ItemStack backpack;

        TradeHandler(ItemStack backpack) {
            this.backpack = backpack;
        }

        public void manipulateTradesForVillager(EntityVillager villager, MerchantRecipeList recipeList, Random random) {
            ItemStack payment;
            if (villager.func_70946_n() == 1 || villager.func_70946_n() == 2) {
                payment = BackpackNames.setBackpackColorNameFromDamage(new ItemStack((Item)ModItems.adventureBackpack), 0);
                recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 10), payment, this.backpack));
            }
            if (villager.func_70946_n() == 3) {
                payment = new ItemStack((Item)ModItems.adventureBackpack);
                BackpackNames.setBackpackColorName(payment, "IronGolem");
                recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 10), payment, this.backpack));
            }
        }
    }
}

