/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.init.BlocksItems;
import ic2.core.init.InternalName;
import ic2.core.item.block.ItemBlockIC2;
import ic2.core.util.LiquidUtil;
import ic2.core.util.StackUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class BlockIC2Fluid
extends BlockFluidClassic {
    protected IIcon[] fluidIcon;
    protected Fluid fluid;
    private final int color;

    public BlockIC2Fluid(InternalName internalName, Fluid fluid, Material material, int color) {
        super(fluid, material);
        if (!fluid.getName().startsWith("ic2")) {
            throw new RuntimeException("Invalid fluid name: " + fluid.getName());
        }
        this.func_149647_a(IC2.tabIC2);
        this.func_149663_c(internalName.name());
        GameRegistry.registerBlock((Block)this, ItemBlockIC2.class, (String)internalName.name());
        this.fluid = fluid;
        this.color = color;
        if (this.density <= FluidRegistry.WATER.getDensity()) {
            this.displacements.put(Blocks.field_150355_j, false);
            this.displacements.put(Blocks.field_150358_i, false);
        }
        if (this.density <= FluidRegistry.LAVA.getDensity()) {
            this.displacements.put(Blocks.field_150353_l, false);
            this.displacements.put(Blocks.field_150356_k, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        String name = this.fluidName.substring("ic2".length());
        this.fluidIcon = this.fluid.equals(BlocksItems.getFluid(InternalName.fluidPahoehoeLava)) || this.fluid.equals(BlocksItems.getFluid(InternalName.fluidBiogas)) || this.fluid.equals(BlocksItems.getFluid(InternalName.fluidSuperheatedSteam)) || this.fluid.equals(BlocksItems.getFluid(InternalName.fluidSteam)) ? new IIcon[]{iconRegister.func_94245_a(IC2.textureDomain + ":" + "fluids/" + name + "_still"), iconRegister.func_94245_a(IC2.textureDomain + ":" + "fluids/" + name + "_still")} : new IIcon[]{iconRegister.func_94245_a(IC2.textureDomain + ":" + "fluids/" + name + "_still"), iconRegister.func_94245_a(IC2.textureDomain + ":" + "fluids/" + name + "_flow")};
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        super.func_149674_a(world, x, y, z, random);
        if (IC2.platform.isSimulating()) {
            if (this.fluid.equals(BlocksItems.getFluid(InternalName.fluidPahoehoeLava))) {
                if (this.isSourceBlock((IBlockAccess)world, x, y, z) && world.func_72957_l(x, y, z) >= world.field_73012_v.nextInt(120)) {
                    world.func_147449_b(x, y, z, StackUtil.getBlock(Ic2Items.basaltBlock));
                } else if (!this.hardenFromNeighbors(world, x, y, z)) {
                    world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
                }
            } else if (this.fluid.equals(BlocksItems.getFluid(InternalName.fluidHotWater))) {
                if (this.isSourceBlock((IBlockAccess)world, x, y, z) && world.func_147439_a(x, y - 2, z) != Blocks.field_150356_k && world.func_147439_a(x, y - 1, z) != this && world.field_73012_v.nextInt(60) == 0) {
                    world.func_147465_d(x, y, z, (Block)Blocks.field_150358_i, 0, 3);
                } else {
                    world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
                }
            }
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        this.hardenFromNeighbors(world, x, y, z);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        this.hardenFromNeighbors(world, x, y, z);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack itemStack) {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        if (this.fluid.equals(BlocksItems.getFluid(InternalName.fluidBiogas))) {
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 7);
        }
    }

    public void func_149670_a(World world, int i, int j, int k, Entity entity) {
        int id;
        if (!IC2.platform.isSimulating()) {
            return;
        }
        if (this.fluid.equals(BlocksItems.getFluid(InternalName.fluidPahoehoeLava))) {
            entity.func_70015_d(10);
        }
        if (this.fluid.equals(BlocksItems.getFluid(InternalName.fluidHotCoolant))) {
            entity.func_70015_d(30);
        }
        if (entity instanceof EntityPlayer) {
            if (this.fluid.equals(BlocksItems.getFluid(InternalName.fluidConstructionFoam)) && !((EntityPlayer)entity).func_82165_m(Potion.field_76421_d.field_76415_H)) {
                ((EntityPlayer)entity).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 300, 2, true));
            }
            if (this.fluid.equals(BlocksItems.getFluid(InternalName.fluidUuMatter)) && !((EntityPlayer)entity).func_82165_m(Potion.field_76428_l.field_76415_H)) {
                ((EntityPlayer)entity).func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 100, 1, true));
            }
            if (this.fluid.equals(BlocksItems.getFluid(InternalName.fluidSteam)) || this.fluid.equals(BlocksItems.getFluid(InternalName.fluidSuperheatedSteam))) {
                ((EntityPlayer)entity).func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 300, 0, true));
            }
        }
        if (entity instanceof EntityLivingBase && this.fluid.equals(BlocksItems.getFluid(InternalName.fluidHotWater)) && !((EntityLivingBase)entity).func_82165_m(id = ((EntityLivingBase)entity).func_70662_br() ? Potion.field_82731_v.field_76415_H : Potion.field_76428_l.field_76415_H)) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(id, 100, IC2.random.nextInt(2), true));
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        return side != 0 && side != 1 ? this.fluidIcon[1] : this.fluidIcon[0];
    }

    public String func_149739_a() {
        return super.func_149739_a().substring(5);
    }

    public int getColor() {
        return this.color;
    }

    private boolean hardenFromNeighbors(World world, int x, int y, int z) {
        if (!IC2.platform.isSimulating()) {
            return false;
        }
        if (this.fluid.equals(BlocksItems.getFluid(InternalName.fluidPahoehoeLava))) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                LiquidUtil.LiquidData data = LiquidUtil.getLiquid(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
                if (data == null || data.liquid.getTemperature() > this.fluid.getTemperature() / 4) continue;
                if (this.isSourceBlock((IBlockAccess)world, x, y, z)) {
                    world.func_147449_b(x, y, z, StackUtil.getBlock(Ic2Items.basaltBlock));
                } else {
                    world.func_147468_f(x, y, z);
                }
                return true;
            }
        }
        return false;
    }
}

