/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.BlockMetaData;
import ic2.core.init.InternalName;
import ic2.core.item.block.ItemBlockIC2;
import ic2.core.util.StackUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockRubWood
extends BlockMetaData {
    private static final int textureIndexNormal = 0;
    private static final int textureIndexWet = 1;
    private static final int textureIndexDry = 2;

    public BlockRubWood(InternalName internalName1) {
        super(internalName1, Material.field_151575_d, ItemBlockIC2.class);
        this.func_149675_a(true);
        this.func_149711_c(1.0f);
        this.func_149672_a(field_149766_f);
        Ic2Items.rubberWood = new ItemStack((Block)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess iBlockAccess, int x, int y, int z, int side) {
        return super.func_149673_e(iBlockAccess, x, y, z, side);
    }

    @Override
    public String getTextureName(int index) {
        if (index == 0) {
            return this.func_149739_a();
        }
        if (index == 1) {
            return this.func_149739_a() + "." + InternalName.wet.name();
        }
        if (index == 2) {
            return this.func_149739_a() + "." + InternalName.dry.name();
        }
        return null;
    }

    @Override
    public int getTextureIndex(int meta) {
        if (meta % 6 >= 2) {
            if (meta >= 6) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public int getFacing(int meta) {
        int ret = meta % 6;
        return ret < 2 ? super.getFacing(meta) : ret;
    }

    public void func_149690_a(World world, int x, int y, int z, int meta, float chance, int fortune) {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        int count = this.func_149745_a(world.field_73012_v);
        for (int j1 = 0; j1 < count; ++j1) {
            if (world.field_73012_v.nextFloat() > chance) continue;
            Item item = this.func_149650_a(meta, world.field_73012_v, fortune);
            if (item != null) {
                this.func_149642_a(world, x, y, z, new ItemStack(item, 1, 0));
            }
            if (meta == 0 || world.field_73012_v.nextInt(6) != 0) continue;
            this.func_149642_a(world, x, y, z, new ItemStack(Ic2Items.resin.func_77973_b()));
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int b) {
        int range = 4;
        int l = range + 1;
        if (world.func_72904_c(x - l, y - l, z - l, x + l, y + l, z + l)) {
            for (int xOffset = -range; xOffset <= range; ++xOffset) {
                for (int yOffset = -range; yOffset <= range; ++yOffset) {
                    for (int zOffset = -range; zOffset <= range; ++zOffset) {
                        int meta;
                        Block neighbor = world.func_147439_a(x + xOffset, y + yOffset, z + zOffset);
                        if (!StackUtil.equals(neighbor, Ic2Items.rubberLeaves) || ((meta = world.func_72805_g(x + xOffset, y + yOffset, z + zOffset)) & 8) != 0) continue;
                        world.func_72921_c(x + xOffset, y + yOffset, z + zOffset, meta | 8, 3);
                    }
                }
            }
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (world.field_72995_K) {
            return;
        }
        int meta = world.func_72805_g(x, y, z);
        if (meta < 6) {
            return;
        }
        if (random.nextInt(200) == 0) {
            world.func_72921_c(x, y, z, meta % 6, 7);
        } else {
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
        }
    }

    public int func_149738_a(World world) {
        return 100;
    }

    public int func_149656_h() {
        return 2;
    }

    public boolean canSustainLeaves(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public boolean isWood(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 4;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 20;
    }
}

