/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.block.comp.Redstone;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.block.machine.container.ContainerMagnetizer;
import ic2.core.block.machine.gui.GuiMagnetizer;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.block.machine.tileentity.TileEntityStandardMachine;
import ic2.core.upgrade.IUpgradableBlock;
import ic2.core.upgrade.UpgradableProperty;
import ic2.core.util.StackUtil;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMagnetizer
extends TileEntityElectricMachine
implements IHasGui,
IUpgradableBlock {
    public InvSlotUpgrade upgradeSlot;
    private int ticker = IC2.random.nextInt(16);
    public static final int defaultMaxEnergy = 100;
    public static final int defaultTier = 1;
    protected final Redstone redstone;

    public TileEntityMagnetizer() {
        super(100, 1, 1);
        this.upgradeSlot = new InvSlotUpgrade(this, "upgrade", 3, 4);
        this.redstone = this.addComponent(new Redstone(this));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        try {
            this.energy = nbttagcompound.func_74769_h("energy");
        }
        catch (Exception e) {
            this.energy = nbttagcompound.func_74765_d("energy");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        if (IC2.platform.isSimulating()) {
            this.setOverclockRates();
        }
    }

    public void setOverclockRates() {
        this.upgradeSlot.onChanged();
        this.setTier(TileEntityStandardMachine.applyModifier(1, this.upgradeSlot.extraTier, 1.0));
        this.maxEnergy = TileEntityStandardMachine.applyModifier(100, this.upgradeSlot.extraEnergyStorage, this.upgradeSlot.energyStorageMultiplier);
    }

    @Override
    protected void updateEntityServer() {
        int need;
        int y;
        super.updateEntityServer();
        if (this.ticker++ % 16 != 0 || this.redstone.hasRedstoneInput()) {
            return;
        }
        Direction dir = Direction.fromSideValue(this.getFacing());
        int x = this.field_145851_c + dir.xOffset;
        int z = this.field_145849_e + dir.zOffset;
        double multiplier = (double)(1 + this.upgradeSlot.extraEnergyDemand) * this.upgradeSlot.energyDemandMultiplier;
        for (y = this.field_145848_d; y > 0 && y >= this.field_145848_d - this.distance() && !(this.energy < multiplier) && StackUtil.equals(this.field_145850_b.func_147439_a(x, y, z), Ic2Items.ironFence); --y) {
            need = 15 - this.field_145850_b.func_72805_g(x, y, z);
            if (need <= 0) continue;
            if ((double)need * multiplier > this.energy) {
                need = MathHelper.func_76128_c((double)(this.energy / multiplier));
            }
            this.field_145850_b.func_72921_c(x, y, z, this.field_145850_b.func_72805_g(x, y, z) + need, 7);
            this.energy -= (double)need * multiplier;
        }
        for (y = this.field_145848_d; y < IC2.getWorldHeight(this.field_145850_b) && y <= this.field_145848_d + this.distance() && !(this.energy < multiplier) && StackUtil.equals(this.field_145850_b.func_147439_a(x, y, z), Ic2Items.ironFence); ++y) {
            need = 15 - this.field_145850_b.func_72805_g(x, y, z);
            if (need <= 0) continue;
            if ((double)need * multiplier > this.energy) {
                need = MathHelper.func_76128_c((double)(this.energy / multiplier));
            }
            this.field_145850_b.func_72921_c(x, y, z, this.field_145850_b.func_72805_g(x, y, z) + need, 7);
            this.energy -= (double)need * multiplier;
        }
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return direction.ordinal() != this.getFacing();
    }

    @Override
    public String func_145825_b() {
        return "Magnetizer";
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != side && side != 0 && side != 1;
    }

    private int distance() {
        return 20 + this.upgradeSlot.augmentation;
    }

    @Override
    public ContainerBase<?> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerMagnetizer(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiMagnetizer(new ContainerMagnetizer(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public boolean useEnergy(double amount) {
        if (this.energy >= amount) {
            this.energy -= amount;
            return true;
        }
        return false;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Augmentable, UpgradableProperty.RedstoneSensitive, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage);
    }
}

