/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.PositionSpec;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableLinked;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.personal.ContainerTradeOMatClosed;
import ic2.core.block.personal.ContainerTradeOMatOpen;
import ic2.core.block.personal.GuiTradeOMatClosed;
import ic2.core.block.personal.GuiTradeOMatOpen;
import ic2.core.block.personal.IPersonalBlock;
import ic2.core.util.LogCategory;
import ic2.core.util.StackUtil;
import java.util.List;
import java.util.Vector;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;

public class TileEntityTradeOMat
extends TileEntityInventory
implements IPersonalBlock,
IHasGui,
INetworkTileEntityEventListener,
INetworkClientTileEntityEventListener {
    private int ticker = IC2.random.nextInt(64);
    private GameProfile owner = null;
    public int totalTradeCount = 0;
    public int stock = 0;
    public boolean infinite = false;
    private static final int stockUpdateRate = 64;
    private static final int EventTrade = 0;
    public final InvSlot demandSlot = new InvSlot(this, "demand", 0, InvSlot.Access.NONE, 1);
    public final InvSlot offerSlot = new InvSlot(this, "offer", 1, InvSlot.Access.NONE, 1);
    public final InvSlotConsumableLinked inputSlot = new InvSlotConsumableLinked((TileEntityInventory)this, "input", 2, 1, this.demandSlot);
    public final InvSlotOutput outputSlot = new InvSlotOutput(this, "output", 3, 1);

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("ownerGameProfile")) {
            this.owner = NBTUtil.func_152459_a((NBTTagCompound)nbt.func_74775_l("ownerGameProfile"));
        }
        this.totalTradeCount = nbt.func_74762_e("totalTradeCount");
        if (nbt.func_74764_b("infinite")) {
            this.infinite = nbt.func_74767_n("infinite");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.owner != null) {
            NBTTagCompound ownerNbt = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)ownerNbt, (GameProfile)this.owner);
            nbt.func_74782_a("ownerGameProfile", (NBTBase)ownerNbt);
        }
        nbt.func_74768_a("totalTradeCount", this.totalTradeCount);
        if (this.infinite) {
            nbt.func_74757_a("infinite", this.infinite);
        }
    }

    @Override
    public List<String> getNetworkedFields() {
        Vector<String> ret = new Vector<String>(1);
        ret.add("owner");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    @Override
    protected void updateEntityServer() {
        super.updateEntityServer();
        this.trade();
        if (this.infinite) {
            this.stock = -1;
        } else if (this.ticker++ % 64 == 0) {
            this.updateStock();
        }
    }

    private void trade() {
        ItemStack tradedIn = this.inputSlot.consumeLinked(true);
        if (tradedIn == null || tradedIn.field_77994_a <= 0) {
            return;
        }
        ItemStack offer = this.offerSlot.get();
        if (offer == null || offer.field_77994_a <= 0) {
            return;
        }
        if (!this.outputSlot.canAdd(offer)) {
            return;
        }
        if (this.infinite) {
            this.inputSlot.consumeLinked(false);
            this.outputSlot.add(offer);
        } else {
            ItemStack transferredIn = StackUtil.fetch(this, offer, true);
            if (transferredIn == null || transferredIn.field_77994_a != offer.field_77994_a) {
                return;
            }
            int transferredOut = StackUtil.distribute(this, tradedIn, true);
            if (transferredOut != tradedIn.field_77994_a) {
                return;
            }
            transferredIn = StackUtil.fetch(this, offer, false);
            if (transferredIn == null) {
                return;
            }
            if (transferredIn.field_77994_a != offer.field_77994_a) {
                IC2.log.warn(LogCategory.Block, "The Trade-O-Mat at dim %d, %d/%d/%d received an inconsistent result from an adjacent trade supply inventory, the item stack %s will be lost.", this.func_145831_w().field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e, transferredIn);
                return;
            }
            StackUtil.distribute(this, this.inputSlot.consumeLinked(false), false);
            this.outputSlot.add(transferredIn);
            this.stock -= offer.field_77994_a;
        }
        ++this.totalTradeCount;
        IC2.network.get().initiateTileEntityEvent(this, 0, true);
        this.func_70296_d();
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            this.updateStock();
        }
    }

    public void updateStock() {
        this.stock = 0;
        ItemStack offer = this.offerSlot.get();
        if (offer != null) {
            ItemStack available = StackUtil.fetch(this, StackUtil.copyWithSize(offer, Integer.MAX_VALUE), true);
            this.stock = available == null ? 0 : available.field_77994_a;
        }
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return this.permitsAccess(entityPlayer.func_146103_bH());
    }

    @Override
    public boolean permitsAccess(GameProfile profile) {
        if (profile == null) {
            return this.owner == null;
        }
        if (IC2.platform.isSimulating()) {
            if (this.owner == null) {
                this.owner = profile;
                IC2.network.get().updateTileEntityField(this, "owner");
                return true;
            }
            if (MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(profile)) {
                return true;
            }
        } else if (this.owner == null) {
            return true;
        }
        return this.owner.equals((Object)profile);
    }

    @Override
    public GameProfile getOwner() {
        return this.owner;
    }

    @Override
    public String func_145825_b() {
        return "Trade-O-Mat";
    }

    public ContainerBase<TileEntityTradeOMat> getGuiContainer(EntityPlayer entityPlayer) {
        if (this.permitsAccess(entityPlayer.func_146103_bH())) {
            return new ContainerTradeOMatOpen(entityPlayer, this);
        }
        return new ContainerTradeOMatClosed(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        if (this.permitsAccess(entityPlayer.func_146103_bH())) {
            return new GuiTradeOMatOpen(new ContainerTradeOMatOpen(entityPlayer, this), isAdmin);
        }
        return new GuiTradeOMatClosed(new ContainerTradeOMatClosed(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public void onNetworkEvent(int event) {
        switch (event) {
            case 0: {
                IC2.audioManager.playOnce(this, PositionSpec.Center, "Machines/o-mat.ogg", true, IC2.audioManager.getDefaultVolume());
                break;
            }
            default: {
                IC2.platform.displayError("An unknown event type was received over multiplayer.\nThis could happen due to corrupted data or a bug.\n\n(Technical information: event ID " + event + ", tile entity below)\n" + "T: " + this + " (" + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e + ")", new Object[0]);
            }
        }
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        MinecraftServer server;
        if (event == 0 && (server = MinecraftServer.func_71276_C()).func_71203_ab().func_152596_g(player.func_146103_bH())) {
            boolean bl = this.infinite = !this.infinite;
            if (!this.infinite) {
                this.updateStock();
            }
        }
    }
}

