/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.chesttransporter;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cubex2.mods.chesttransporter.ChestRegistry;
import cubex2.mods.chesttransporter.ChestTransporter;
import cubex2.mods.chesttransporter.TransportableChest;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class ItemChestTransporter
extends Item {
    @SideOnly(value=Side.CLIENT)
    public IIcon handleIcon;
    private final String iconName;

    protected ItemChestTransporter(int maxDamage, String iconName) {
        this.iconName = iconName;
        this.func_77655_b("chesttransporter_" + iconName);
        this.func_77625_d(1);
        this.func_77656_e(maxDamage);
        this.func_77637_a(CreativeTabs.field_78040_i);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            ItemStack stack = event.entityPlayer.func_71045_bC();
            if (stack == null || stack.func_77973_b() != this) {
                return;
            }
            EntityPlayer player = event.entityPlayer;
            World world = event.entityPlayer.field_70170_p;
            int x = event.x;
            int y = event.y;
            int z = event.z;
            int face = event.face;
            byte chestType = this.getTagCompound(stack).func_74771_c("ChestType");
            if (chestType == 0 && this.isChestAt(world, x, y, z)) {
                this.grabChest(stack, world, x, y, z);
            } else if (chestType != 0) {
                this.placeChest(stack, player, world, x, y, z, face);
            }
        }
    }

    private void grabChest(ItemStack stack, World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null) {
            int metadata;
            Block chestBlock = world.func_147439_a(x, y, z);
            int newChestType = this.getChestType(chestBlock, metadata = world.func_72805_g(x, y, z));
            if (newChestType == 0) {
                return;
            }
            TransportableChest tChest = ChestRegistry.getChest(chestBlock, metadata);
            if (tChest == null || !tChest.isUsableWith(stack)) {
                return;
            }
            this.getTagCompound(stack).func_74774_a("ChestType", (byte)newChestType);
            if (tChest.copyTileEntity()) {
                NBTTagCompound nbt = new NBTTagCompound();
                tile.func_145841_b(nbt);
                this.getTagCompound(stack).func_74782_a("ChestTile", (NBTBase)nbt);
                world.func_147475_p(x, y, z);
            } else {
                IInventory chest = (IInventory)tile;
                this.moveItemsIntoStack(chest, stack);
            }
            tChest.preRemoveChest(stack, tile);
            world.func_147468_f(x, y, z);
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), chestBlock.field_149762_H.func_150495_a(), (chestBlock.field_149762_H.func_150497_c() + 1.0f) / 2.0f, chestBlock.field_149762_H.func_150494_d() * 0.5f);
        }
    }

    private void placeChest(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int face) {
        byte chestType = this.getTagCompound(stack).func_74771_c("ChestType");
        if (!ChestRegistry.dvToChest.containsKey(chestType)) {
            return;
        }
        int[] chestCoords = this.getChestCoords(world, x, y, z, face);
        ItemStack chestStack = this.getStackFromDamage(chestType);
        if (!chestStack.func_77943_a(player, world, x, y, z, face, 0.0f, 0.0f, 0.0f)) {
            return;
        }
        if (chestCoords != null) {
            int meta;
            int x1 = chestCoords[0];
            int y1 = chestCoords[1];
            int z1 = chestCoords[2];
            Block block = world.func_147439_a(x1, y1, z1);
            TransportableChest tChest = ChestRegistry.getChest(block, meta = world.func_72805_g(x1, y1, z1));
            if (tChest == null || !tChest.isUsableWith(stack)) {
                return;
            }
            TileEntity tile = world.func_147438_o(x1, y1, z1);
            if (tChest.copyTileEntity()) {
                NBTTagCompound nbt = this.getTagCompound(stack).func_74775_l("ChestTile");
                world.func_147455_a(x, y, z, TileEntity.func_145827_c((NBTTagCompound)nbt));
            } else {
                IInventory chest = (IInventory)tile;
                this.moveItemsIntoChest(stack, chest);
            }
            this.getTagCompound(stack).func_74774_a("ChestType", (byte)0);
            tChest.preDestroyTransporter(stack, tile);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_77972_a(1, (EntityLivingBase)player);
                if (this == ChestTransporter.chestTransporter) {
                    stack.func_77972_a(1, (EntityLivingBase)player);
                }
            }
        }
    }

    private int[] getChestCoords(World world, int x, int y, int z, int facing) {
        Block block = world.func_147439_a(x, y, z);
        if (!(block == Blocks.field_150431_aC && (world.func_72805_g(x, y, z) & 7) < 1 || block == Blocks.field_150395_bd || block == Blocks.field_150329_H || block == Blocks.field_150330_I || block != null && block.isReplaceable((IBlockAccess)world, x, y, z))) {
            if (facing == 0) {
                --y;
            }
            if (facing == 1) {
                ++y;
            }
            if (facing == 2) {
                --z;
            }
            if (facing == 3) {
                ++z;
            }
            if (facing == 4) {
                --x;
            }
            if (facing == 5) {
                // empty if block
            }
        }
        return new int[]{++x, y, z};
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean par5) {
        byte chestType = this.getTagCompound(stack).func_74771_c("ChestType");
        if (chestType != 0 && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (player.field_71075_bZ.field_75098_d) {
                return;
            }
            if (player.func_70660_b(Potion.field_76421_d) == null || player.func_70660_b(Potion.field_76421_d).func_76459_b() < 20) {
                player.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 60, 2));
            }
            if (player.func_70660_b(Potion.field_76419_f) == null || player.func_70660_b(Potion.field_76419_f).func_76459_b() < 20) {
                player.func_70690_d(new PotionEffect(Potion.field_76419_f.func_76396_c(), 60, 3));
            }
            if (player.func_70660_b(Potion.field_76430_j) == null || player.func_70660_b(Potion.field_76430_j).func_76459_b() < 20) {
                player.func_70690_d(new PotionEffect(Potion.field_76430_j.func_76396_c(), 60, -2));
            }
            if (player.func_70660_b(Potion.field_76438_s) == null || player.func_70660_b(Potion.field_76438_s).func_76459_b() < 20) {
                player.func_70690_d(new PotionEffect(Potion.field_76438_s.func_76396_c(), 60, 0));
            }
        }
    }

    @SubscribeEvent
    public void entityInteract(EntityInteractEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!(event.target instanceof EntityMinecart)) {
            return;
        }
        ItemStack stack = event.entityPlayer.func_71045_bC();
        EntityMinecart minecart = (EntityMinecart)event.target;
        if (stack == null || stack.func_77973_b() != this || minecart == null) {
            return;
        }
        byte chestType = this.getTagCompound(stack).func_74771_c("ChestType");
        EntityPlayer player = event.entityPlayer;
        if (minecart instanceof EntityMinecartEmpty && minecart.field_70153_n == null && ChestRegistry.isMinecartChest(chestType)) {
            EntityMinecart newMinecart = ChestRegistry.createMinecart(minecart.field_70170_p, chestType);
            if (!player.field_70170_p.field_72995_K) {
                this.replaceMinecart(minecart, newMinecart);
            }
            this.moveItemsIntoChest(stack, (IInventory)newMinecart);
            this.getTagCompound(stack).func_74774_a("ChestType", (byte)0);
            minecart.field_70170_p.func_72908_a((double)((float)minecart.field_70165_t + 0.5f), (double)((float)minecart.field_70163_u + 0.5f), (double)((float)minecart.field_70161_v + 0.5f), Blocks.field_150486_ae.field_149762_H.func_150495_a(), (Blocks.field_150486_ae.field_149762_H.func_150497_c() + 1.0f) / 2.0f, Blocks.field_150486_ae.field_149762_H.func_150494_d() * 0.8f);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_77972_a(1, (EntityLivingBase)player);
                if (this == ChestTransporter.chestTransporter) {
                    stack.func_77972_a(1, (EntityLivingBase)player);
                }
            }
            event.setCanceled(true);
        } else if (ChestRegistry.isSupportedMinecart(minecart) && chestType == 0) {
            this.moveItemsIntoStack((IInventory)minecart, stack);
            this.getTagCompound(stack).func_74774_a("ChestType", (byte)ChestRegistry.getChestType(minecart));
            minecart.field_70170_p.func_72908_a((double)((float)minecart.field_70165_t + 0.5f), (double)((float)minecart.field_70163_u + 0.5f), (double)((float)minecart.field_70161_v + 0.5f), Blocks.field_150486_ae.field_149762_H.func_150495_a(), (Blocks.field_150486_ae.field_149762_H.func_150497_c() + 1.0f) / 2.0f, Blocks.field_150486_ae.field_149762_H.func_150494_d() * 0.5f);
            if (!player.field_70170_p.field_72995_K) {
                EntityMinecartEmpty newMinecart = new EntityMinecartEmpty(minecart.field_70170_p);
                this.replaceMinecart(minecart, (EntityMinecart)newMinecart);
            }
            event.setCanceled(true);
        }
    }

    private void replaceMinecart(EntityMinecart old, EntityMinecart now) {
        now.func_70107_b(old.field_70165_t, old.field_70163_u, old.field_70161_v);
        now.func_70082_c(old.field_70125_A, old.field_70177_z);
        old.field_70170_p.func_72838_d((Entity)now);
        old.func_70106_y();
    }

    public boolean func_77651_p() {
        return true;
    }

    public IIcon func_77617_a(int i) {
        return this.handleIcon;
    }

    public IIcon func_77650_f(ItemStack stack) {
        byte chestType = this.getTagCompound(stack).func_74771_c("ChestType");
        if (chestType == 0) {
            return this.handleIcon;
        }
        return ChestRegistry.dvToChest.get(chestType).getIcon(stack);
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        if (pass == 0) {
            return this.handleIcon;
        }
        return this.func_77650_f(stack);
    }

    public boolean func_77623_v() {
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean flag) {
        byte chestType = this.getTagCompound(stack).func_74771_c("ChestType");
        if (chestType != 0) {
            int numItems = 0;
            NBTTagList nbtList = stack.field_77990_d.func_150295_c("Items", 10);
            for (int i = 0; i < nbtList.func_74745_c(); ++i) {
                ItemStack itemstack;
                NBTTagCompound nbtTagCompound = nbtList.func_150305_b(i);
                NBTBase nbt = nbtTagCompound.func_74781_a("Slot");
                int j = nbt instanceof NBTTagByte ? nbtTagCompound.func_74771_c("Slot") & 0xFF : nbtTagCompound.func_74765_d("Slot");
                if (j < 0 || (itemstack = ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound)) == null) continue;
                numItems += itemstack.field_77994_a;
            }
            list.add("Contains " + numItems + " items");
        }
    }

    private boolean isChestAt(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        return ChestRegistry.isChest(block, meta);
    }

    private int getChestType(Block block, int metadata) {
        TransportableChest chest = ChestRegistry.getChest(block, metadata);
        return chest != null ? chest.getTransporterDV() : 0;
    }

    private ItemStack getStackFromDamage(int damage) {
        return ChestRegistry.dvToChest.containsKey(damage) ? ChestRegistry.dvToChest.get(damage).createChestStack() : null;
    }

    private void moveItemsIntoStack(IInventory chest, ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagList nbtList = new NBTTagList();
        for (int i = 0; i < chest.func_70302_i_(); ++i) {
            if (chest.func_70301_a(i) == null) continue;
            NBTTagCompound nbtTabCompound2 = new NBTTagCompound();
            nbtTabCompound2.func_74777_a("Slot", (short)i);
            chest.func_70301_a(i).func_77946_l().func_77955_b(nbtTabCompound2);
            chest.func_70299_a(i, null);
            nbtList.func_74742_a((NBTBase)nbtTabCompound2);
        }
        stack.field_77990_d.func_74782_a("Items", (NBTBase)nbtList);
    }

    private void moveItemsIntoChest(ItemStack stack, IInventory chest) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagList nbtList = stack.field_77990_d.func_150295_c("Items", 10);
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = nbtList.func_150305_b(i);
            NBTBase nbt = nbtTagCompound.func_74781_a("Slot");
            int j = nbt instanceof NBTTagByte ? nbtTagCompound.func_74771_c("Slot") & 0xFF : nbtTagCompound.func_74765_d("Slot");
            if (j < 0 || j >= chest.func_70302_i_()) continue;
            chest.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound).func_77946_l());
        }
        stack.field_77990_d.func_82580_o("Items");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.handleIcon = iconRegister.func_94245_a("chesttransporter:ct_" + this.iconName);
        for (TransportableChest chest : ChestRegistry.chests) {
            chest.registerIcon(iconRegister);
        }
    }

    private NBTTagCompound getTagCompound(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }
}

