/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.wings;

import com.spacechase0.minecraft.spacecore.BaseMod;
import com.spacechase0.minecraft.wings.CommonProxy;
import com.spacechase0.minecraft.wings.FastWingsRecipe;
import com.spacechase0.minecraft.wings.WingsUpdater;
import com.spacechase0.minecraft.wings.item.Items;
import com.spacechase0.minecraft.wings.item.WingsItem;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="SC0_Wings", useMetadata=true, dependencies="required-after:SC0_SpaceCore")
public class Wings
extends BaseMod {
    @Mod.Instance(value="SC0_Wings")
    public static Wings instance;
    @SidedProxy(clientSide="com.spacechase0.minecraft.wings.client.ClientProxy", serverSide="com.spacechase0.minecraft.wings.CommonProxy")
    public static CommonProxy proxy;
    public Configuration config;
    public static Items items;
    private final int DEFAULT_DURABILITY_MULT = 50;

    public Wings() {
        super("wings");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        super.init(event);
        this.addRecipes();
        this.addTickers();
    }

    public boolean degradeWingsByFlying() {
        return this.config.get("misc", "useDegradingWings", true).getBoolean(true);
    }

    public int getDurabilityFactor() {
        return this.config.get("general", "durabilityMult", 50).getInt();
    }

    private void addRecipes() {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Wings.items.featherWings), (Object[])new Object[]{"## ", "###", " ##", Character.valueOf('#'), net.minecraft.init.Items.field_151008_G});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Wings.items.obsidianWings), (Object[])new Object[]{"## ", "###", " ##", Character.valueOf('#'), Blocks.field_150343_Z});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)Wings.items.sturdyWings), (Object[])new Object[]{new ItemStack((Item)Wings.items.featherWings), new ItemStack((Item)Wings.items.obsidianWings), new ItemStack(net.minecraft.init.Items.field_151075_bm)});
        GameRegistry.addRecipe((IRecipe)new FastWingsRecipe());
    }

    private void addTickers() {
        FMLCommonHandler.instance().bus().register((Object)new WingsUpdater());
    }

    public static boolean isPairOfWings(Item item) {
        return item instanceof WingsItem;
    }

    public static float getWingSpeed(Item item) {
        float base = 0.05f;
        if (item == Wings.items.obsidianWings) {
            base = 0.02f;
        } else if (item == Wings.items.fastWings) {
            base = 0.08f;
        }
        return base;
    }
}

