/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.wings.client;

import java.util.Random;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;

public class WingsModel
extends ModelBiped {
    private final EntityPlayer player;
    private ModelRenderer leftWing;
    private ModelRenderer rightWing;
    private Random soundRand = new Random();
    private float rot = 0.0f;
    private boolean outwards = true;
    private static final float INCR = 0.052500002f;
    private static final float MIN = 0.2f;
    private static final float MAX = 1.35f;

    public WingsModel(EntityLivingBase entity) {
        this.player = (EntityPlayer)entity;
        this.leftWing = new ModelRenderer((ModelBase)this, 0, 0);
        this.leftWing.func_78790_a(0.0f, -1.0f, 0.0f, 0, 13, 12, 0.0f);
        this.leftWing.func_78793_a(0.0f, 0.0f, 2.0f);
        this.leftWing.field_78796_g = 0.2f;
        this.rightWing = new ModelRenderer((ModelBase)this, 0, 0);
        this.rightWing.func_78790_a(0.0f, -1.0f, 0.0f, 0, 13, 12, 0.0f);
        this.rightWing.func_78793_a(0.0f, 0.0f, 2.0f);
        this.rightWing.field_78796_g = 0.2f;
        this.rightWing.field_78809_i = true;
    }

    public void func_78088_a(Entity entity, float par2, float par3, float par4, float par5, float par6, float par7) {
        if (this.player.field_71075_bZ.field_75100_b) {
            this.updateRotation();
        }
        this.leftWing.func_78785_a(par7);
        this.rightWing.func_78785_a(par7);
    }

    private void updateRotation() {
        float totalMotion = (float)(Math.abs(this.player.field_70159_w) + Math.abs(this.player.field_70181_x) + Math.abs(this.player.field_70179_y));
        float incr = this.outwards ? 0.052500002f : -0.052500002f;
        float amt = incr * totalMotion * 5.0f;
        this.rot += incr > 0.0f ? Math.max(incr, amt) : Math.min(incr, amt);
        if (this.rot <= 0.2f) {
            this.outwards = true;
            this.player.field_70170_p.func_72980_b(this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, "mob.enderdragon.wings", 0.25f, 1.5f + this.soundRand.nextFloat() * 0.5f, true);
        } else if (this.rot >= 1.35f) {
            this.outwards = false;
        }
        this.leftWing.field_78796_g = this.rot;
        this.rightWing.field_78796_g = -this.rot;
    }
}

