/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.wings.item;

import com.spacechase0.minecraft.wings.Wings;
import com.spacechase0.minecraft.wings.client.WingsModel;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;

public class WingsItem
extends ItemArmor {
    private static final ItemArmor.ArmorMaterial featherMaterial;
    private static final ItemArmor.ArmorMaterial obsidianMaterial;
    private static final ItemArmor.ArmorMaterial sturdyMaterial;
    private static final ItemArmor.ArmorMaterial fastMaterial;
    private final boolean shine;
    private static int ticks;
    private static Map<EntityLivingBase, WingsModel> wingModels;

    public WingsItem(String name, boolean theShine) {
        super(WingsItem.getMaterialFor(name), 0, 1);
        this.shine = theShine;
        this.func_77655_b(name + "Wings");
        this.field_77777_bU = 1;
    }

    public void func_94581_a(IIconRegister ir) {
        this.field_77791_bV = ir.func_94245_a("wings:" + this.func_77658_a().substring(5));
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (!Wings.instance.degradeWingsByFlying() || world.field_72995_K) {
            return;
        }
        if (player.field_71071_by.field_70460_b[2] != stack || !player.field_71075_bZ.field_75100_b) {
            return;
        }
        if (++ticks >= 20) {
            int y;
            Block block;
            int iy;
            ticks -= 20;
            for (iy = y = (int)player.field_70163_u; iy >= 0 && !(block = world.func_147439_a((int)player.field_70165_t, iy, (int)player.field_70161_v)).func_149688_o().func_76220_a(); --iy) {
            }
            int dmg = (int)Math.ceil((float)(y - iy) / 1.7f);
            stack.func_77972_a(dmg, (EntityLivingBase)player);
            if (player.field_71071_by.field_70460_b[2].field_77994_a == 0) {
                player.field_71071_by.field_70460_b[2] = null;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        return this.shine || super.hasEffect(stack, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        if (Wings.items.fastWings == this) {
            return EnumRarity.epic;
        }
        if (Wings.items.sturdyWings == this) {
            return EnumRarity.rare;
        }
        if (Wings.items.obsidianWings == this) {
            return EnumRarity.uncommon;
        }
        return EnumRarity.common;
    }

    private static ItemArmor.ArmorMaterial getMaterialFor(String name) {
        if (name.equals("feather")) {
            return featherMaterial;
        }
        if (name.equals("obsidian")) {
            return obsidianMaterial;
        }
        if (name.equals("sturdy")) {
            return sturdyMaterial;
        }
        if (name.equals("fast")) {
            return fastMaterial;
        }
        return null;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (this == Wings.items.obsidianWings) {
            return "wings:textures/models/armor/wings-obsidian.png";
        }
        return "wings:textures/models/armor/wings-normal.png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entity, ItemStack stack, int slot) {
        if (slot != 1) {
            return null;
        }
        WingsModel model = wingModels.get(entity);
        if (model == null) {
            wingModels.put(entity, new WingsModel(entity));
            return this.getArmorModel(entity, stack, slot);
        }
        return model;
    }

    static {
        wingModels = new HashMap<EntityLivingBase, WingsModel>();
        featherMaterial = EnumHelper.addArmorMaterial((String)"wingsFeather", (int)1, (int[])new int[]{1, 1, 1, 1}, (int)5);
        WingsItem.featherMaterial.customCraftingMaterial = Items.field_151008_G;
        obsidianMaterial = EnumHelper.addArmorMaterial((String)"wingsObsidian", (int)1, (int[])new int[]{3, 3, 3, 3}, (int)15);
        WingsItem.obsidianMaterial.customCraftingMaterial = Item.func_150898_a((Block)Blocks.field_150343_Z);
        sturdyMaterial = EnumHelper.addArmorMaterial((String)"wingsSturdy", (int)1, (int[])new int[]{2, 2, 2, 2}, (int)13);
        WingsItem.sturdyMaterial.customCraftingMaterial = Items.field_151075_bm;
        fastMaterial = EnumHelper.addArmorMaterial((String)"wingsFast", (int)1, (int[])new int[]{1, 1, 1, 1}, (int)10);
        WingsItem.fastMaterial.customCraftingMaterial = Items.field_151061_bv;
    }
}

