/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons;

import jaredbgreat.dldungeons.Difficulty;
import jaredbgreat.dldungeons.GenerationHandler;
import jaredbgreat.dldungeons.builder.Builder;
import jaredbgreat.dldungeons.pieces.chests.BasicChest;
import jaredbgreat.dldungeons.pieces.chests.TreasureChest;
import jaredbgreat.dldungeons.planner.mapping.MapMatrix;
import jaredbgreat.dldungeons.rooms.Room;
import jaredbgreat.dldungeons.setup.Externalizer;
import jaredbgreat.dldungeons.themes.ThemeReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;

public final class ConfigHandler {
    private static File mainConfig;
    private static File themesDir;
    private static File listsDir;
    protected static File configDir;
    private static final int DEFAULT_SCALE = 8;
    private static final int DEFAULT_MINXZ = 16;
    private static final int DEFAULT_DIF = 3;
    private static final int[] DEFAULT_DIMS;
    private static final boolean DEFAULT_WRITE_LISTS = false;
    private static final boolean DEFAULT_NATURAL_SPAWN = true;
    private static final boolean DEFAULT_OBEY_RULE = true;
    private static final boolean DEFAULT_POSITIVE_DIMS = true;
    private static final boolean DEFAULT_ANNOUNCE_COMMANDS = true;
    private static final boolean DEFAULT_THIN_SPAWNERS = true;
    private static final boolean DEFAULT_VANILLA_LOOT = false;
    private static final boolean DEFAULT_STINGY_LOOT = false;
    private static final boolean EASY_FIND = false;
    private static final boolean DISABLE_API = false;
    private static final boolean NO_MOB_CHANGES = false;
    public static boolean disableAPI;
    public static boolean noMobChanges;
    private static final String[] NEVER_IN_BIOMES;
    private static String[] neverInBiomes;
    public static HashSet<BiomeDictionary.Type> biomeExclusions;
    protected static boolean writeLists;
    protected static boolean naturalSpawn;
    protected static boolean obeyRule;
    protected static boolean positiveDims;
    public static boolean easyFind;
    public static boolean announceCommands;
    public static boolean vanillaLoot;
    public static boolean stingyLoot;
    public static boolean thinSpawners;
    private static final boolean PROFILE = false;
    protected static boolean profile;
    private static final boolean INSTALL_THEMES = true;
    public static boolean installThemes;
    private static final boolean INSTALL_CMD = true;
    public static boolean installCmd;
    public static Difficulty difficulty;

    private ConfigHandler() {
    }

    public static void init() {
        int i;
        File file = new File(configDir.toString() + File.separator + "DLDungeonsJBG" + ".cfg");
        Configuration config = new Configuration(file);
        config.load();
        int freqScale = config.get("General", "FrequencyScale", 8, "Determines the average distance between dungeons (+2 is twice as far appart)").getInt();
        if (freqScale > 30 || freqScale < 4) {
            freqScale = 8;
        }
        GenerationHandler.setFrequency(freqScale);
        System.out.println("[DLDUNGEONS] Frequency Scaling Factor Set To: " + freqScale);
        int minXZ = config.get("General", "MinChunkXY", 16, "Spawn protection: this is the minimum number of chunks from spawn before dungeon generate").getInt();
        if (minXZ < 0) {
            minXZ = 16;
        }
        GenerationHandler.setMinXZ(minXZ);
        System.out.println("[DLDUNGEONS] Minimum X Factor Set To: " + minXZ);
        int diff = config.get("General", "Difficulty", 3, "How hard: 0 = empty, 1 = baby, 2 = easy, 3 = normal, 4= hard, 5 = nightmare").getInt();
        if (diff < 0 || diff > 5) {
            diff = 3;
        }
        ConfigHandler.parseDiff(diff);
        System.out.println("[DLDUNGEONS] Difficulty set to: " + ConfigHandler.difficulty.label);
        int[] dims = config.get("General", "Dimensions", DEFAULT_DIMS, "These dimensions either lack dungeons or only they have them (see OnlySpawnInListedDimensions)").getIntList();
        GenerationHandler.setDimensions(dims);
        System.out.print("[DLDUNGEONS] Dimensions listed in config file: ");
        for (i = 0; i < dims.length; ++i) {
            System.out.print(dims[i] + ", ");
        }
        System.out.println();
        naturalSpawn = config.get("General", "SpawnWithWordgen", true, "True to have dungeons generate naturally, false otherwise.").getBoolean(true);
        System.out.println("[DLDUNGEONS] Will spawn dungeons in with world generation? " + naturalSpawn);
        obeyRule = config.get("General", "ObeyFeatureSpawningRule", true, "If true worlds that are set to not generate (vanilla) structures will also not have these dungesons").getBoolean(true);
        System.out.println("[DLDUNGEONS] Will spawn dungeons even with structures disabled? " + !obeyRule);
        positiveDims = config.get("General", "OnlySpawnInListedDims", true, "Determines if the dimesions list is black list of white list; " + System.lineSeparator() + "if true only listed dimensions have dungeons, " + System.lineSeparator() + "otherswise all but those will have them").getBoolean(true);
        if (positiveDims) {
            System.out.print("[DLDUNGEONS] Will only spawn in these dimensions: ");
        } else {
            System.out.print("[DLDUNGEONS] Will never spawn in these dimensions: ");
        }
        for (i = 0; i < dims.length; ++i) {
            System.out.print(dims[i] + ", ");
        }
        System.out.println();
        writeLists = config.get("General", "ExportLists", false, "If true a \"lists\" folder will be created and files showing names and ideas for all " + System.lineSeparator() + "mobs / items / blocks will be made.  This is good for editing " + System.lineSeparator() + "themes.").getBoolean(false);
        System.out.println("[DLDUNGEONS] Will export item, block, and mob lists? " + writeLists);
        announceCommands = config.get("General", "AnnounceCommands", true, "If true, console commands from the mod will be annouced in chat").getBoolean(true);
        System.out.println("[DLDUNGEONS] Will announce use of OP/cheat commands? " + announceCommands);
        easyFind = config.get("General", "EasyFind", false, "If true dungeons will all have an entrance with a room or ruin, unless the theme " + System.lineSeparator() + "is one that never has entrances.").getBoolean(false);
        System.out.println("[DLDUNGEONS] Will dungeons be easy to find? " + easyFind);
        installThemes = config.get("General", "InstallThemes", true, "If true themes will automaticall be (re)installed if the themes folder is empty.").getBoolean(true);
        System.out.println("[DLDUNGEONS] Will themes be automatically install if themes folder is empty? " + installThemes);
        installCmd = config.get("General", "InstallThemesByCommand", true, "If true themes can be (re)installed by the console commands \"\\dldInstallThemes\" " + System.lineSeparator() + "and \"\\dldForceInstallThemes.\"").getBoolean(true);
        System.out.println("[DLDUNGEONS] Can themes be (re)installed by command? " + installCmd);
        System.out.println("[DLDUNGEONS] Will be stingy with chests? " + stingyLoot);
        thinSpawners = config.get("General", "ThinSpawners", true, "If true smaller dungeons will have some of there spawners removed to make them more like larger dungeons.").getBoolean(true);
        System.out.println("[DLDUNGEONS] Will be stingy with chests? " + stingyLoot);
        neverInBiomes = config.get("General", "NeverInBiomeTypes", NEVER_IN_BIOMES, "Dungeons will not generate in these biome types (uses Forge biome dictionary").getStringList();
        ConfigHandler.processBiomeExclusions(neverInBiomes);
        disableAPI = config.get("API", "DisableApiCalls", false, "If true the API is disabled").getBoolean(false);
        System.out.println("[DLDUNGEONS] Will use API? " + !disableAPI);
        noMobChanges = config.get("API", "DontAllowApiOnMobs", false, "If false other mods that use the API can add mobs to the dungeons, if true they cannot.  " + System.lineSeparator() + "(This is good if hand designing custom themes for a mod pack.)").getBoolean(false);
        System.out.println("[DLDUNGEONS] Will allow API base mob change? " + !noMobChanges);
        Builder.setDebugPole(config.get("Debugging", "BuildPole", false, "CHEAT: If true all dungeons will have a giant quarts pole through the middle and be " + System.lineSeparator() + "surrounded by a boarder of floating llapis,  This is to make " + System.lineSeparator() + "them easy to find when testing.").getBoolean(false));
        MapMatrix.setDrawFlyingMap(config.get("Debugging", "BuildFlyingMap", false, "CHEAT: If true the layout of the dungeon will be built from floating glowstone (etc.) " + System.lineSeparator() + "-- on some versions it also causes *EXTREME LAG*!").getBoolean(false));
        profile = config.get("Debugging", "AutoProfilingOn", false, "If true reports on dungeon planning and build times will be exproted to files and the commandline").getBoolean(false);
        System.out.println("[DLDUNGEONS] Will self-profile? " + profile);
        stingyLoot = false;
        config.addCustomCategoryComment("Loot", "This will change the value and quantity of loo; be careful, too " + System.lineSeparator() + "could cause a crash if there isn't enough room in the chest.  " + System.lineSeparator() + "The basic chest formula is for the whole cheset, the treasure " + System.lineSeparator() + "chest formula is per loot normal category -- you get 3 time that " + System.lineSeparator() + "many items.");
        int a = config.getInt("A1", "Loot", 2, 0, 9, "Part of the loot quantity numbers for basic chests; " + System.lineSeparator() + " random.nextInt(A1 + (RoomDifficulty / B1)) + C1");
        int b = config.getInt("B1", "Loot", 1, 0, 9, "Part of the loot quantity numbers for basic chests; " + System.lineSeparator() + " random.nextInt(A1 + (RoomDifficulty / B1)) + C1");
        int c = config.getInt("C1", "Loot", 2, 0, 9, "Part of the loot quantity numbers for basic chests; " + System.lineSeparator() + " random.nextInt(A1 + (RoomDifficulty / B1)) + C1");
        BasicChest.setBasicLootNumbers(a, b, c);
        a = config.getInt("A2", "Loot", 3, 0, 9, "Part of the loot quantity numbers for treasure chests; " + System.lineSeparator() + " random.nextInt(A2 + (RoomDifficulty / B2)) + C2");
        b = config.getInt("B2", "Loot", 2, 0, 9, "Part of the loot quantity numbers for treasure chests; " + System.lineSeparator() + " random.nextInt(A2 + (RoomDifficulty / B2)) + C2");
        c = config.getInt("C2", "Loot", 2, 0, 9, "Part of the loot quantity numbers for treasure chests; " + System.lineSeparator() + " random.nextInt(A2 + (RoomDifficulty / B2)) + C2");
        TreasureChest.setTreasureLootNumbers(a, b, c);
        Room.setLootBonus(config.getInt("Loot Bonus", "Loot", 0, -9, 9, "This modifies the room difficulty, in case you think default is " + System.lineSeparator() + "too generous or too stingy."));
        ConfigHandler.openThemesDir();
        config.save();
    }

    protected static void reload() {
        ConfigHandler.init();
    }

    public static void generateLists() {
        if (!writeLists) {
            return;
        }
        listsDir = new File(configDir.toString() + File.separator + "lists");
        if (!listsDir.exists()) {
            listsDir.mkdir();
        }
        if (!listsDir.exists()) {
            System.out.println("[DLDUNGEONS] Warning: Could not create " + listsDir + ".");
        } else if (!listsDir.isDirectory()) {
            System.out.println("[DLDUNGEONS] Warning: " + listsDir + " is not a directory (folder); no themes loaded.");
        } else {
            ConfigHandler.listMobs();
            ConfigHandler.listItems();
            ConfigHandler.listBlocks();
        }
    }

    public static void listMobs() {
        ArrayList mobNames = new ArrayList();
        mobNames.addAll(EntityList.field_75625_b.keySet());
        Collections.sort(mobNames);
        BufferedWriter outstream = null;
        File moblist = new File(listsDir.toString() + File.separator + "mobs.txt");
        if (moblist.exists()) {
            moblist.delete();
        }
        try {
            outstream = new BufferedWriter(new FileWriter(moblist.toString()));
            for (String name : mobNames) {
                Class A = (Class)EntityList.field_75625_b.get(name);
                if (!EntityLiving.class.isAssignableFrom(A) || Modifier.isAbstract(A.getModifiers())) continue;
                outstream.write(name);
                outstream.newLine();
            }
            if (outstream != null) {
                outstream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void listItems() {
        BufferedWriter outstream = null;
        File itemlist = new File(listsDir.toString() + File.separator + "itmes.txt");
        if (itemlist.exists()) {
            itemlist.delete();
        }
        try {
            outstream = new BufferedWriter(new FileWriter(itemlist.toString()));
            if (outstream == null) {
                throw new IOException();
            }
            for (Object item : Item.field_150901_e) {
                String name = Item.field_150901_e.func_148750_c(item);
                String id = "     ID = " + Integer.toString(Item.field_150901_e.func_148757_b(item));
                outstream.write(name);
                outstream.write(id);
                outstream.newLine();
            }
            if (outstream != null) {
                outstream.close();
            }
        }
        catch (IOException e) {
            System.err.println("[DLDUNGEONS] Error: Could not write file items.txt");
            e.printStackTrace();
        }
    }

    public static void listBlocks() {
        BufferedWriter outstream = null;
        File itemlist = new File(listsDir.toString() + File.separator + "blocks.txt");
        if (itemlist.exists()) {
            itemlist.delete();
        }
        try {
            outstream = new BufferedWriter(new FileWriter(itemlist.toString()));
            for (Object block : Block.field_149771_c) {
                String name = Block.field_149771_c.func_148750_c(block);
                outstream.write(name);
                outstream.newLine();
            }
            if (outstream != null) {
                outstream.close();
            }
        }
        catch (IOException e) {
            System.err.println("[DLDUNGEONS] Error: Could not write file blocks.txt");
            e.printStackTrace();
        }
    }

    private static void openThemesDir() {
        File nbtconf;
        Externalizer exporter;
        String themesDirName = configDir.toString() + File.separator + "themes" + File.separator;
        System.out.println("[DLDUNGEONS] themesdir will be set to " + themesDirName);
        themesDir = new File(themesDirName);
        System.out.println("[DLDUNGEONS] themesdir File is be set to " + themesDir);
        if (!themesDir.exists()) {
            themesDir.mkdir();
        }
        if (!themesDir.exists()) {
            System.out.println("[DLDUNGEONS] Warning: Could not create " + themesDirName + ".");
        } else if (!themesDir.isDirectory()) {
            System.out.println("[DLDUNGEONS] Warning: " + themesDirName + " is not a directory (folder); no themes loaded.");
        } else {
            ThemeReader.setThemesDir(themesDir);
        }
        File chests = new File(configDir.toString() + File.separator + "chest.cfg");
        if (!chests.exists()) {
            exporter = new Externalizer(configDir.toString() + File.separator);
            exporter.makeChestCfg();
        }
        if (!(nbtconf = new File(configDir.toString() + File.separator + "nbt.cfg")).exists()) {
            exporter = new Externalizer(configDir.toString() + File.separator);
            exporter.makeNBTCfg();
        }
    }

    protected static void parseDiff(int diff) {
        switch (diff) {
            case 0: {
                difficulty = Difficulty.NONE;
                break;
            }
            case 1: {
                difficulty = Difficulty.BABY;
                break;
            }
            case 2: {
                difficulty = Difficulty.NOOB;
                break;
            }
            case 4: {
                difficulty = Difficulty.HARD;
                break;
            }
            case 5: {
                difficulty = Difficulty.NUTS;
                break;
            }
            default: {
                difficulty = Difficulty.NORM;
            }
        }
    }

    public static File findConfigDir(File fd) {
        File out = new File(fd.toString() + File.separator + "DLDungeonsJBG");
        if (!out.exists()) {
            out.mkdir();
        }
        if (!out.exists()) {
            System.err.println("[DLDUNGEONS] ERROR: Could not create config directory");
        } else if (!out.isDirectory()) {
            System.err.println("[DLDUNGEONS] ERROR: Config directory is not a directory!");
        } else {
            configDir = out;
            ThemeReader.setConfigDir(out);
        }
        return out;
    }

    private static void processBiomeExclusions(String[] array) {
        for (String str : array) {
            str = str.toUpperCase();
            System.out.println("[DLDUNGEONS] adding " + str + " to excusion list");
            try {
                BiomeDictionary.Type value = BiomeDictionary.Type.valueOf((String)str);
                if (value == null) continue;
                biomeExclusions.add(value);
            }
            catch (Exception e) {
                System.err.println("[DLDUNGEONS] Error in config! " + str + " is not valid biome dictionary type!");
                e.printStackTrace();
            }
        }
    }

    public static String getConfigDir() {
        return configDir + File.separator;
    }

    static {
        DEFAULT_DIMS = new int[]{0, -1};
        disableAPI = false;
        noMobChanges = false;
        NEVER_IN_BIOMES = new String[]{"END"};
        neverInBiomes = NEVER_IN_BIOMES;
        biomeExclusions = new HashSet();
        writeLists = false;
        naturalSpawn = true;
        obeyRule = true;
        positiveDims = true;
        easyFind = false;
        announceCommands = true;
        vanillaLoot = false;
        stingyLoot = false;
        thinSpawners = true;
        installThemes = true;
        installCmd = true;
    }
}

