/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import jaredbgreat.dldungeons.ConfigHandler;
import jaredbgreat.dldungeons.builder.Builder;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;

public class GenerationHandler
implements IWorldGenerator {
    private static int frequency;
    private static int factor;
    private static int minXZ;
    private static Random mrand;
    private static HashSet<Integer> dimensions;

    public GenerationHandler() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)100);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        BiomeDictionary.Type[] types;
        if (world.field_72995_K) {
            return;
        }
        if (ConfigHandler.obeyRule && !world.func_72912_H().func_76089_r() || !ConfigHandler.naturalSpawn) {
            return;
        }
        boolean blockedBiome = false;
        for (BiomeDictionary.Type type : types = BiomeDictionary.getTypesForBiome((BiomeGenBase)world.func_72807_a(chunkX * 16 + 8, chunkZ * 16 + 8))) {
            blockedBiome = ConfigHandler.biomeExclusions.contains(type) || blockedBiome;
        }
        if (blockedBiome) {
            return;
        }
        if (dimensions.contains(world.field_73011_w.field_76574_g) != ConfigHandler.positiveDims) {
            return;
        }
        if (Math.abs(chunkX - world.func_72861_E().field_71574_a / 16) < minXZ || Math.abs(chunkZ - world.func_72861_E().field_71573_c / 16) < minXZ) {
            return;
        }
        mrand = new Random(world.func_72905_C() + (long)world.field_73011_w.field_76574_g + 2027L * (long)(chunkX / factor) + 1987L * (long)(chunkZ / factor));
        int xrand = mrand.nextInt();
        int zrand = mrand.nextInt();
        int xuse = (chunkX + xrand) % factor;
        int zuse = (chunkZ + zrand) % factor;
        if (xuse == 0 && zuse == 0) {
            try {
                Builder.placeDungeon(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
            }
            catch (Throwable e) {
                System.err.println("[DLDUNGEONS] Danger!  Failed to finalize a dungeon after building!");
                e.printStackTrace();
            }
        }
    }

    public static void setFrequency(int freqScale) {
        factor = freqScale % 2 == 0 ? 2 : 3;
        System.out.println("freqScale = " + freqScale);
        factor = (1 << freqScale / 2) * factor;
        System.out.println("factor = " + factor);
    }

    public static void setMinXZ(int value) {
        minXZ = value;
    }

    public static void setDimensions(int[] value) {
        dimensions = new HashSet();
        for (int i = 0; i < value.length; ++i) {
            dimensions.add(value[i]);
        }
    }

    public static void addDimension(int value) {
        dimensions.add(value);
    }

    public static void subDimension(int value) {
        dimensions.remove(value);
    }

    static {
        factor = 6;
    }
}

